/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context;

import jakarta.faces.FacesWrapper;
import jakarta.faces.component.UIComponent;
import jakarta.faces.event.ExceptionQueuedEventContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.view.facelets.LocationAware;
import org.apache.myfaces.view.facelets.el.ContextAware;

public class ExceptionHandlerUtils {
    public static void logException(ExceptionQueuedEventContext event, Logger logger) {
        Throwable exception = event.getException();
        while (exception instanceof FacesWrapper) {
            exception = (Throwable)((FacesWrapper)exception).getWrapped();
        }
        String msg = exception.getClass().getName() + " occured while processing " + event.getPhaseId().getName();
        String location = ExceptionHandlerUtils.buildLocation(event.getException(), event.getComponent());
        if (location != null) {
            msg = msg + " [Location=" + location + "]";
        }
        logger.log(Level.SEVERE, msg, exception);
    }

    public static String buildLocation(Throwable ex, UIComponent component) {
        LocationAware laex;
        ContextAware caex;
        Object location = "";
        if (ex instanceof ContextAware) {
            caex = (ContextAware)((Object)ex);
            location = caex.getLocation().toString() + ", " + caex.getQName() + "=\"" + caex.getExpressionString() + "\"";
        } else if (ex instanceof LocationAware && (laex = (LocationAware)((Object)ex)).getLocation() != null) {
            location = laex.getLocation().toString();
        }
        while (ex.getCause() != null) {
            if ((ex = ex.getCause()) instanceof ContextAware) {
                caex = (ContextAware)((Object)ex);
                location = caex.getLocation().toString() + ", " + caex.getQName() + "=\"" + caex.getExpressionString() + "\"";
                continue;
            }
            if (!(ex instanceof LocationAware) || (laex = (LocationAware)((Object)ex)).getLocation() == null) continue;
            location = laex.getLocation().toString();
        }
        if (component != null) {
            if (!((String)location).isBlank()) {
                location = (String)location + ", ";
            }
            location = (String)location + "clientId=\"" + component.getClientId() + "\"";
        }
        return location;
    }
}

