/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import jakarta.servlet.ServletException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.file.ConfigurationSource;

public class ParameterLimitValve
extends ValveBase {
    protected Map<Pattern, Integer> urlPatternLimits = new ConcurrentHashMap<Pattern, Integer>();
    protected String resourcePath = "parameter_limit.config";
    protected boolean context = false;

    public ParameterLimitValve() {
        super(true);
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.containerLog = LogFactory.getLog(this.getContainer().getLogName() + ".parameterLimit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startInternal() throws LifecycleException {
        InputStream is;
        block29: {
            super.startInternal();
            is = null;
            if (this.getContainer() instanceof Context) {
                this.context = true;
                String webInfResourcePath = "/WEB-INF/" + this.resourcePath;
                is = ((Context)this.getContainer()).getServletContext().getResourceAsStream(webInfResourcePath);
                if (this.containerLog.isDebugEnabled()) {
                    if (is == null) {
                        this.containerLog.debug(sm.getString("parameterLimitValve.noConfiguration", webInfResourcePath));
                    } else {
                        this.containerLog.debug(sm.getString("parameterLimitValve.readConfiguration", webInfResourcePath));
                    }
                }
            } else {
                String resourceName = Container.getConfigPath(this.getContainer(), this.resourcePath);
                try {
                    ConfigurationSource.Resource resource = ConfigFileLoader.getSource().getResource(resourceName);
                    is = resource.getInputStream();
                }
                catch (IOException e) {
                    if (!this.containerLog.isDebugEnabled()) break block29;
                    this.containerLog.debug(sm.getString("parameterLimitValve.noConfiguration", resourceName), e);
                }
            }
        }
        if (is == null) {
            return;
        }
        try (InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(isr);){
            this.setUrlPatternLimits(reader);
        }
        catch (IOException ioe) {
            this.containerLog.error(sm.getString("parameterLimitValve.closeError"), ioe);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                this.containerLog.error(sm.getString("parameterLimitValve.closeError"), e);
            }
        }
    }

    public void setUrlPatternLimits(String urlPatternConfig) {
        this.urlPatternLimits.clear();
        this.setUrlPatternLimits(new BufferedReader(new StringReader(urlPatternConfig)));
    }

    public void setUrlPatternLimits(BufferedReader reader) {
        if (this.containerLog == null && this.getContainer() != null) {
            this.containerLog = LogFactory.getLog(this.getContainer().getLogName() + ".parameterLimit");
        }
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                int lastEqualsIndex = line.lastIndexOf(61);
                if (lastEqualsIndex == -1) {
                    throw new IllegalArgumentException(sm.getString("parameterLimitValve.invalidLine", line));
                }
                String patternString = line.substring(0, lastEqualsIndex).trim();
                String limitString = line.substring(lastEqualsIndex + 1).trim();
                Pattern pattern = Pattern.compile(UDecoder.URLDecode(patternString, StandardCharsets.UTF_8));
                int limit = Integer.parseInt(limitString);
                if (this.containerLog != null && this.containerLog.isTraceEnabled()) {
                    this.containerLog.trace("Add pattern " + String.valueOf(pattern) + " and limit " + limit);
                }
                this.urlPatternLimits.put(pattern, limit);
            }
        }
        catch (IOException e) {
            this.containerLog.error(sm.getString("parameterLimitValve.readError"), e);
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.urlPatternLimits.clear();
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.urlPatternLimits == null || this.urlPatternLimits.isEmpty()) {
            this.getNext().invoke(request, response);
            return;
        }
        String requestURI = this.context ? request.getRequestPathMB().toString() : request.getDecodedRequestURI();
        for (Map.Entry<Pattern, Integer> entry : this.urlPatternLimits.entrySet()) {
            Pattern pattern = entry.getKey();
            int limit = entry.getValue();
            if (!pattern.matcher(requestURI).matches()) continue;
            request.setMaxParameterCount(limit);
            break;
        }
        this.getNext().invoke(request, response);
    }
}

