/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.WebConnection;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import org.apache.coyote.http11.upgrade.InternalHttpUpgradeHandler;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.WsIOException;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.server.WsFrameServer;
import org.apache.tomcat.websocket.server.WsHandshakeRequest;
import org.apache.tomcat.websocket.server.WsRemoteEndpointImplServer;
import org.apache.tomcat.websocket.server.WsServerContainer;

public class WsHttpUpgradeHandler
implements InternalHttpUpgradeHandler {
    private static final Log log = LogFactory.getLog(WsHttpUpgradeHandler.class);
    private static final StringManager sm = StringManager.getManager(WsHttpUpgradeHandler.class);
    private final ClassLoader applicationClassLoader = Thread.currentThread().getContextClassLoader();
    private SocketWrapperBase<?> socketWrapper;
    private Endpoint ep;
    private EndpointConfig endpointConfig;
    private WsServerContainer webSocketContainer;
    private WsHandshakeRequest handshakeRequest;
    private List<Extension> negotiatedExtensions;
    private String subProtocol;
    private Transformation transformation;
    private Map<String, String> pathParameters;
    private boolean secure;
    private WebConnection connection;
    private WsRemoteEndpointImplServer wsRemoteEndpointServer;
    private WsFrameServer wsFrame;
    private WsSession wsSession;

    public void setSocketWrapper(SocketWrapperBase<?> socketWrapper) {
        this.socketWrapper = socketWrapper;
    }

    public void preInit(Endpoint ep, EndpointConfig endpointConfig, WsServerContainer wsc, WsHandshakeRequest handshakeRequest, List<Extension> negotiatedExtensionsPhase2, String subProtocol, Transformation transformation, Map<String, String> pathParameters, boolean secure) {
        this.ep = ep;
        this.endpointConfig = endpointConfig;
        this.webSocketContainer = wsc;
        this.handshakeRequest = handshakeRequest;
        this.negotiatedExtensions = negotiatedExtensionsPhase2;
        this.subProtocol = subProtocol;
        this.transformation = transformation;
        this.pathParameters = pathParameters;
        this.secure = secure;
    }

    public void init(WebConnection connection) {
        if (this.ep == null) {
            throw new IllegalStateException(sm.getString("wsHttpUpgradeHandler.noPreInit"));
        }
        String httpSessionId = null;
        Object session = this.handshakeRequest.getHttpSession();
        if (session != null) {
            httpSessionId = ((HttpSession)session).getId();
        }
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        t.setContextClassLoader(this.applicationClassLoader);
        try {
            this.wsRemoteEndpointServer = new WsRemoteEndpointImplServer(this.socketWrapper, this.webSocketContainer);
            this.wsSession = new WsSession(this.ep, this.wsRemoteEndpointServer, this.webSocketContainer, this.handshakeRequest.getRequestURI(), this.handshakeRequest.getParameterMap(), this.handshakeRequest.getQueryString(), this.handshakeRequest.getUserPrincipal(), httpSessionId, this.negotiatedExtensions, this.subProtocol, this.pathParameters, this.secure, this.endpointConfig);
            this.wsFrame = new WsFrameServer(this.socketWrapper, this.wsSession, this.transformation);
            this.wsRemoteEndpointServer.setTransformation(this.wsFrame.getTransformation());
            this.ep.onOpen(this.wsSession, this.endpointConfig);
            this.webSocketContainer.registerSession(this.ep, this.wsSession);
        }
        catch (DeploymentException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            t.setContextClassLoader(cl);
        }
    }

    public AbstractEndpoint.Handler.SocketState upgradeDispatch(SocketEvent status) {
        switch (status) {
            case OPEN_READ: {
                try {
                    this.wsFrame.onDataAvailable();
                }
                catch (WsIOException ws) {
                    this.close(ws.getCloseReason());
                }
                catch (EOFException eof) {
                    CloseReason cr = new CloseReason(CloseReason.CloseCodes.CLOSED_ABNORMALLY, eof.getMessage());
                    this.close(cr);
                }
                catch (IOException ioe) {
                    this.onError(ioe);
                    CloseReason cr = new CloseReason(CloseReason.CloseCodes.CLOSED_ABNORMALLY, ioe.getMessage());
                    this.close(cr);
                }
                break;
            }
            case OPEN_WRITE: {
                this.wsRemoteEndpointServer.onWritePossible(false);
                break;
            }
            case STOP: {
                CloseReason cr = new CloseReason(CloseReason.CloseCodes.GOING_AWAY, sm.getString("wsHttpUpgradeHandler.serverStop"));
                try {
                    this.wsSession.close(cr);
                }
                catch (IOException ioe) {
                    this.onError(ioe);
                    cr = new CloseReason(CloseReason.CloseCodes.CLOSED_ABNORMALLY, ioe.getMessage());
                    this.close(cr);
                }
                break;
            }
            case ERROR: {
                String msg = sm.getString("wsHttpUpgradeHandler.closeOnError");
                this.wsSession.doClose(new CloseReason(CloseReason.CloseCodes.GOING_AWAY, msg), new CloseReason(CloseReason.CloseCodes.CLOSED_ABNORMALLY, msg));
            }
            case DISCONNECT: 
            case TIMEOUT: {
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
        }
        if (this.wsFrame.isOpen()) {
            return AbstractEndpoint.Handler.SocketState.UPGRADED;
        }
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    public void pause() {
    }

    public void destroy() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                log.error((Object)sm.getString("wsHttpUpgradeHandler.destroyFailed"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(Throwable throwable) {
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        t.setContextClassLoader(this.applicationClassLoader);
        try {
            this.ep.onError(this.wsSession, throwable);
        }
        finally {
            t.setContextClassLoader(cl);
        }
    }

    private void close(CloseReason cr) {
        this.wsSession.onClose(cr);
    }

    public void setSslSupport(SSLSupport sslSupport) {
    }
}

