/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.io.File;
import java.io.IOException;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.TestHelper;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.IO;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class WriteTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Object, Object> get_g_io_writeXkryoX(String var1) throws IOException;

    public abstract Traversal<Object, Object> get_g_io_write_withXwriter_gryoX(String var1) throws IOException;

    public abstract Traversal<Object, Object> get_g_io_writeXjsonX(String var1) throws IOException;

    public abstract Traversal<Object, Object> get_g_io_write_withXwriter_graphsonX(String var1) throws IOException;

    public abstract Traversal<Object, Object> get_g_io_writeXxmlX(String var1) throws IOException;

    public abstract Traversal<Object, Object> get_g_io_write_withXwriter_graphmlX(String var1) throws IOException;

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="IoWrite")
    public void g_io_writeXkryoX() throws IOException {
        String fileToWrite = TestHelper.generateTempFile(WriteTest.class, (String)"tinkerpop-modern-v3", (String)".kryo").getAbsolutePath().replace('\\', '/');
        File f = new File(fileToWrite);
        MatcherAssert.assertThat((Object)(f.length() == 0L ? 1 : 0), (Matcher)Is.is((Object)true));
        Traversal<Object, Object> traversal = this.get_g_io_writeXkryoX(fileToWrite);
        this.printTraversalForm(traversal);
        traversal.iterate();
        MatcherAssert.assertThat((Object)(f.length() > 0L ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="IoWrite")
    public void g_io_write_withXwrite_gryoX() throws IOException {
        String fileToWrite = TestHelper.generateTempFile(WriteTest.class, (String)"tinkerpop-modern-v3", (String)".kryo").getAbsolutePath().replace('\\', '/');
        File f = new File(fileToWrite);
        MatcherAssert.assertThat((Object)(f.length() == 0L ? 1 : 0), (Matcher)Is.is((Object)true));
        Traversal<Object, Object> traversal = this.get_g_io_write_withXwriter_gryoX(fileToWrite);
        this.printTraversalForm(traversal);
        traversal.iterate();
        MatcherAssert.assertThat((Object)(f.length() > 0L ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="IoWrite")
    public void g_io_writeXjsonX() throws IOException {
        String fileToWrite = TestHelper.generateTempFile(WriteTest.class, (String)"tinkerpop-modern-v3", (String)".json").getAbsolutePath().replace('\\', '/');
        File f = new File(fileToWrite);
        MatcherAssert.assertThat((Object)(f.length() == 0L ? 1 : 0), (Matcher)Is.is((Object)true));
        Traversal<Object, Object> traversal = this.get_g_io_writeXjsonX(fileToWrite);
        this.printTraversalForm(traversal);
        traversal.iterate();
        MatcherAssert.assertThat((Object)(f.length() > 0L ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="IoWrite")
    public void g_io_write_withXwriter_graphsonX() throws IOException {
        String fileToWrite = TestHelper.generateTempFile(WriteTest.class, (String)"tinkerpop-modern-v3", (String)".json").getAbsolutePath().replace('\\', '/');
        File f = new File(fileToWrite);
        MatcherAssert.assertThat((Object)(f.length() == 0L ? 1 : 0), (Matcher)Is.is((Object)true));
        Traversal<Object, Object> traversal = this.get_g_io_write_withXwriter_graphsonX(fileToWrite);
        this.printTraversalForm(traversal);
        traversal.iterate();
        MatcherAssert.assertThat((Object)(f.length() > 0L ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="IoWrite")
    public void g_io_writeXxmlX() throws IOException {
        String fileToWrite = TestHelper.generateTempFile(WriteTest.class, (String)"tinkerpop-modern", (String)".xml").getAbsolutePath().replace('\\', '/');
        File f = new File(fileToWrite);
        MatcherAssert.assertThat((Object)(f.length() == 0L ? 1 : 0), (Matcher)Is.is((Object)true));
        Traversal<Object, Object> traversal = this.get_g_io_writeXxmlX(fileToWrite);
        this.printTraversalForm(traversal);
        traversal.iterate();
        MatcherAssert.assertThat((Object)(f.length() > 0L ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="IoWrite")
    public void g_io_write_withXwriter_graphmlX() throws IOException {
        String fileToWrite = TestHelper.generateTempFile(WriteTest.class, (String)"tinkerpop-modern", (String)".xml").getAbsolutePath().replace('\\', '/');
        File f = new File(fileToWrite);
        MatcherAssert.assertThat((Object)(f.length() == 0L ? 1 : 0), (Matcher)Is.is((Object)true));
        Traversal<Object, Object> traversal = this.get_g_io_write_withXwriter_graphmlX(fileToWrite);
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
        MatcherAssert.assertThat((Object)(f.length() > 0L ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    public static class Traversals
    extends WriteTest {
        @Override
        public Traversal<Object, Object> get_g_io_writeXkryoX(String fileToWrite) throws IOException {
            return this.g.io(fileToWrite).write();
        }

        @Override
        public Traversal<Object, Object> get_g_io_write_withXwriter_gryoX(String fileToWrite) throws IOException {
            return this.g.io(fileToWrite).with(IO.writer, (Object)"gryo").write();
        }

        @Override
        public Traversal<Object, Object> get_g_io_writeXjsonX(String fileToWrite) throws IOException {
            return this.g.io(fileToWrite).write();
        }

        @Override
        public Traversal<Object, Object> get_g_io_write_withXwriter_graphsonX(String fileToWrite) throws IOException {
            return this.g.io(fileToWrite).with(IO.writer, (Object)"graphson").write();
        }

        @Override
        public Traversal<Object, Object> get_g_io_writeXxmlX(String fileToWrite) throws IOException {
            return this.g.io(fileToWrite).write();
        }

        @Override
        public Traversal<Object, Object> get_g_io_write_withXwriter_graphmlX(String fileToWrite) throws IOException {
            return this.g.io(fileToWrite).with(IO.writer, (Object)"graphml").write();
        }
    }
}

