/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalInterruptedException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TraversalInterruptionComputerTest
extends AbstractGremlinProcessTest {
    @Parameterized.Parameter(value=0)
    public String name;
    @Parameterized.Parameter(value=1)
    public Function<GraphTraversalSource, GraphTraversal<?, ?>> traversalMaker;

    @Parameterized.Parameters(name="expectInterruption({0})")
    public static Iterable<Object[]> data() {
        return Arrays.asList({"g_V", g -> g.V(new Object[0])}, {"g_V_out", g -> g.V(new Object[0]).out(new String[0])}, {"g_V_outE", g -> g.V(new Object[0]).outE(new String[0])}, {"g_V_in", g -> g.V(new Object[0]).in(new String[0])}, {"g_V_inE", g -> g.V(new Object[0]).inE(new String[0])}, {"g_V_properties", g -> g.V(new Object[0]).properties(new String[0])}, {"g_E", g -> g.E(new Object[0])}, {"g_E_outV", g -> g.E(new Object[0]).outV()}, {"g_E_inV", g -> g.E(new Object[0]).inV()}, {"g_E_properties", g -> g.E(new Object[0]).properties(new String[0])});
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.GRATEFUL)
    public void shouldRespectThreadInterruptionInVertexStep() throws Exception {
        AtomicBoolean exceptionThrown = new AtomicBoolean(false);
        CountDownLatch startedIterating = new CountDownLatch(1);
        Thread t = new Thread(() -> {
            try {
                GraphTraversal traversal = this.traversalMaker.apply(this.g).sideEffect(traverser -> {
                    startedIterating.countDown();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                });
                traversal.iterate();
            }
            catch (Exception ex) {
                exceptionThrown.set(ex instanceof TraversalInterruptedException);
            }
        }, this.name);
        t.start();
        Assert.assertThat((Object)startedIterating.await(5000L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)true));
        t.interrupt();
        t.join();
        Assert.assertThat((Object)exceptionThrown.get(), (Matcher)CoreMatchers.is((Object)true));
    }
}

