/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.MutationListener;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.EventStrategy;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceEdge;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceFactory;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertex;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;

public class EventStrategyProcessTest
extends AbstractGremlinProcessTest {
    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldTriggerAddVertex() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        this.graph.addVertex(new Object[]{"some", "thing"});
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[0]).addV().property((Object)"any", (Object)"thing", new Object[0]).next();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)gts.V(new Object[0]).has("any", (Object)"thing"))));
        Assert.assertEquals((long)1L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.addVertexEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldTriggerAddVertexFromStart() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        this.graph.addVertex(new Object[]{"some", "thing"});
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.addV().property((Object)"any", (Object)"thing", new Object[0]).next();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)gts.V(new Object[0]).has("any", (Object)"thing"))));
        Assert.assertEquals((long)1L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.addVertexEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldTriggerAddEdge() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        Vertex v = this.graph.addVertex(new Object[0]);
        v.addEdge("self", v, new Object[0]);
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).as("v", new String[0]).addE("self").to("v").next();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)gts.E(new Object[0]))));
        Assert.assertEquals((long)0L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)0L, (long)listener2.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener1.addEdgeEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.addEdgeEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldTriggerAddEdgeByPath() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        Vertex v = this.graph.addVertex(new Object[0]);
        v.addEdge("self", v, new Object[0]);
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).as("a", new String[0]).addE("self").to("a").next();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)gts.E(new Object[0]))));
        Assert.assertEquals((long)0L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)0L, (long)listener2.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener1.addEdgeEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.addEdgeEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldTriggerAddVertexPropertyAdded() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        Vertex vSome = this.graph.addVertex(new Object[]{"some", "thing"});
        vSome.property(VertexProperty.Cardinality.single, "that", (Object)"thing", new Object[0]);
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[0]).addV().property((Object)"this", (Object)"thing", new Object[0]).next();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)gts.V(new Object[0]).has("this", (Object)"thing"))));
        Assert.assertEquals((long)1L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.addVertexEventRecorded());
        Assert.assertEquals((long)0L, (long)listener2.vertexPropertyChangedEventRecorded());
        Assert.assertEquals((long)0L, (long)listener1.vertexPropertyChangedEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldTriggerAddVertexWithPropertyThenPropertyAdded() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        Vertex vSome = this.graph.addVertex(new Object[]{"some", "thing"});
        vSome.property(VertexProperty.Cardinality.single, "that", (Object)"thing", new Object[0]);
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[0]).addV().property((Object)"any", (Object)"thing", new Object[0]).property(VertexProperty.Cardinality.single, (Object)"this", (Object)"thing", new Object[0]).next();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)gts.V(new Object[0]).has("this", (Object)"thing"))));
        Assert.assertEquals((long)1L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.vertexPropertyChangedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener1.vertexPropertyChangedEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldTriggerAddVertexPropertyChanged() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        Vertex vSome = this.graph.addVertex(new Object[]{"some", "thing"});
        vSome.property(VertexProperty.Cardinality.single, "that", (Object)"thing", new Object[0]);
        GraphTraversalSource gts = this.create(eventStrategy);
        Vertex vAny = (Vertex)gts.V(new Object[0]).addV().property((Object)"any", (Object)"thing", new Object[0]).next();
        gts.V(new Object[]{vAny}).property(VertexProperty.Cardinality.single, (Object)"any", (Object)"thing else", new Object[0]).next();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)gts.V(new Object[0]).has("any", (Object)"thing else"))));
        Assert.assertEquals((long)1L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.vertexPropertyChangedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener1.vertexPropertyChangedEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldTriggerAddVertexPropertyPropertyChanged() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        Vertex vSome = this.graph.addVertex(new Object[]{"some", "thing"});
        vSome.property(VertexProperty.Cardinality.single, "that", (Object)"thing", new Object[]{"is", "good"});
        GraphTraversalSource gts = this.create(eventStrategy);
        Vertex vAny = (Vertex)gts.V(new Object[0]).addV().property((Object)"any", (Object)"thing", new Object[0]).next();
        gts.V(new Object[]{vAny}).properties(new String[]{"any"}).property((Object)"is", (Object)"bad", new Object[0]).next();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)gts.V(new Object[0]).has("any", (Object)"thing"))));
        Assert.assertEquals((long)1L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.vertexPropertyPropertyChangedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener1.vertexPropertyPropertyChangedEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldTriggerAddEdgePropertyAdded() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        Vertex v = this.graph.addVertex(new Object[0]);
        v.addEdge("self", v, new Object[0]);
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).as("v", new String[0]).addE("self").to("v").property((Object)"some", (Object)"thing", new Object[0]).next();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)gts.E(new Object[0]).has("some", (Object)"thing"))));
        Assert.assertEquals((long)0L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)0L, (long)listener2.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener1.addEdgeEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.addEdgeEventRecorded());
        Assert.assertEquals((long)0L, (long)listener2.edgePropertyChangedEventRecorded());
        Assert.assertEquals((long)0L, (long)listener1.edgePropertyChangedEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldTriggerEdgePropertyChanged() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e = v.addEdge("self", v, new Object[0]);
        e.property("some", (Object)"thing");
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.E(new Object[]{e}).property((Object)"some", (Object)"other thing", new Object[0]).next();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)gts.E(new Object[0]).has("some", (Object)"other thing"))));
        Assert.assertEquals((long)0L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)0L, (long)listener2.addVertexEventRecorded());
        Assert.assertEquals((long)0L, (long)listener1.addEdgeEventRecorded());
        Assert.assertEquals((long)0L, (long)listener2.addEdgeEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.edgePropertyChangedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener1.edgePropertyChangedEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveVertices")
    public void shouldTriggerRemoveVertex() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        this.graph.addVertex(new Object[]{"some", "thing"});
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[0]).drop().iterate();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)gts.V(new Object[0]))));
        Assert.assertEquals((long)1L, (long)listener1.vertexRemovedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.vertexRemovedEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="RemoveEdges")
    public void shouldTriggerRemoveEdge() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        Vertex v = this.graph.addVertex(new Object[]{"some", "thing"});
        v.addEdge("self", v, new Object[0]);
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.E(new Object[0]).drop().iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)listener1.edgeRemovedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.edgeRemovedEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveProperty")
    public void shouldTriggerRemoveVertexProperty() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        this.graph.addVertex(new Object[]{"some", "thing"});
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[0]).properties(new String[0]).drop().iterate();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)gts.V(new Object[0]).properties(new String[0]))));
        Assert.assertEquals((long)1L, (long)listener1.vertexPropertyRemovedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.vertexPropertyRemovedEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="RemoveProperty")
    public void shouldTriggerRemoveEdgeProperty() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        Vertex v = this.graph.addVertex(new Object[0]);
        v.addEdge("self", v, new Object[]{"some", "thing"});
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.E(new Object[0]).properties(new String[0]).drop().iterate();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)gts.E(new Object[0]).properties(new String[0]))));
        Assert.assertEquals((long)1L, (long)listener1.edgePropertyRemovedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.edgePropertyRemovedEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldTriggerAddVertexPropertyPropertyRemoved() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        Vertex vSome = this.graph.addVertex(new Object[]{"some", "thing"});
        vSome.property(VertexProperty.Cardinality.single, "that", (Object)"thing", new Object[]{"is", "good"});
        GraphTraversalSource gts = this.create(eventStrategy);
        Vertex vAny = (Vertex)gts.V(new Object[0]).addV().property((Object)"any", (Object)"thing", new Object[0]).next();
        gts.V(new Object[]{vAny}).properties(new String[]{"any"}).property((Object)"is", (Object)"bad", new Object[0]).next();
        gts.V(new Object[]{vAny}).properties(new String[]{"any"}).properties(new String[]{"is"}).drop().iterate();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)gts.V(new Object[0]).has("any", (Object)"thing"))));
        Assert.assertEquals((long)1L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.vertexPropertyPropertyChangedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener1.vertexPropertyPropertyChangedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.vertexPropertyPropertyRemovedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener1.vertexPropertyPropertyRemovedEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldTriggerAfterCommit() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph)).addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        EventStrategy eventStrategy = builder.create();
        this.graph.addVertex(new Object[]{"some", "thing"});
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[0]).addV().property((Object)"any", (Object)"thing", new Object[0]).next();
        gts.V(new Object[0]).addV().property((Object)"any", (Object)"one", new Object[0]).next();
        Assert.assertEquals((long)0L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)0L, (long)listener2.addVertexEventRecorded());
        gts.tx().commit();
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)gts.V(new Object[0]).has("any")));
        Assert.assertEquals((long)2L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)2L, (long)listener2.addVertexEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldResetAfterRollback() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph)).addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        EventStrategy eventStrategy = builder.create();
        this.graph.addVertex(new Object[]{"some", "thing"});
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[0]).addV().property((Object)"any", (Object)"thing", new Object[0]).next();
        gts.V(new Object[0]).addV().property((Object)"any", (Object)"one", new Object[0]).next();
        Assert.assertEquals((long)0L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)0L, (long)listener2.addVertexEventRecorded());
        gts.tx().rollback();
        MatcherAssert.assertThat((Object)gts.V(new Object[0]).has("any").hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertEquals((long)0L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)0L, (long)listener2.addVertexEventRecorded());
        this.graph.addVertex(new Object[]{"some", "thing"});
        gts.V(new Object[0]).addV().property((Object)"any", (Object)"thing", new Object[0]).next();
        gts.V(new Object[0]).addV().property((Object)"any", (Object)"one", new Object[0]).next();
        Assert.assertEquals((long)0L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)0L, (long)listener2.addVertexEventRecorded());
        gts.tx().commit();
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)gts.V(new Object[0]).has("any")));
        Assert.assertEquals((long)2L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)2L, (long)listener2.addVertexEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldDetachPropertyOfVertexPropertyWhenRemoved() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        VertexProperty vp = v.property("xxx", (Object)"blah");
        final String label = vp.label();
        final Object value = vp.value();
        Property p = vp.property("to-drop", (Object)"dah");
        vp.property("not-dropped", (Object)"yay!");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void vertexPropertyPropertyRemoved(VertexProperty element, Property property) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(DetachedVertexProperty.class));
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)value, (Object)element.value());
                Assert.assertEquals((Object)"dah", (Object)property.value());
                Assert.assertEquals((Object)"to-drop", (Object)property.key());
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).properties(new String[]{"xxx"}).properties(new String[]{"to-drop"}).drop().iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0])));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0]).properties(new String[0])));
        Assert.assertEquals((Object)"yay!", (Object)this.g.V(new Object[]{vp.element()}).properties(new String[]{"xxx"}).values(new String[]{"not-dropped"}).next());
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldDetachPropertyOfVertexPropertyWhenChanged() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        VertexProperty vp = v.property("xxx", (Object)"blah");
        final String label = vp.label();
        final Object value = vp.value();
        vp.property("to-change", (Object)"dah");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void vertexPropertyPropertyChanged(VertexProperty element, Property oldValue, Object setValue) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(DetachedVertexProperty.class));
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)value, (Object)element.value());
                Assert.assertEquals((Object)"dah", (Object)oldValue.value());
                Assert.assertEquals((Object)"to-change", (Object)oldValue.key());
                Assert.assertEquals((Object)"bah", (Object)setValue);
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).properties(new String[]{"xxx"}).property((Object)"to-change", (Object)"bah", new Object[0]).iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0])));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0]).properties(new String[0])));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldDetachPropertyOfVertexPropertyWhenNew() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        VertexProperty vp = v.property("xxx", (Object)"blah");
        final String label = vp.label();
        final Object value = vp.value();
        vp.property("to-change", (Object)"dah");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void vertexPropertyPropertyChanged(VertexProperty element, Property oldValue, Object setValue) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(DetachedVertexProperty.class));
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)value, (Object)element.value());
                Assert.assertEquals(null, (Object)oldValue.value());
                Assert.assertEquals((Object)"new", (Object)oldValue.key());
                Assert.assertEquals((Object)"yay!", (Object)setValue);
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).properties(new String[]{"xxx"}).property((Object)"new", (Object)"yay!", new Object[0]).iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0])));
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0]).properties(new String[0])));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldDetachPropertyOfEdgeWhenRemoved() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e = v.addEdge("self", v, new Object[]{"not-dropped", "yay!"});
        final String label = e.label();
        final Object inId = v.id();
        final Object outId = v.id();
        e.property("to-drop", (Object)"dah");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void edgePropertyRemoved(Edge element, Property property) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(DetachedEdge.class));
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)inId, (Object)element.inVertex().id());
                Assert.assertEquals((Object)outId, (Object)element.outVertex().id());
                Assert.assertEquals((Object)"dah", (Object)property.value());
                Assert.assertEquals((Object)"to-drop", (Object)property.key());
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.E(new Object[]{e}).properties(new String[]{"to-drop"}).drop().iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[]{e}).properties(new String[0])));
        Assert.assertEquals((Object)"yay!", (Object)e.value("not-dropped"));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldDetachPropertyOfEdgeWhenChanged() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e = v.addEdge("self", v, new Object[0]);
        final String label = e.label();
        final Object inId = v.id();
        final Object outId = v.id();
        e.property("to-change", (Object)"no!");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void edgePropertyChanged(Edge element, Property oldValue, Object setValue) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(DetachedEdge.class));
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)inId, (Object)element.inVertex().id());
                Assert.assertEquals((Object)outId, (Object)element.outVertex().id());
                Assert.assertEquals((Object)"no!", (Object)oldValue.value());
                Assert.assertEquals((Object)"to-change", (Object)oldValue.key());
                Assert.assertEquals((Object)"yay!", (Object)setValue);
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.E(new Object[]{e}).property((Object)"to-change", (Object)"yay!", new Object[0]).iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[]{e}).properties(new String[0])));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldDetachPropertyOfEdgeWhenNew() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e = v.addEdge("self", v, new Object[0]);
        final String label = e.label();
        final Object inId = v.id();
        final Object outId = v.id();
        e.property("to-change", (Object)"no!");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void edgePropertyChanged(Edge element, Property oldValue, Object setValue) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(DetachedEdge.class));
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)inId, (Object)element.inVertex().id());
                Assert.assertEquals((Object)outId, (Object)element.outVertex().id());
                Assert.assertEquals(null, (Object)oldValue.value());
                Assert.assertEquals((Object)"new", (Object)oldValue.key());
                Assert.assertEquals((Object)"yay!", (Object)setValue);
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.E(new Object[]{e}).property((Object)"new", (Object)"yay!", new Object[0]).iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[]{e}).properties(new String[0])));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldDetachEdgeWhenRemoved() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e = v.addEdge("self", v, new Object[]{"dropped", "yay!"});
        final String label = e.label();
        final Object inId = v.id();
        final Object outId = v.id();
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void edgeRemoved(Edge element) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(DetachedEdge.class));
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)inId, (Object)element.inVertex().id());
                Assert.assertEquals((Object)outId, (Object)element.outVertex().id());
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.E(new Object[]{e}).drop().iterate();
        this.tryCommit(this.graph);
        EventStrategyProcessTest.assertVertexEdgeCounts(this.graph, 1, 0);
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldDetachEdgeWhenAdded() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        final Object id = v.id();
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void edgeAdded(Edge element) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(DetachedEdge.class));
                Assert.assertEquals((Object)"self", (Object)element.label());
                Assert.assertEquals((Object)id, (Object)element.inVertex().id());
                Assert.assertEquals((Object)id, (Object)element.outVertex().id());
                Assert.assertEquals((Object)"there", (Object)element.value("here"));
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).as("a", new String[0]).addE("self").property((Object)"here", (Object)"there", new Object[0]).from("a").to("a").iterate();
        this.tryCommit(this.graph);
        EventStrategyProcessTest.assertVertexEdgeCounts(this.graph, 1, 1);
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldDetachVertexPropertyWhenRemoved() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        VertexProperty vp = v.property("to-remove", (Object)"blah");
        final String label = vp.label();
        final Object value = vp.value();
        VertexProperty vpToKeep = v.property("to-keep", (Object)"dah");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void vertexPropertyRemoved(VertexProperty element) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(DetachedVertexProperty.class));
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)value, (Object)element.value());
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).properties(new String[]{"to-remove"}).drop().iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0])));
        Assert.assertEquals((Object)vpToKeep.value(), (Object)this.g.V(new Object[]{v}).values(new String[]{"to-keep"}).next());
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldDetachVertexPropertyWhenChanged() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        final String label = v.label();
        final Object id = v.id();
        v.property("to-change", (Object)"blah");
        AbstractMutationListener listener = new AbstractMutationListener(){

            public void vertexPropertyChanged(Vertex element, VertexProperty oldValue, Object setValue, Object ... vertexPropertyKeyValues) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(DetachedVertex.class));
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)id, (Object)element.id());
                Assert.assertEquals((Object)"to-change", (Object)oldValue.key());
                Assert.assertEquals((Object)"blah", (Object)oldValue.value());
                Assert.assertEquals((Object)"dah", (Object)setValue);
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).property(VertexProperty.Cardinality.single, (Object)"to-change", (Object)"dah", new Object[0]).iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0])));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldDetachVertexPropertyWhenNew() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        final String label = v.label();
        final Object id = v.id();
        v.property("old", (Object)"blah");
        AbstractMutationListener listener = new AbstractMutationListener(){

            public void vertexPropertyChanged(Vertex element, VertexProperty oldValue, Object setValue, Object ... vertexPropertyKeyValues) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(DetachedVertex.class));
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)id, (Object)element.id());
                Assert.assertEquals((Object)"new", (Object)oldValue.key());
                Assert.assertEquals(null, (Object)oldValue.value());
                Assert.assertEquals((Object)"dah", (Object)setValue);
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).property(VertexProperty.Cardinality.single, (Object)"new", (Object)"dah", new Object[0]).iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0])));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldDetachVertexPropertyWhenNewDeprecated() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        final String label = v.label();
        final Object id = v.id();
        v.property("old", (Object)"blah");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void vertexPropertyChanged(Vertex element, Property oldValue, Object setValue, Object ... vertexPropertyKeyValues) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(DetachedVertex.class));
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)id, (Object)element.id());
                Assert.assertEquals((Object)"new", (Object)oldValue.key());
                Assert.assertEquals(null, (Object)oldValue.value());
                Assert.assertEquals((Object)"dah", (Object)setValue);
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).property(VertexProperty.Cardinality.single, (Object)"new", (Object)"dah", new Object[0]).iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0])));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldDetachVertexWhenRemoved() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        final String label = v.label();
        final Object id = v.id();
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void vertexRemoved(Vertex element) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(DetachedVertex.class));
                Assert.assertEquals((Object)id, (Object)element.id());
                Assert.assertEquals((Object)label, (Object)element.label());
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).drop().iterate();
        this.tryCommit(this.graph);
        EventStrategyProcessTest.assertVertexEdgeCounts(this.graph, 0, 0);
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldDetachVertexWhenAdded() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void vertexAdded(Vertex element) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(DetachedVertex.class));
                Assert.assertEquals((Object)"thing", (Object)element.label());
                Assert.assertEquals((Object)"there", (Object)element.value("here"));
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.addV("thing").property((Object)"here", (Object)"there", new Object[0]).iterate();
        this.tryCommit(this.graph);
        EventStrategyProcessTest.assertVertexEdgeCounts(this.graph, 1, 0);
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldReferencePropertyOfVertexPropertyWhenRemoved() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        VertexProperty vp = v.property("xxx", (Object)"blah");
        final String label = vp.label();
        final Object value = vp.value();
        Property p = vp.property("to-drop", (Object)"dah");
        vp.property("not-dropped", (Object)"yay!");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void vertexPropertyPropertyRemoved(VertexProperty element, Property property) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(ReferenceVertexProperty.class));
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)value, (Object)element.value());
                Assert.assertEquals((Object)"dah", (Object)property.value());
                Assert.assertEquals((Object)"to-drop", (Object)property.key());
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).properties(new String[]{"xxx"}).properties(new String[]{"to-drop"}).drop().iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0])));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0]).properties(new String[0])));
        Assert.assertEquals((Object)"yay!", (Object)this.g.V(new Object[]{vp.element()}).properties(new String[]{"xxx"}).values(new String[]{"not-dropped"}).next());
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldReferencePropertyOfVertexPropertyWhenChanged() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        VertexProperty vp = v.property("xxx", (Object)"blah");
        final String label = vp.label();
        final Object value = vp.value();
        vp.property("to-change", (Object)"dah");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void vertexPropertyPropertyChanged(VertexProperty element, Property oldValue, Object setValue) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(ReferenceVertexProperty.class));
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)value, (Object)element.value());
                Assert.assertEquals((Object)"dah", (Object)oldValue.value());
                Assert.assertEquals((Object)"to-change", (Object)oldValue.key());
                Assert.assertEquals((Object)"bah", (Object)setValue);
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).properties(new String[]{"xxx"}).property((Object)"to-change", (Object)"bah", new Object[0]).iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0])));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0]).properties(new String[0])));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldReferencePropertyOfVertexPropertyWhenNew() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        VertexProperty vp = v.property("xxx", (Object)"blah");
        final String label = vp.label();
        final Object value = vp.value();
        vp.property("to-change", (Object)"dah");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void vertexPropertyPropertyChanged(VertexProperty element, Property oldValue, Object setValue) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(ReferenceVertexProperty.class));
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)value, (Object)element.value());
                Assert.assertEquals(null, (Object)oldValue.value());
                Assert.assertEquals((Object)"new", (Object)oldValue.key());
                Assert.assertEquals((Object)"yay!", (Object)setValue);
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).properties(new String[]{"xxx"}).property((Object)"new", (Object)"yay!", new Object[0]).iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0])));
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0]).properties(new String[0])));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldReferencePropertyOfEdgeWhenRemoved() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e = v.addEdge("self", v, new Object[]{"not-dropped", "yay!"});
        final String label = e.label();
        final Object inId = v.id();
        final Object outId = v.id();
        e.property("to-drop", (Object)"dah");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void edgePropertyRemoved(Edge element, Property property) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(ReferenceEdge.class));
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)inId, (Object)element.inVertex().id());
                Assert.assertEquals((Object)outId, (Object)element.outVertex().id());
                Assert.assertEquals((Object)"dah", (Object)property.value());
                Assert.assertEquals((Object)"to-drop", (Object)property.key());
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.E(new Object[]{e}).properties(new String[]{"to-drop"}).drop().iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[]{e}).properties(new String[0])));
        Assert.assertEquals((Object)"yay!", (Object)e.value("not-dropped"));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldReferencePropertyOfEdgeWhenChanged() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e = v.addEdge("self", v, new Object[0]);
        final String label = e.label();
        final Object inId = v.id();
        final Object outId = v.id();
        e.property("to-change", (Object)"no!");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void edgePropertyChanged(Edge element, Property oldValue, Object setValue) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(ReferenceEdge.class));
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)inId, (Object)element.inVertex().id());
                Assert.assertEquals((Object)outId, (Object)element.outVertex().id());
                Assert.assertEquals((Object)"no!", (Object)oldValue.value());
                Assert.assertEquals((Object)"to-change", (Object)oldValue.key());
                Assert.assertEquals((Object)"yay!", (Object)setValue);
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.E(new Object[]{e}).property((Object)"to-change", (Object)"yay!", new Object[0]).iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[]{e}).properties(new String[0])));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldReferencePropertyOfEdgeWhenNew() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e = v.addEdge("self", v, new Object[0]);
        final String label = e.label();
        final Object inId = v.id();
        final Object outId = v.id();
        e.property("to-change", (Object)"no!");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void edgePropertyChanged(Edge element, Property oldValue, Object setValue) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(ReferenceEdge.class));
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)inId, (Object)element.inVertex().id());
                Assert.assertEquals((Object)outId, (Object)element.outVertex().id());
                Assert.assertEquals(null, (Object)oldValue.value());
                Assert.assertEquals((Object)"new", (Object)oldValue.key());
                Assert.assertEquals((Object)"yay!", (Object)setValue);
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.E(new Object[]{e}).property((Object)"new", (Object)"yay!", new Object[0]).iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[]{e}).properties(new String[0])));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldReferenceEdgeWhenRemoved() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e = v.addEdge("self", v, new Object[]{"dropped", "yay!"});
        final String label = e.label();
        final Object inId = v.id();
        final Object outId = v.id();
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void edgeRemoved(Edge element) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(ReferenceEdge.class));
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)inId, (Object)element.inVertex().id());
                Assert.assertEquals((Object)outId, (Object)element.outVertex().id());
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.E(new Object[]{e}).drop().iterate();
        this.tryCommit(this.graph);
        EventStrategyProcessTest.assertVertexEdgeCounts(this.graph, 1, 0);
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldReferenceEdgeWhenAdded() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        final Object id = v.id();
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void edgeAdded(Edge element) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(ReferenceEdge.class));
                Assert.assertEquals((Object)"self", (Object)element.label());
                Assert.assertEquals((Object)id, (Object)element.inVertex().id());
                Assert.assertEquals((Object)id, (Object)element.outVertex().id());
                MatcherAssert.assertThat((Object)element.properties(new String[0]).hasNext(), (Matcher)CoreMatchers.is((Object)false));
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).as("a", new String[0]).addE("self").property((Object)"here", (Object)"there", new Object[0]).from("a").to("a").iterate();
        this.tryCommit(this.graph);
        EventStrategyProcessTest.assertVertexEdgeCounts(this.graph, 1, 1);
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldReferenceVertexPropertyWhenRemoved() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        VertexProperty vp = v.property("to-remove", (Object)"blah");
        final String label = vp.label();
        final Object value = vp.value();
        VertexProperty vpToKeep = v.property("to-keep", (Object)"dah");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void vertexPropertyRemoved(VertexProperty element) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(ReferenceVertexProperty.class));
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)value, (Object)element.value());
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).properties(new String[]{"to-remove"}).drop().iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0])));
        Assert.assertEquals((Object)vpToKeep.value(), (Object)this.g.V(new Object[]{v}).values(new String[]{"to-keep"}).next());
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldReferenceVertexPropertyWhenChanged() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        final String label = v.label();
        final Object id = v.id();
        v.property("to-change", (Object)"blah");
        AbstractMutationListener listener = new AbstractMutationListener(){

            public void vertexPropertyChanged(Vertex element, VertexProperty oldValue, Object setValue, Object ... vertexPropertyKeyValues) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(ReferenceVertex.class));
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)id, (Object)element.id());
                Assert.assertEquals((Object)"to-change", (Object)oldValue.key());
                Assert.assertEquals((Object)"blah", (Object)oldValue.value());
                Assert.assertEquals((Object)"dah", (Object)setValue);
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).property(VertexProperty.Cardinality.single, (Object)"to-change", (Object)"dah", new Object[0]).iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0])));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldRefereceVertexPropertyWhenNew() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        final String label = v.label();
        final Object id = v.id();
        v.property("old", (Object)"blah");
        AbstractMutationListener listener = new AbstractMutationListener(){

            public void vertexPropertyChanged(Vertex element, VertexProperty oldValue, Object setValue, Object ... vertexPropertyKeyValues) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(ReferenceVertex.class));
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)id, (Object)element.id());
                Assert.assertEquals((Object)"new", (Object)oldValue.key());
                Assert.assertEquals(null, (Object)oldValue.value());
                Assert.assertEquals((Object)"dah", (Object)setValue);
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).property(VertexProperty.Cardinality.single, (Object)"new", (Object)"dah", new Object[0]).iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0])));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldReferenceVertexPropertyWhenNewDeprecated() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        final String label = v.label();
        final Object id = v.id();
        v.property("old", (Object)"blah");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void vertexPropertyChanged(Vertex element, Property oldValue, Object setValue, Object ... vertexPropertyKeyValues) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(ReferenceVertex.class));
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)id, (Object)element.id());
                Assert.assertEquals((Object)"new", (Object)oldValue.key());
                Assert.assertEquals(null, (Object)oldValue.value());
                Assert.assertEquals((Object)"dah", (Object)setValue);
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).property(VertexProperty.Cardinality.single, (Object)"new", (Object)"dah", new Object[0]).iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0])));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldReferenceVertexWhenRemoved() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        final String label = v.label();
        final Object id = v.id();
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void vertexRemoved(Vertex element) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(ReferenceVertex.class));
                Assert.assertEquals((Object)id, (Object)element.id());
                Assert.assertEquals((Object)label, (Object)element.label());
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).drop().iterate();
        this.tryCommit(this.graph);
        EventStrategyProcessTest.assertVertexEdgeCounts(this.graph, 0, 0);
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldReferenceVertexWhenAdded() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void vertexAdded(Vertex element) {
                MatcherAssert.assertThat((Object)element, (Matcher)IsInstanceOf.instanceOf(ReferenceVertex.class));
                Assert.assertEquals((Object)"thing", (Object)element.label());
                MatcherAssert.assertThat((Object)element.properties(new String[]{"here"}).hasNext(), (Matcher)CoreMatchers.is((Object)false));
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.addV("thing").property((Object)"here", (Object)"there", new Object[0]).iterate();
        this.tryCommit(this.graph);
        EventStrategyProcessTest.assertVertexEdgeCounts(this.graph, 1, 0);
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldUseActualPropertyOfVertexPropertyWhenRemoved() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        final VertexProperty vp = v.property("xxx", (Object)"blah");
        String label = vp.label();
        Object value = vp.value();
        final Property p = vp.property("to-drop", (Object)"dah");
        vp.property("not-dropped", (Object)"yay!");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void vertexPropertyPropertyRemoved(VertexProperty element, Property property) {
                Assert.assertEquals((Object)vp, (Object)element);
                Assert.assertEquals((Object)p, (Object)property);
                Assert.assertEquals((Object)"dah", (Object)property.value());
                Assert.assertEquals((Object)"to-drop", (Object)property.key());
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).properties(new String[]{"xxx"}).properties(new String[]{"to-drop"}).drop().iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0])));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0]).properties(new String[0])));
        Assert.assertEquals((Object)"yay!", (Object)this.g.V(new Object[]{vp.element()}).properties(new String[]{"xxx"}).values(new String[]{"not-dropped"}).next());
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldUseActualPropertyOfVertexPropertyWhenChanged() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        final VertexProperty vp = v.property("xxx", (Object)"blah");
        final String label = vp.label();
        final Object value = vp.value();
        vp.property("to-change", (Object)"dah");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void vertexPropertyPropertyChanged(VertexProperty element, Property oldValue, Object setValue) {
                Assert.assertEquals((Object)vp, (Object)element);
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)value, (Object)element.value());
                Assert.assertEquals((Object)"dah", (Object)oldValue.value());
                Assert.assertEquals((Object)"to-change", (Object)oldValue.key());
                Assert.assertEquals((Object)"bah", (Object)setValue);
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).properties(new String[]{"xxx"}).property((Object)"to-change", (Object)"bah", new Object[0]).iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0])));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0]).properties(new String[0])));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldUseActualPropertyOfVertexPropertyWhenNew() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        final VertexProperty vp = v.property("xxx", (Object)"blah");
        final String label = vp.label();
        final Object value = vp.value();
        vp.property("to-change", (Object)"dah");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void vertexPropertyPropertyChanged(VertexProperty element, Property oldValue, Object setValue) {
                Assert.assertEquals((Object)vp, (Object)element);
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)value, (Object)element.value());
                Assert.assertEquals(null, (Object)oldValue.value());
                Assert.assertEquals((Object)"new", (Object)oldValue.key());
                Assert.assertEquals((Object)"yay!", (Object)setValue);
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).properties(new String[]{"xxx"}).property((Object)"new", (Object)"yay!", new Object[0]).iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0])));
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0]).properties(new String[0])));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldUseActualPropertyOfEdgeWhenRemoved() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        final Edge e = v.addEdge("self", v, new Object[]{"not-dropped", "yay!"});
        final String label = e.label();
        final Object inId = v.id();
        final Object outId = v.id();
        e.property("to-drop", (Object)"dah");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void edgePropertyRemoved(Edge element, Property property) {
                Assert.assertEquals((Object)e, (Object)element);
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)inId, (Object)element.inVertex().id());
                Assert.assertEquals((Object)outId, (Object)element.outVertex().id());
                Assert.assertEquals((Object)"dah", (Object)property.value());
                Assert.assertEquals((Object)"to-drop", (Object)property.key());
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.E(new Object[]{e}).properties(new String[]{"to-drop"}).drop().iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[]{e}).properties(new String[0])));
        Assert.assertEquals((Object)"yay!", (Object)e.value("not-dropped"));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldUseActualPropertyOfEdgeWhenChanged() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        final Edge e = v.addEdge("self", v, new Object[0]);
        final String label = e.label();
        final Object inId = v.id();
        final Object outId = v.id();
        e.property("to-change", (Object)"no!");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void edgePropertyChanged(Edge element, Property oldValue, Object setValue) {
                Assert.assertEquals((Object)e, (Object)element);
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)inId, (Object)element.inVertex().id());
                Assert.assertEquals((Object)outId, (Object)element.outVertex().id());
                Assert.assertEquals((Object)"no!", (Object)oldValue.value());
                Assert.assertEquals((Object)"to-change", (Object)oldValue.key());
                Assert.assertEquals((Object)"yay!", (Object)setValue);
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.E(new Object[]{e}).property((Object)"to-change", (Object)"yay!", new Object[0]).iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[]{e}).properties(new String[0])));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldUseActualPropertyOfEdgeWhenNew() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        final Edge e = v.addEdge("self", v, new Object[0]);
        final String label = e.label();
        final Object inId = v.id();
        final Object outId = v.id();
        e.property("to-change", (Object)"no!");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void edgePropertyChanged(Edge element, Property oldValue, Object setValue) {
                Assert.assertEquals((Object)e, (Object)element);
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)inId, (Object)element.inVertex().id());
                Assert.assertEquals((Object)outId, (Object)element.outVertex().id());
                Assert.assertEquals(null, (Object)oldValue.value());
                Assert.assertEquals((Object)"new", (Object)oldValue.key());
                Assert.assertEquals((Object)"yay!", (Object)setValue);
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.E(new Object[]{e}).property((Object)"new", (Object)"yay!", new Object[0]).iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[]{e}).properties(new String[0])));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldUseActualEdgeWhenRemoved() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        final Edge e = v.addEdge("self", v, new Object[]{"dropped", "yay!"});
        final String label = e.label();
        final Object inId = v.id();
        final Object outId = v.id();
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void edgeRemoved(Edge element) {
                Assert.assertEquals((Object)e, (Object)element);
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)inId, (Object)element.inVertex().id());
                Assert.assertEquals((Object)outId, (Object)element.outVertex().id());
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.E(new Object[]{e}).drop().iterate();
        this.tryCommit(this.graph);
        EventStrategyProcessTest.assertVertexEdgeCounts(this.graph, 1, 0);
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldUseActualEdgeWhenAdded() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        final Object id = v.id();
        final AtomicReference eventedEdge = new AtomicReference();
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void edgeAdded(Edge element) {
                eventedEdge.set(element);
                Assert.assertEquals((Object)"self", (Object)element.label());
                Assert.assertEquals((Object)id, (Object)element.inVertex().id());
                Assert.assertEquals((Object)id, (Object)element.outVertex().id());
                MatcherAssert.assertThat((Object)element.properties(new String[0]).hasNext(), (Matcher)CoreMatchers.is((Object)false));
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        Edge e = (Edge)gts.V(new Object[]{v}).as("a", new String[0]).addE("self").property((Object)"here", (Object)"there", new Object[0]).from("a").to("a").next();
        this.tryCommit(this.graph);
        EventStrategyProcessTest.assertVertexEdgeCounts(this.graph, 1, 1);
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertEquals((Object)e, eventedEdge.get());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldUseActualVertexPropertyWhenRemoved() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        Vertex v = this.graph.addVertex(new Object[0]);
        final VertexProperty vp = v.property("to-remove", (Object)"blah");
        final String label = vp.label();
        final Object value = vp.value();
        VertexProperty vpToKeep = v.property("to-keep", (Object)"dah");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void vertexPropertyRemoved(VertexProperty element) {
                Assert.assertEquals((Object)vp, (Object)element);
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)value, (Object)element.value());
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).properties(new String[]{"to-remove"}).drop().iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0])));
        Assert.assertEquals((Object)vpToKeep.value(), (Object)this.g.V(new Object[]{v}).values(new String[]{"to-keep"}).next());
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldUseActualVertexPropertyWhenChanged() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        final Vertex v = this.graph.addVertex(new Object[0]);
        final String label = v.label();
        final Object id = v.id();
        v.property("to-change", (Object)"blah");
        AbstractMutationListener listener = new AbstractMutationListener(){

            public void vertexPropertyChanged(Vertex element, VertexProperty oldValue, Object setValue, Object ... vertexPropertyKeyValues) {
                Assert.assertEquals((Object)v, (Object)element);
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)id, (Object)element.id());
                Assert.assertEquals((Object)"to-change", (Object)oldValue.key());
                Assert.assertEquals((Object)"blah", (Object)oldValue.value());
                Assert.assertEquals((Object)"dah", (Object)setValue);
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).property(VertexProperty.Cardinality.single, (Object)"to-change", (Object)"dah", new Object[0]).iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0])));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldUseActualVertexPropertyWhenNew() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        final Vertex v = this.graph.addVertex(new Object[0]);
        final String label = v.label();
        final Object id = v.id();
        v.property("old", (Object)"blah");
        AbstractMutationListener listener = new AbstractMutationListener(){

            public void vertexPropertyChanged(Vertex element, VertexProperty oldValue, Object setValue, Object ... vertexPropertyKeyValues) {
                Assert.assertEquals((Object)v, (Object)element);
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)id, (Object)element.id());
                Assert.assertEquals((Object)"new", (Object)oldValue.key());
                Assert.assertEquals(null, (Object)oldValue.value());
                Assert.assertEquals((Object)"dah", (Object)setValue);
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).property(VertexProperty.Cardinality.single, (Object)"new", (Object)"dah", new Object[0]).iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0])));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldUseActualVertexPropertyWhenNewDeprecated() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        final Vertex v = this.graph.addVertex(new Object[0]);
        final String label = v.label();
        final Object id = v.id();
        v.property("old", (Object)"blah");
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void vertexPropertyChanged(Vertex element, Property oldValue, Object setValue, Object ... vertexPropertyKeyValues) {
                Assert.assertEquals((Object)v, (Object)element);
                Assert.assertEquals((Object)label, (Object)element.label());
                Assert.assertEquals((Object)id, (Object)element.id());
                Assert.assertEquals((Object)"new", (Object)oldValue.key());
                Assert.assertEquals(null, (Object)oldValue.value());
                Assert.assertEquals((Object)"dah", (Object)setValue);
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).property(VertexProperty.Cardinality.single, (Object)"new", (Object)"dah", new Object[0]).iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[]{v}).properties(new String[0])));
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldUseActualVertexWhenRemoved() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        final Vertex v = this.graph.addVertex(new Object[0]);
        final String label = v.label();
        final Object id = v.id();
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void vertexRemoved(Vertex element) {
                Assert.assertEquals((Object)v, (Object)element);
                Assert.assertEquals((Object)id, (Object)element.id());
                Assert.assertEquals((Object)label, (Object)element.label());
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).drop().iterate();
        this.tryCommit(this.graph);
        EventStrategyProcessTest.assertVertexEdgeCounts(this.graph, 0, 0);
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldUseActualVertexWhenAdded() {
        final AtomicBoolean triggered = new AtomicBoolean(false);
        final AtomicReference eventedVertex = new AtomicReference();
        AbstractMutationListener listener = new AbstractMutationListener(){

            @Override
            public void vertexAdded(Vertex element) {
                eventedVertex.set(element);
                Assert.assertEquals((Object)"thing", (Object)element.label());
                MatcherAssert.assertThat((Object)element.properties(new String[]{"here"}).hasNext(), (Matcher)CoreMatchers.is((Object)false));
                triggered.set(true);
            }
        };
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener).detach(ReferenceFactory.class);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        GraphTraversalSource gts = this.create(eventStrategy);
        Vertex v = (Vertex)gts.addV("thing").property((Object)"here", (Object)"there", new Object[0]).next();
        this.tryCommit(this.graph);
        EventStrategyProcessTest.assertVertexEdgeCounts(this.graph, 1, 0);
        MatcherAssert.assertThat((Object)triggered.get(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertEquals((Object)v, eventedVertex.get());
    }

    private GraphTraversalSource create(EventStrategy strategy) {
        return this.graphProvider.traversal(this.graph, new TraversalStrategy[]{strategy});
    }

    static class StubMutationListener
    implements MutationListener {
        private final AtomicLong addEdgeEvent = new AtomicLong(0L);
        private final AtomicLong addVertexEvent = new AtomicLong(0L);
        private final AtomicLong vertexRemovedEvent = new AtomicLong(0L);
        private final AtomicLong edgePropertyChangedEvent = new AtomicLong(0L);
        private final AtomicLong vertexPropertyChangedEvent = new AtomicLong(0L);
        private final AtomicLong vertexPropertyPropertyChangedEvent = new AtomicLong(0L);
        private final AtomicLong edgePropertyRemovedEvent = new AtomicLong(0L);
        private final AtomicLong vertexPropertyPropertyRemovedEvent = new AtomicLong(0L);
        private final AtomicLong edgeRemovedEvent = new AtomicLong(0L);
        private final AtomicLong vertexPropertyRemovedEvent = new AtomicLong(0L);
        private final ConcurrentLinkedQueue<String> order = new ConcurrentLinkedQueue();

        StubMutationListener() {
        }

        public void reset() {
            this.addEdgeEvent.set(0L);
            this.addVertexEvent.set(0L);
            this.vertexRemovedEvent.set(0L);
            this.edgePropertyChangedEvent.set(0L);
            this.vertexPropertyChangedEvent.set(0L);
            this.vertexPropertyPropertyChangedEvent.set(0L);
            this.vertexPropertyPropertyRemovedEvent.set(0L);
            this.edgePropertyRemovedEvent.set(0L);
            this.edgeRemovedEvent.set(0L);
            this.vertexPropertyRemovedEvent.set(0L);
            this.order.clear();
        }

        public List<String> getOrder() {
            return new ArrayList<String>(this.order);
        }

        public void vertexAdded(Vertex vertex) {
            this.addVertexEvent.incrementAndGet();
            this.order.add("v-added-" + vertex.id());
        }

        public void vertexRemoved(Vertex vertex) {
            this.vertexRemovedEvent.incrementAndGet();
            this.order.add("v-removed-" + vertex.id());
        }

        public void edgeAdded(Edge edge) {
            this.addEdgeEvent.incrementAndGet();
            this.order.add("e-added-" + edge.id());
        }

        public void edgePropertyRemoved(Edge element, Property o) {
            this.edgePropertyRemovedEvent.incrementAndGet();
            this.order.add("e-property-removed-" + element.id() + "-" + o);
        }

        public void vertexPropertyPropertyRemoved(VertexProperty element, Property o) {
            this.vertexPropertyPropertyRemovedEvent.incrementAndGet();
            this.order.add("vp-property-removed-" + element.id() + "-" + o);
        }

        public void edgeRemoved(Edge edge) {
            this.edgeRemovedEvent.incrementAndGet();
            this.order.add("e-removed-" + edge.id());
        }

        public void vertexPropertyRemoved(VertexProperty vertexProperty) {
            this.vertexPropertyRemovedEvent.incrementAndGet();
            this.order.add("vp-property-removed-" + vertexProperty.id());
        }

        public void edgePropertyChanged(Edge element, Property oldValue, Object setValue) {
            this.edgePropertyChangedEvent.incrementAndGet();
            this.order.add("e-property-chanaged-" + element.id());
        }

        public void vertexPropertyPropertyChanged(VertexProperty element, Property oldValue, Object setValue) {
            this.vertexPropertyPropertyChangedEvent.incrementAndGet();
            this.order.add("vp-property-changed-" + element.id());
        }

        public void vertexPropertyChanged(Vertex element, Property oldValue, Object setValue, Object ... vertexPropertyKeyValues) {
        }

        public void vertexPropertyChanged(Vertex element, VertexProperty oldValue, Object setValue, Object ... vertexPropertyKeyValues) {
            this.vertexPropertyChangedEvent.incrementAndGet();
            this.order.add("v-property-changed-" + element.id());
        }

        public long addEdgeEventRecorded() {
            return this.addEdgeEvent.get();
        }

        public long addVertexEventRecorded() {
            return this.addVertexEvent.get();
        }

        public long vertexRemovedEventRecorded() {
            return this.vertexRemovedEvent.get();
        }

        public long edgeRemovedEventRecorded() {
            return this.edgeRemovedEvent.get();
        }

        public long edgePropertyRemovedEventRecorded() {
            return this.edgePropertyRemovedEvent.get();
        }

        public long vertexPropertyRemovedEventRecorded() {
            return this.vertexPropertyRemovedEvent.get();
        }

        public long vertexPropertyPropertyRemovedEventRecorded() {
            return this.vertexPropertyPropertyRemovedEvent.get();
        }

        public long edgePropertyChangedEventRecorded() {
            return this.edgePropertyChangedEvent.get();
        }

        public long vertexPropertyChangedEventRecorded() {
            return this.vertexPropertyChangedEvent.get();
        }

        public long vertexPropertyPropertyChangedEventRecorded() {
            return this.vertexPropertyPropertyChangedEvent.get();
        }
    }

    static abstract class AbstractMutationListener
    implements MutationListener {
        AbstractMutationListener() {
        }

        public void vertexAdded(Vertex vertex) {
        }

        public void vertexRemoved(Vertex vertex) {
        }

        public void vertexPropertyChanged(Vertex element, Property oldValue, Object setValue, Object ... vertexPropertyKeyValues) {
        }

        public void vertexPropertyRemoved(VertexProperty vertexProperty) {
        }

        public void edgeAdded(Edge edge) {
        }

        public void edgeRemoved(Edge edge) {
        }

        public void edgePropertyChanged(Edge element, Property oldValue, Object setValue) {
        }

        public void edgePropertyRemoved(Edge element, Property property) {
        }

        public void vertexPropertyPropertyChanged(VertexProperty element, Property oldValue, Object setValue) {
        }

        public void vertexPropertyPropertyRemoved(VertexProperty element, Property property) {
        }
    }
}

