/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.jsr223;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.tinkerpop.gremlin.jsr223.DefaultGremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.jsr223.GremlinPlugin;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineSuite;
import org.apache.tinkerpop.gremlin.jsr223.ImportGremlinPlugin;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.junit.Assert;
import org.junit.Test;

public class GremlinEnabledScriptEngineTest {
    private static final GremlinScriptEngineManager manager = new DefaultGremlinScriptEngineManager();

    @Test
    public void shouldGetEngineByName() throws Exception {
        GremlinScriptEngine scriptEngine = manager.getEngineByName(GremlinScriptEngineSuite.ENGINE_TO_TEST);
        Assert.assertEquals((Object)GremlinScriptEngineSuite.ENGINE_TO_TEST, (Object)scriptEngine.getFactory().getEngineName());
    }

    @Test
    public void shouldHaveCoreImportsInPlace() throws Exception {
        GremlinScriptEngine scriptEngine = manager.getEngineByName(GremlinScriptEngineSuite.ENGINE_TO_TEST);
        List<Class> classesToCheck = Arrays.asList(Vertex.class, Edge.class, Graph.class, VertexProperty.class);
        for (Class clazz : classesToCheck) {
            Assert.assertEquals((Object)clazz, (Object)scriptEngine.eval(clazz.getSimpleName()));
        }
    }

    @Test
    public void shouldReturnNoCustomizers() {
        DefaultGremlinScriptEngineManager mgr = new DefaultGremlinScriptEngineManager();
        mgr.addPlugin((GremlinPlugin)ImportGremlinPlugin.build().classImports(new Class[]{Color.class}).appliesTo(Collections.singletonList("fake-script-engine")).create());
        Assert.assertEquals((long)0L, (long)mgr.getCustomizers(GremlinScriptEngineSuite.ENGINE_TO_TEST).size());
    }
}

