/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.IgnoreEngine;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.TraversalVertexProgramStep;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ProfileStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.RangeByIsCountStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.RepeatUnrollStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.ComputerVerificationStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.VerificationException;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class ProfileTest
extends AbstractGremlinProcessTest {
    private static final String METRICS_KEY = "metrics";

    public abstract Traversal<Vertex, TraversalMetrics> get_g_V_out_out_profile();

    public abstract Traversal<Vertex, TraversalMetrics> get_g_V_repeatXbothX_timesX3X_profile();

    public abstract Traversal<Vertex, TraversalMetrics> get_g_V_sideEffectXThread_sleepX10XX_sideEffectXThread_sleepX5XX_profile();

    public abstract Traversal<Vertex, TraversalMetrics> get_g_V_whereXinXcreatedX_count_isX1XX_name_profile();

    public abstract Traversal<Vertex, TraversalMetrics> get_g_V_matchXa_created_b__b_in_count_isXeqX1XXX_selectXa_bX_profile();

    public abstract Traversal<Vertex, Vertex> get_g_V_out_out_profileXmetricsX();

    public abstract Traversal<Vertex, Vertex> get_g_V_repeatXbothX_timesX3X_profileXmetricsX();

    public abstract Traversal<Vertex, Vertex> get_g_V_sideEffectXThread_sleepX10XX_sideEffectXThread_sleepX5XX_profileXmetricsX();

    public abstract Traversal<Vertex, String> get_g_V_whereXinXcreatedX_count_isX1XX_name_profileXmetricsX();

    public abstract Traversal<Vertex, Map<String, String>> get_g_V_matchXa_created_b__b_in_count_isXeqX1XXX_selectXa_bX_profileXmetricsX();

    public abstract Traversal<Vertex, TraversalMetrics> get_g_V_hasLabelXpersonX_pageRank_byXrankX_byXbothEX_rank_profile();

    public abstract Traversal<Vertex, TraversalMetrics> get_g_V_groupXmX_profile();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void modern_V_out_out_profile() {
        Traversal<Vertex, TraversalMetrics> traversal = this.get_g_V_out_out_profile();
        this.printTraversalForm(traversal);
        this.validate_g_V_out_out_profile_modern(traversal, (TraversalMetrics)traversal.next());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void modern_V_out_out_profileXmetricsX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_out_out_profileXmetricsX();
        this.printTraversalForm(traversal);
        traversal.iterate();
        this.validate_g_V_out_out_profile_modern(traversal, (TraversalMetrics)traversal.asAdmin().getSideEffects().get(METRICS_KEY));
    }

    private void validate_g_V_out_out_profile_modern(Traversal traversal, TraversalMetrics traversalMetrics) {
        traversalMetrics.toString();
        Assume.assumeThat((String)"The following assertions apply to TinkerGraph only as provider strategies can alter the steps to not comply with expectations", (Object)this.graph.getClass().getSimpleName(), (Matcher)IsEqual.equalTo((Object)"TinkerGraph"));
        Metrics metrics = traversalMetrics.getMetrics(0);
        Assert.assertEquals((long)6L, (long)metrics.getCount("traverserCount"));
        Assert.assertEquals((long)6L, (long)metrics.getCount("elementCount"));
        metrics = traversalMetrics.getMetrics(1);
        Assert.assertEquals((long)6L, (long)metrics.getCount("elementCount"));
        Assert.assertNotEquals((long)0L, (long)metrics.getCount("traverserCount"));
        metrics = traversalMetrics.getMetrics(2);
        Assert.assertEquals((long)2L, (long)metrics.getCount("elementCount"));
        Assert.assertNotEquals((long)0L, (long)metrics.getCount("traverserCount"));
        if (!ProfileTest.onGraphComputer(traversal.asAdmin())) {
            List steps = traversal.asAdmin().getSteps();
            for (int ii = 1; ii <= 6; ii += 2) {
                Assert.assertEquals((String)"Every other Step should be a ProfileStep.", ProfileStep.class, ((Step)steps.get(ii)).getClass());
            }
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.GRATEFUL)
    public void grateful_V_out_out_profile() {
        Traversal<Vertex, TraversalMetrics> traversal = this.get_g_V_out_out_profile();
        this.printTraversalForm(traversal);
        TraversalMetrics traversalMetrics = (TraversalMetrics)traversal.next();
        this.validate_g_V_out_out_profile_grateful(traversalMetrics);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.GRATEFUL)
    public void grateful_V_out_out_profileXmetricsX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_out_out_profileXmetricsX();
        this.printTraversalForm(traversal);
        traversal.iterate();
        TraversalMetrics traversalMetrics = (TraversalMetrics)traversal.asAdmin().getSideEffects().get(METRICS_KEY);
        this.validate_g_V_out_out_profile_grateful(traversalMetrics);
    }

    private void validate_g_V_out_out_profile_grateful(TraversalMetrics traversalMetrics) {
        traversalMetrics.toString();
        Assume.assumeThat((String)"The following assertions apply to TinkerGraph only as provider strategies can alter the steps to not comply with expectations", (Object)this.graph.getClass().getSimpleName(), (Matcher)IsEqual.equalTo((Object)"TinkerGraph"));
        Metrics metrics = traversalMetrics.getMetrics(0);
        Assert.assertEquals((long)808L, (long)metrics.getCount("traverserCount"));
        Assert.assertEquals((long)808L, (long)metrics.getCount("elementCount"));
        Assert.assertTrue((String)"Percent duration should be positive.", ((Double)metrics.getAnnotation("percentDur") >= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Times should be positive.", (metrics.getDuration(TimeUnit.MICROSECONDS) >= 0L ? 1 : 0) != 0);
        metrics = traversalMetrics.getMetrics(1);
        Assert.assertEquals((long)8049L, (long)metrics.getCount("elementCount"));
        Assert.assertNotEquals((long)0L, (long)metrics.getCount("traverserCount"));
        Assert.assertTrue((String)"Percent duration should be positive.", ((Double)metrics.getAnnotation("percentDur") >= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Times should be positive.", (metrics.getDuration(TimeUnit.MICROSECONDS) >= 0L ? 1 : 0) != 0);
        metrics = traversalMetrics.getMetrics(2);
        Assert.assertEquals((long)327370L, (long)metrics.getCount("elementCount"));
        Assert.assertNotEquals((long)0L, (long)metrics.getCount("traverserCount"));
        Assert.assertTrue((String)"Percent duration should be positive.", ((Double)metrics.getAnnotation("percentDur") >= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Times should be positive.", (metrics.getDuration(TimeUnit.MICROSECONDS) >= 0L ? 1 : 0) != 0);
        double totalPercentDuration = 0.0;
        for (Metrics m : traversalMetrics.getMetrics()) {
            totalPercentDuration += ((Double)m.getAnnotation("percentDur")).doubleValue();
        }
        Assert.assertEquals((double)100.0, (double)totalPercentDuration, (double)1.0E-6);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @IgnoreEngine(value=TraversalEngine.Type.COMPUTER)
    public void g_V_sideEffectXThread_sleepX10XX_sideEffectXThread_sleepX5XX_profile() {
        Traversal<Vertex, TraversalMetrics> traversal = this.get_g_V_sideEffectXThread_sleepX10XX_sideEffectXThread_sleepX5XX_profile();
        this.printTraversalForm(traversal);
        if (this.graph.getClass().getSimpleName().equals("TinkerGraph")) {
            Assert.assertEquals((String)"There should be 8 steps in this traversal (counting injected profile steps).", (long)8L, (long)traversal.asAdmin().getSteps().size());
        }
        TraversalMetrics traversalMetrics = (TraversalMetrics)traversal.next();
        this.validate_g_V_sideEffectXThread_sleepX10XX_sideEffectXThread_sleepX5XX_profile(traversalMetrics);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @IgnoreEngine(value=TraversalEngine.Type.COMPUTER)
    public void g_V_sideEffectXThread_sleepX10XX_sideEffectXThread_sleepX5XX_profileXmetricsX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_sideEffectXThread_sleepX10XX_sideEffectXThread_sleepX5XX_profileXmetricsX();
        this.printTraversalForm(traversal);
        traversal.iterate();
        if (this.graph.getClass().getSimpleName().equals("TinkerGraph")) {
            Assert.assertEquals((String)"There should be 7 steps in this traversal (counting injected profile steps).", (long)7L, (long)traversal.asAdmin().getSteps().size());
        }
        TraversalMetrics traversalMetrics = (TraversalMetrics)traversal.asAdmin().getSideEffects().get(METRICS_KEY);
        this.validate_g_V_sideEffectXThread_sleepX10XX_sideEffectXThread_sleepX5XX_profile(traversalMetrics);
    }

    private void validate_g_V_sideEffectXThread_sleepX10XX_sideEffectXThread_sleepX5XX_profile(TraversalMetrics traversalMetrics) {
        traversalMetrics.toString();
        Assume.assumeThat((String)"The following assertions apply to TinkerGraph only as provider strategies can alter the steps to not comply with expectations", (Object)this.graph.getClass().getSimpleName(), (Matcher)IsEqual.equalTo((Object)"TinkerGraph"));
        Metrics metrics = traversalMetrics.getMetrics(1);
        Assert.assertTrue((String)("Duration should be at least the length of the sleep (59ms): " + metrics.getDuration(TimeUnit.MILLISECONDS)), (metrics.getDuration(TimeUnit.MILLISECONDS) >= 59L ? 1 : 0) != 0);
        metrics = traversalMetrics.getMetrics(2);
        Assert.assertTrue((String)("Duration should be at least the length of the sleep (29ms): " + metrics.getDuration(TimeUnit.MILLISECONDS)), (metrics.getDuration(TimeUnit.MILLISECONDS) >= 29L ? 1 : 0) != 0);
        double totalPercentDuration = 0.0;
        for (Metrics m : traversalMetrics.getMetrics()) {
            totalPercentDuration += ((Double)m.getAnnotation("percentDur")).doubleValue();
        }
        Assert.assertEquals((double)100.0, (double)totalPercentDuration, (double)1.0E-6);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_repeat_both_profile() {
        Traversal<Vertex, TraversalMetrics> traversal = this.get_g_V_repeatXbothX_timesX3X_profile();
        this.printTraversalForm(traversal);
        TraversalMetrics traversalMetrics = (TraversalMetrics)traversal.next();
        this.validate_g_V_repeat_both_modern_profile(traversalMetrics, traversal.asAdmin().getStrategies().toList().contains(RepeatUnrollStrategy.instance()) && !traversal.asAdmin().getStrategies().toList().contains(ComputerVerificationStrategy.instance()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_repeat_both_profileXmetricsX() {
        Traversal<Vertex, Vertex> traversal = this.get_g_V_repeatXbothX_timesX3X_profileXmetricsX();
        this.printTraversalForm(traversal);
        traversal.iterate();
        TraversalMetrics traversalMetrics = (TraversalMetrics)traversal.asAdmin().getSideEffects().get(METRICS_KEY);
        this.validate_g_V_repeat_both_modern_profile(traversalMetrics, traversal.asAdmin().getStrategies().toList().contains(RepeatUnrollStrategy.instance()) && !traversal.asAdmin().getStrategies().toList().contains(ComputerVerificationStrategy.instance()));
    }

    private void validate_g_V_repeat_both_modern_profile(TraversalMetrics traversalMetrics, boolean withRepeatUnrollStrategy) {
        traversalMetrics.toString();
        Assume.assumeThat((String)"The following assertions apply to TinkerGraph only as provider strategies can alter the steps to not comply with expectations", (Object)this.graph.getClass().getSimpleName(), (Matcher)IsEqual.equalTo((Object)"TinkerGraph"));
        Metrics metrics = traversalMetrics.getMetrics(0);
        Assert.assertEquals((long)6L, (long)metrics.getCount("traverserCount"));
        Assert.assertEquals((long)6L, (long)metrics.getCount("elementCount"));
        metrics = traversalMetrics.getMetrics(1);
        Assert.assertEquals((long)(withRepeatUnrollStrategy ? 12L : 72L), (long)metrics.getCount("elementCount"));
        Assert.assertNotEquals((long)0L, (long)metrics.getCount("traverserCount"));
        if (!withRepeatUnrollStrategy) {
            Assert.assertTrue((String)"Count should be greater than traversers.", (metrics.getCount("elementCount") > metrics.getCount("traverserCount") ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)"Percent duration should be positive.", ((Double)metrics.getAnnotation("percentDur") >= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Times should be positive.", (metrics.getDuration(TimeUnit.MICROSECONDS) >= 0L ? 1 : 0) != 0);
        if (!withRepeatUnrollStrategy) {
            Metrics vertexStepNestedInRepeat = (Metrics)metrics.getNested().toArray()[0];
            Assert.assertEquals((long)114L, (long)vertexStepNestedInRepeat.getCount("elementCount"));
            Assert.assertNotEquals((long)0L, (long)vertexStepNestedInRepeat.getCount("traverserCount"));
            Assert.assertTrue((String)"Count should be greater than traversers.", (vertexStepNestedInRepeat.getCount("elementCount") > vertexStepNestedInRepeat.getCount("traverserCount") ? 1 : 0) != 0);
            Assert.assertTrue((String)"Times should be positive.", (vertexStepNestedInRepeat.getDuration(TimeUnit.MICROSECONDS) >= 0L ? 1 : 0) != 0);
        }
        double totalPercentDuration = 0.0;
        for (Metrics m : traversalMetrics.getMetrics()) {
            totalPercentDuration += ((Double)m.getAnnotation("percentDur")).doubleValue();
        }
        Assert.assertEquals((double)100.0, (double)totalPercentDuration, (double)1.0E-6);
    }

    private void validate_g_V_whereXinXcreatedX_count_isX1XX_name_profile(Traversal traversal, TraversalMetrics traversalMetrics) {
        traversalMetrics.toString();
        Assume.assumeThat((String)"The following assertions apply to TinkerGraph only as provider strategies can alter the steps to not comply with expectations", (Object)this.graph.getClass().getSimpleName(), (Matcher)IsEqual.equalTo((Object)"TinkerGraph"));
        Assert.assertEquals((String)"There should be 3 top-level metrics.", (long)3L, (long)traversalMetrics.getMetrics().size());
        Metrics metrics = traversalMetrics.getMetrics(0);
        Assert.assertEquals((long)6L, (long)metrics.getCount("traverserCount"));
        Assert.assertEquals((long)6L, (long)metrics.getCount("elementCount"));
        metrics = traversalMetrics.getMetrics(1);
        Assert.assertEquals((long)1L, (long)metrics.getCount("traverserCount"));
        Assert.assertEquals((long)1L, (long)metrics.getCount("elementCount"));
        if (traversal.asAdmin().getStrategies().toList().stream().anyMatch(s -> s instanceof RangeByIsCountStrategy)) {
            Assert.assertEquals((String)"Metrics 1 should have 4 nested metrics.", (long)4L, (long)metrics.getNested().size());
        } else {
            Assert.assertEquals((String)"Metrics 1 should have 3 nested metrics.", (long)3L, (long)metrics.getNested().size());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_whereXinXcreatedX_count_isX1XX_name_profile() {
        Traversal<Vertex, TraversalMetrics> traversal = this.get_g_V_whereXinXcreatedX_count_isX1XX_name_profile();
        this.printTraversalForm(traversal);
        TraversalMetrics traversalMetrics = (TraversalMetrics)traversal.next();
        this.validate_g_V_whereXinXcreatedX_count_isX1XX_name_profile(traversal, traversalMetrics);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_whereXinXcreatedX_count_isX1XX_name_profileXmetricsX() {
        Traversal<Vertex, String> traversal = this.get_g_V_whereXinXcreatedX_count_isX1XX_name_profileXmetricsX();
        this.printTraversalForm(traversal);
        traversal.iterate();
        TraversalMetrics traversalMetrics = (TraversalMetrics)traversal.asAdmin().getSideEffects().get(METRICS_KEY);
        this.validate_g_V_whereXinXcreatedX_count_isX1XX_name_profile(traversal, traversalMetrics);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void testProfileStrategyCallback() {
        Traversal<Vertex, TraversalMetrics> t = this.get_g_V_out_out_profile();
        MockStep mockStep = new MockStep(t.asAdmin());
        t.asAdmin().addStep(3, (Step)mockStep);
        TraversalMetrics traversalMetrics = (TraversalMetrics)t.next();
        Assert.assertTrue((boolean)MockStep.callbackCalled);
        if (!ProfileTest.onGraphComputer(t.asAdmin())) {
            Assert.assertEquals((long)100L, (long)traversalMetrics.getMetrics(3).getCount("bogusCount"));
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void testProfileStrategyCallbackSideEffect() {
        Traversal<Vertex, Vertex> t = this.get_g_V_out_out_profileXmetricsX();
        MockStep mockStep = new MockStep(t.asAdmin());
        t.asAdmin().addStep(3, (Step)mockStep);
        t.iterate();
        Assert.assertTrue((boolean)MockStep.callbackCalled);
        if (!ProfileTest.onGraphComputer(t.asAdmin())) {
            TraversalMetrics traversalMetrics = (TraversalMetrics)t.asAdmin().getSideEffects().get(METRICS_KEY);
            Assert.assertEquals((long)100L, (long)traversalMetrics.getMetrics(3).getCount("bogusCount"));
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_matchXa_created_b__b_in_count_isXeqX1XXX_selectXa_bX_profile() {
        Traversal<Vertex, TraversalMetrics> traversal = this.get_g_V_matchXa_created_b__b_in_count_isXeqX1XXX_selectXa_bX_profile();
        this.printTraversalForm(traversal);
        traversal.iterate();
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_matchXa_created_b__b_in_count_isXeqX1XXX_selectXa_bX_profileXmetricsX() {
        Traversal<Vertex, Map<String, String>> traversal = this.get_g_V_matchXa_created_b__b_in_count_isXeqX1XXX_selectXa_bX_profileXmetricsX();
        this.printTraversalForm(traversal);
        traversal.iterate();
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @IgnoreEngine(value=TraversalEngine.Type.STANDARD)
    public void g_V_hasLabelXpersonX_pageRank_byXrankX_byXbothEX_rank_profile() {
        Traversal<Vertex, TraversalMetrics> traversal = this.get_g_V_hasLabelXpersonX_pageRank_byXrankX_byXbothEX_rank_profile();
        try {
            traversal.iterate();
            Assert.fail((String)"Should have tossed an exception because multi-OLAP is unsolvable");
        }
        catch (Exception ex) {
            Assert.assertTrue((ex instanceof VerificationException || ExceptionUtils.getRootCause((Throwable)ex) instanceof VerificationException ? 1 : 0) != 0);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_groupXmX_profile() {
        Traversal<Vertex, TraversalMetrics> traversal = this.get_g_V_groupXmX_profile();
        this.printTraversalForm(traversal);
        traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    private static boolean onGraphComputer(Traversal.Admin<?, ?> traversal) {
        return !TraversalHelper.getStepsOfClass(TraversalVertexProgramStep.class, (Traversal.Admin)TraversalHelper.getRootTraversal(traversal)).isEmpty();
    }

    public static class Traversals
    extends ProfileTest {
        @Override
        public Traversal<Vertex, TraversalMetrics> get_g_V_out_out_profile() {
            return this.g.V(new Object[0]).out(new String[0]).out(new String[0]).profile();
        }

        @Override
        public Traversal<Vertex, TraversalMetrics> get_g_V_repeatXbothX_timesX3X_profile() {
            return this.g.V(new Object[0]).repeat((Traversal)__.both((String[])new String[0])).times(3).profile();
        }

        @Override
        public Traversal<Vertex, TraversalMetrics> get_g_V_sideEffectXThread_sleepX10XX_sideEffectXThread_sleepX5XX_profile() {
            return this.g.V(new Object[0]).sideEffect(v -> {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }).sideEffect(v -> {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }).profile();
        }

        @Override
        public Traversal<Vertex, TraversalMetrics> get_g_V_whereXinXcreatedX_count_isX1XX_name_profile() {
            return this.g.V(new Object[0]).where((Traversal)__.in((String[])new String[]{"created"}).count().is((Object)1L)).values(new String[]{"name"}).profile();
        }

        @Override
        public Traversal<Vertex, TraversalMetrics> get_g_V_matchXa_created_b__b_in_count_isXeqX1XXX_selectXa_bX_profile() {
            return this.g.V(new Object[0]).match(new Traversal[]{__.as((String)"a", (String[])new String[0]).out(new String[]{"created"}).as("b", new String[0]), __.as((String)"b", (String[])new String[0]).in(new String[0]).count().is((Object)P.eq((Object)1))}).select("a", "b", new String[0]).profile();
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_out_out_profileXmetricsX() {
            return this.g.V(new Object[0]).out(new String[0]).out(new String[0]).profile(ProfileTest.METRICS_KEY);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_repeatXbothX_timesX3X_profileXmetricsX() {
            return this.g.V(new Object[0]).repeat((Traversal)__.both((String[])new String[0])).times(3).profile(ProfileTest.METRICS_KEY);
        }

        @Override
        public Traversal<Vertex, Vertex> get_g_V_sideEffectXThread_sleepX10XX_sideEffectXThread_sleepX5XX_profileXmetricsX() {
            return this.g.V(new Object[0]).sideEffect(v -> {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }).sideEffect(v -> {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }).profile(ProfileTest.METRICS_KEY);
        }

        @Override
        public Traversal<Vertex, String> get_g_V_whereXinXcreatedX_count_isX1XX_name_profileXmetricsX() {
            return this.g.V(new Object[0]).where((Traversal)__.in((String[])new String[]{"created"}).count().is((Object)1L)).values(new String[]{"name"}).profile(ProfileTest.METRICS_KEY);
        }

        @Override
        public Traversal<Vertex, Map<String, String>> get_g_V_matchXa_created_b__b_in_count_isXeqX1XXX_selectXa_bX_profileXmetricsX() {
            return this.g.V(new Object[0]).match(new Traversal[]{__.as((String)"a", (String[])new String[0]).out(new String[]{"created"}).as("b", new String[0]), __.as((String)"b", (String[])new String[0]).in(new String[0]).count().is((Object)P.eq((Object)1))}).select("a", "b", new String[0]).profile(ProfileTest.METRICS_KEY);
        }

        @Override
        public Traversal<Vertex, TraversalMetrics> get_g_V_hasLabelXpersonX_pageRank_byXrankX_byXbothEX_rank_profile() {
            return this.g.V(new Object[0]).hasLabel("person", new String[0]).pageRank().by("rank").by((Traversal)__.bothE((String[])new String[0])).values(new String[]{"rank"}).profile();
        }

        @Override
        public Traversal<Vertex, TraversalMetrics> get_g_V_groupXmX_profile() {
            return this.g.V(new Object[0]).group("m").profile();
        }
    }

    public static class MockStep
    extends FlatMapStep<Vertex, Vertex>
    implements Profiling {
        public static boolean callbackCalled = false;

        public MockStep(Traversal.Admin traversal) {
            super(traversal);
        }

        protected Iterator<Vertex> flatMap(Traverser.Admin<Vertex> traverser) {
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(traverser.get());
            return l.iterator();
        }

        public void setMetrics(MutableMetrics parentMetrics) {
            if (parentMetrics != null) {
                callbackCalled = true;
                parentMetrics.setCount("bogusCount", 100L);
            }
        }
    }
}

