/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.IgnoreEngine;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.PathRetractionStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.ComputerVerificationStrategy;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class ComplexTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, String> getClassicRecommendation();

    public abstract Traversal<Vertex, Map<String, Map<String, Map<String, Object>>>> getCoworkerSummary();

    public abstract Traversal<Vertex, Map<String, Map<String, Map<String, Object>>>> getCoworkerSummaryOLTP();

    public abstract Traversal<Vertex, List<Object>> getAllShortestPaths();

    public abstract Traversal<Vertex, Map<String, List<String>>> getPlaylistPaths();

    /*
     * Could not resolve type clashes
     */
    private static void checkCoworkerSummary(Map<String, Map<String, Map<String, Object>>> summary) {
        Assert.assertNotNull(summary);
        Assert.assertEquals((long)3L, (long)summary.size());
        Assert.assertTrue((boolean)summary.containsKey("marko"));
        Assert.assertTrue((boolean)summary.containsKey("josh"));
        Assert.assertTrue((boolean)summary.containsKey("peter"));
        for (Map.Entry<String, Map<String, Map<String, Object>>> entry : summary.entrySet()) {
            Assert.assertEquals((long)2L, (long)entry.getValue().size());
            switch (entry.getKey()) {
                case "marko": {
                    Assert.assertTrue((entry.getValue().containsKey("josh") && entry.getValue().containsKey("peter") ? 1 : 0) != 0);
                    break;
                }
                case "josh": {
                    Assert.assertTrue((entry.getValue().containsKey("peter") && entry.getValue().containsKey("marko") ? 1 : 0) != 0);
                    break;
                }
                case "peter": {
                    Assert.assertTrue((entry.getValue().containsKey("marko") && entry.getValue().containsKey("josh") ? 1 : 0) != 0);
                }
            }
            for (Map m : entry.getValue().values()) {
                Assert.assertTrue((boolean)m.containsKey("numCoCreated"));
                Assert.assertTrue((boolean)m.containsKey("coCreated"));
                Assert.assertTrue((boolean)(m.get("numCoCreated") instanceof Number));
                Assert.assertTrue((boolean)(m.get("coCreated") instanceof Collection));
                Assert.assertEquals((long)1L, (long)((Number)m.get("numCoCreated")).intValue());
                Assert.assertEquals((long)1L, (long)((Collection)m.get("coCreated")).size());
                Assert.assertEquals((Object)"lop", ((Collection)m.get("coCreated")).iterator().next());
            }
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.GRATEFUL)
    public void classicRecommendation() {
        Traversal<Vertex, String> traversal = this.getClassicRecommendation();
        this.printTraversalForm(traversal);
        ComplexTest.checkResults(Arrays.asList("LET IT GROW", "UNCLE JOHNS BAND", "I KNOW YOU RIDER", "SHIP OF FOOLS", "GOOD LOVING"), traversal);
        ArrayList list = new ArrayList((Collection)traversal.asAdmin().getSideEffects().get("m"));
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((Object)"LET IT GROW", ((Map)list.get(0)).get("x"));
        Assert.assertEquals((Object)276, ((Map)list.get(0)).get("y"));
        Assert.assertEquals((Object)21L, ((Map)list.get(0)).get("z"));
        Assert.assertEquals((Object)"UNCLE JOHNS BAND", ((Map)list.get(1)).get("x"));
        Assert.assertEquals((Object)332, ((Map)list.get(1)).get("y"));
        Assert.assertEquals((Object)20L, ((Map)list.get(1)).get("z"));
        Assert.assertEquals((Object)"I KNOW YOU RIDER", ((Map)list.get(2)).get("x"));
        Assert.assertEquals((Object)550, ((Map)list.get(2)).get("y"));
        Assert.assertEquals((Object)20L, ((Map)list.get(2)).get("z"));
        Assert.assertEquals((Object)"SHIP OF FOOLS", ((Map)list.get(3)).get("x"));
        Assert.assertEquals((Object)225, ((Map)list.get(3)).get("y"));
        Assert.assertEquals((Object)18L, ((Map)list.get(3)).get("z"));
        Assert.assertEquals((Object)"GOOD LOVING", ((Map)list.get(4)).get("x"));
        Assert.assertEquals((Object)428, ((Map)list.get(4)).get("y"));
        Assert.assertEquals((Object)18L, ((Map)list.get(4)).get("z"));
        ComplexTest.checkSideEffects(traversal.asAdmin().getSideEffects(), "m", BulkSet.class, "stash", BulkSet.class);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void coworkerSummary() {
        Traversal<Vertex, Map<String, Map<String, Map<String, Object>>>> traversal = this.getCoworkerSummary();
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        ComplexTest.checkCoworkerSummary((Map)traversal.next());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @IgnoreEngine(value=TraversalEngine.Type.COMPUTER)
    public void coworkerSummaryOLTP() {
        Traversal<Vertex, Map<String, Map<String, Map<String, Object>>>> traversal = this.getCoworkerSummaryOLTP();
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        ComplexTest.checkCoworkerSummary((Map)traversal.next());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void allShortestPaths() {
        Traversal<Vertex, List<Object>> traversal = this.getAllShortestPaths();
        this.printTraversalForm(traversal);
        Object marko = this.convertToVertexId(this.graph, "marko");
        Object vadas = this.convertToVertexId(this.graph, "vadas");
        Object lop = this.convertToVertexId(this.graph, "lop");
        Object josh = this.convertToVertexId(this.graph, "josh");
        Object ripple = this.convertToVertexId(this.graph, "ripple");
        Object peter = this.convertToVertexId(this.graph, "peter");
        List<List> allShortestPaths = Arrays.asList(Arrays.asList(josh, lop), Arrays.asList(josh, marko), Arrays.asList(josh, ripple), Arrays.asList(josh, marko, vadas), Arrays.asList(josh, lop, peter), Arrays.asList(lop, marko), Arrays.asList(lop, peter), Arrays.asList(lop, josh), Arrays.asList(lop, josh, ripple), Arrays.asList(lop, marko, vadas), Arrays.asList(marko, lop), Arrays.asList(marko, josh), Arrays.asList(marko, vadas), Arrays.asList(marko, josh, ripple), Arrays.asList(marko, lop, peter), Arrays.asList(peter, lop), Arrays.asList(peter, lop, marko), Arrays.asList(peter, lop, josh), Arrays.asList(peter, lop, josh, ripple), Arrays.asList(peter, lop, marko, vadas), Arrays.asList(ripple, josh), Arrays.asList(ripple, josh, lop), Arrays.asList(ripple, josh, marko), Arrays.asList(ripple, josh, marko, vadas), Arrays.asList(ripple, josh, lop, peter), Arrays.asList(vadas, marko), Arrays.asList(vadas, marko, josh), Arrays.asList(vadas, marko, lop), Arrays.asList(vadas, marko, josh, ripple), Arrays.asList(vadas, marko, lop, peter));
        ComplexTest.checkResults(allShortestPaths, traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.GRATEFUL)
    public void playlistPaths() {
        Traversal<Vertex, Map<String, List<String>>> traversal = this.getPlaylistPaths();
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        Map map = (Map)traversal.next();
        Assert.assertTrue((boolean)((List)map.get("artists")).contains("Bob_Dylan"));
        boolean hasJohnnyCash = false;
        while (traversal.hasNext()) {
            map = (Map)traversal.next();
            if (!((List)map.get("artists")).contains("Johnny_Cash")) continue;
            hasJohnnyCash = true;
        }
        Assert.assertTrue((boolean)hasJohnnyCash);
        Assert.assertTrue((boolean)((List)map.get("artists")).contains("Grateful_Dead"));
    }

    public static class Traversals
    extends ComplexTest {
        @Override
        public Traversal<Vertex, String> getClassicRecommendation() {
            return this.g.V(new Object[0]).has("name", (Object)"DARK STAR").as("a", new String[0]).out(new String[]{"followedBy"}).aggregate("stash").in(new String[]{"followedBy"}).where(P.neq((Object)"a").and((Predicate)P.not((P)P.within((Object[])new String[]{"stash"})))).groupCount().unfold().project("x", new String[]{"y", "z"}).by((Traversal)__.select((Column)Column.keys).values(new String[]{"name"})).by((Traversal)__.select((Column)Column.keys).values(new String[]{"performances"})).by((Traversal)__.select((Column)Column.values)).order().by((Traversal)__.select((String)"z"), (Comparator)Order.decr).by((Traversal)__.select((String)"y"), (Comparator)Order.incr).limit(5L).store("m").select("x");
        }

        @Override
        public Traversal<Vertex, Map<String, Map<String, Map<String, Object>>>> getCoworkerSummary() {
            return this.g.V(new Object[0]).hasLabel("person", new String[0]).filter((Traversal)__.outE((String[])new String[]{"created"})).aggregate("p").as("p1", new String[0]).values(new String[]{"name"}).as("p1n", new String[0]).select("p").unfold().where(P.neq((Object)"p1")).as("p2", new String[0]).values(new String[]{"name"}).as("p2n", new String[0]).select("p2").out(new String[]{"created"}).choose((Traversal)__.in((String[])new String[]{"created"}).where(P.eq((Object)"p1")), (Traversal)__.values((String[])new String[]{"name"}), (Traversal)__.constant(Collections.emptySet())).group().by((Traversal)__.select((String)"p1n")).by((Traversal)__.group().by((Traversal)__.select((String)"p2n")).by((Traversal)__.unfold().fold().project("numCoCreated", new String[]{"coCreated"}).by((Traversal)__.count((Scope)Scope.local)).by()));
        }

        @Override
        public Traversal<Vertex, Map<String, Map<String, Map<String, Object>>>> getCoworkerSummaryOLTP() {
            return this.g.V(new Object[0]).hasLabel("person", new String[0]).filter((Traversal)__.outE((String[])new String[]{"created"})).as("p1", new String[0]).V(new Object[0]).hasLabel("person", new String[0]).where(P.neq((Object)"p1")).filter((Traversal)__.outE((String[])new String[]{"created"})).as("p2", new String[0]).map((Traversal)__.out((String[])new String[]{"created"}).where((Traversal)__.in((String[])new String[]{"created"}).as("p1", new String[0])).values(new String[]{"name"}).fold()).group().by((Traversal)__.select((String)"p1").by("name")).by((Traversal)__.group().by((Traversal)__.select((String)"p2").by("name")).by((Traversal)__.project((String)"numCoCreated", (String[])new String[]{"coCreated"}).by((Traversal)__.count((Scope)Scope.local)).by()));
        }

        @Override
        public Traversal<Vertex, List<Object>> getAllShortestPaths() {
            return this.g.withoutStrategies(new Class[]{ComputerVerificationStrategy.class, PathRetractionStrategy.class}).V(new Object[0]).as("v", new String[0]).both(new String[0]).as("v", new String[0]).project("src", new String[]{"tgt", "p"}).by((Traversal)__.select((Pop)Pop.first, (String)"v")).by((Traversal)__.select((Pop)Pop.last, (String)"v")).by((Traversal)__.select((String)"v")).as("triple", new String[0]).group("x").by((Traversal)__.select((String)"src", (String)"tgt", (String[])new String[0])).by((Traversal)__.select((String)"p").fold()).select("tgt").barrier().repeat((Traversal)__.both((String[])new String[0]).as("v", new String[0]).project("src", new String[]{"tgt", "p"}).by((Traversal)__.select((Pop)Pop.first, (String)"v")).by((Traversal)__.select((Pop)Pop.last, (String)"v")).by((Traversal)__.select((String)"v")).as("t", new String[0]).filter((Traversal)__.select((String)"p").count(Scope.local).as("l", new String[0]).select(Pop.last, "t").select("p").dedup(Scope.local, new String[0]).count(Scope.local).where(P.eq((Object)"l"))).select(Pop.last, "t").not((Traversal)__.select((String)"p").as("p", new String[0]).count(Scope.local).as("l", new String[0]).select("x").unfold().filter((Traversal)__.select((Column)Column.keys).where(P.eq((Object)"t")).by((Traversal)__.select((String)"src", (String)"tgt", (String[])new String[0]))).filter((Traversal)__.select((Column)Column.values).unfold().or(new Traversal[]{__.count((Scope)Scope.local).where(P.lt((Object)"l")), __.where((P)P.eq((Object)"p"))}))).barrier().group("x").by((Traversal)__.select((String)"src", (String)"tgt", (String[])new String[0])).by((Traversal)__.select((String)"p").fold()).select("tgt").barrier()).cap("x", new String[0]).select(Column.values).unfold().unfold().map((Traversal)__.unfold().id().fold());
        }

        @Override
        public Traversal<Vertex, Map<String, List<String>>> getPlaylistPaths() {
            return this.g.V(new Object[0]).has("name", (Object)"Bob_Dylan").in(new String[]{"sungBy"}).as("a", new String[0]).repeat((Traversal)__.out((String[])new String[0]).order().by(Order.shuffle).simplePath().from("a")).until((Traversal)__.out((String[])new String[]{"writtenBy"}).has("name", (Object)"Johnny_Cash")).limit(1L).as("b", new String[0]).repeat((Traversal)__.out((String[])new String[0]).order().by(Order.shuffle).as("c", new String[0]).simplePath().from("b").to("c")).until((Traversal)__.out((String[])new String[]{"sungBy"}).has("name", (Object)"Grateful_Dead")).limit(1L).path().from("a").unfold().project("song", new String[]{"artists"}).by("name").by((Traversal)__.coalesce((Traversal[])new Traversal[]{__.out((String[])new String[]{"sungBy", "writtenBy"}).dedup(new String[0]).values(new String[]{"name"}), __.constant((Object)"Unknown")}).fold());
        }
    }
}

