/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.Comparators;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;

public final class TestHelper {
    private static final String SEP = File.separator;
    private static final char URL_SEP = '/';
    public static final String TEST_DATA_RELATIVE_DIR = "test-case-data";

    private TestHelper() {
    }

    public static File makeTestDataPath(Class clazz, String ... childPath) {
        File root = TestHelper.getRootOfBuildDirectory(clazz);
        List cleanedPaths = Stream.of(childPath).map(TestHelper::cleanPathSegment).collect(Collectors.toList());
        cleanedPaths.add(0, TestHelper.cleanPathSegment(clazz.getSimpleName()));
        File f = new File(root, TEST_DATA_RELATIVE_DIR + SEP + String.join((CharSequence)SEP, cleanedPaths));
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    public static String convertToRelative(Class clazz, File f) {
        File root = TestHelper.getRootOfBuildDirectory(clazz).getParentFile().getAbsoluteFile();
        return root.toURI().relativize(f.getAbsoluteFile().toURI()).toString();
    }

    public static String makeTestDataDirectory(Class clazz, String ... childPath) {
        return TestHelper.makeTestDataPath(clazz, childPath).getAbsolutePath() + SEP;
    }

    public static File getRootOfBuildDirectory(Class clazz) {
        File root;
        String buildDirectory = System.getProperty("build.dir");
        File file = root = null == buildDirectory ? new File(TestHelper.computePath(clazz)).getParentFile() : new File(buildDirectory);
        if (!root.exists()) {
            root.mkdirs();
        }
        return root;
    }

    private static String computePath(Class clazz) {
        String clsPath;
        String clsUri = clazz.getName().replace('.', '/') + ".class";
        URL url = clazz.getClassLoader().getResource(clsUri);
        try {
            clsPath = new File(url.toURI()).getAbsolutePath();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to computePath for " + clazz, e);
        }
        return clsPath.substring(0, clsPath.length() - clsUri.length());
    }

    public static File generateTempFile(Class clazz, String fileName, String fileNameSuffix) throws IOException {
        File path = TestHelper.makeTestDataPath(clazz, "temp");
        if (!path.exists()) {
            path.mkdirs();
        }
        return File.createTempFile(fileName, fileNameSuffix, path);
    }

    public static File generateTempFileFromResource(Class resourceClass, String resourceName, String extension) throws IOException {
        return TestHelper.generateTempFileFromResource(resourceClass, resourceClass, resourceName, extension);
    }

    public static File generateTempFileFromResource(Class graphClass, Class resourceClass, String resourceName, String extension) throws IOException {
        int data;
        File temp = TestHelper.makeTestDataPath(graphClass, "resources");
        if (!temp.exists()) {
            temp.mkdirs();
        }
        File tempFile = new File(temp, resourceName + extension);
        FileOutputStream outputStream = new FileOutputStream(tempFile);
        InputStream inputStream = resourceClass.getResourceAsStream(resourceName);
        while ((data = inputStream.read()) != -1) {
            outputStream.write(data);
        }
        outputStream.close();
        inputStream.close();
        return tempFile;
    }

    public static String convertPackageToResourcePath(Class clazz) {
        String packageName = clazz.getPackage().getName();
        return String.format("/%s/", packageName.replaceAll("\\.", "\\/"));
    }

    public static String cleanPathSegment(String toClean) {
        String cleaned = toClean.replaceAll("[.\\\\/:*?\"<>|\\[\\]\\(\\)]", "");
        if (cleaned.length() == 0) {
            throw new IllegalStateException("Path segment " + toClean + " has not valid characters and is thus empty");
        }
        return cleaned;
    }

    public static void validateVertexEquality(Vertex originalVertex, Vertex otherVertex, boolean testEdges) {
        Assert.assertEquals((Object)originalVertex, (Object)otherVertex);
        Assert.assertEquals((Object)otherVertex, (Object)originalVertex);
        Assert.assertEquals((Object)originalVertex.id(), (Object)otherVertex.id());
        Assert.assertEquals((Object)originalVertex.label(), (Object)otherVertex.label());
        Assert.assertEquals((long)originalVertex.keys().size(), (long)otherVertex.keys().size());
        for (String key : originalVertex.keys()) {
            List originalVertexProperties = IteratorUtils.list((Iterator)originalVertex.properties(new String[]{key}));
            List otherVertexProperties = IteratorUtils.list((Iterator)otherVertex.properties(new String[]{key}));
            Assert.assertEquals((long)originalVertexProperties.size(), (long)otherVertexProperties.size());
            for (VertexProperty originalVertexProperty : originalVertexProperties) {
                VertexProperty otherVertexProperty = otherVertexProperties.parallelStream().filter(vp -> vp.equals(originalVertexProperty)).findAny().get();
                TestHelper.validateVertexPropertyEquality(originalVertexProperty, otherVertexProperty);
            }
        }
        if (testEdges) {
            Iterator originalEdges = IteratorUtils.list((Iterator)originalVertex.edges(Direction.OUT, new String[0]), (Comparator)Comparators.ELEMENT_COMPARATOR).iterator();
            Iterator otherEdges = IteratorUtils.list((Iterator)otherVertex.edges(Direction.OUT, new String[0]), (Comparator)Comparators.ELEMENT_COMPARATOR).iterator();
            while (originalEdges.hasNext()) {
                TestHelper.validateEdgeEquality((Edge)originalEdges.next(), (Edge)otherEdges.next());
            }
            Assert.assertFalse((boolean)otherEdges.hasNext());
            originalEdges = IteratorUtils.list((Iterator)originalVertex.edges(Direction.IN, new String[0]), (Comparator)Comparators.ELEMENT_COMPARATOR).iterator();
            otherEdges = IteratorUtils.list((Iterator)otherVertex.edges(Direction.IN, new String[0]), (Comparator)Comparators.ELEMENT_COMPARATOR).iterator();
            while (originalEdges.hasNext()) {
                TestHelper.validateEdgeEquality((Edge)originalEdges.next(), (Edge)otherEdges.next());
            }
            Assert.assertFalse((boolean)otherEdges.hasNext());
        }
    }

    public static void validateVertexPropertyEquality(VertexProperty originalVertexProperty, VertexProperty otherVertexProperty) {
        Assert.assertEquals((Object)originalVertexProperty, (Object)otherVertexProperty);
        Assert.assertEquals((Object)otherVertexProperty, (Object)originalVertexProperty);
        if (originalVertexProperty.isPresent()) {
            Assert.assertEquals((Object)originalVertexProperty.key(), (Object)otherVertexProperty.key());
            Assert.assertEquals((Object)originalVertexProperty.value(), (Object)otherVertexProperty.value());
            Assert.assertEquals((Object)originalVertexProperty.element(), (Object)otherVertexProperty.element());
            boolean originalSupportsMetaProperties = originalVertexProperty.graph().features().vertex().supportsMetaProperties();
            boolean otherSupportsMetaProperties = otherVertexProperty.graph().features().vertex().supportsMetaProperties();
            if (originalSupportsMetaProperties && !otherSupportsMetaProperties) {
                Assert.assertEquals((long)0L, (long)originalVertexProperty.keys().size());
            } else if (!originalSupportsMetaProperties && otherSupportsMetaProperties) {
                Assert.assertEquals((long)0L, (long)otherVertexProperty.keys().size());
            } else {
                Assert.assertEquals((long)originalVertexProperty.keys().size(), (long)otherVertexProperty.keys().size());
                for (String key : originalVertexProperty.keys()) {
                    TestHelper.validatePropertyEquality(originalVertexProperty.property(key), otherVertexProperty.property(key));
                }
            }
        }
    }

    public static void validatePropertyEquality(Property originalProperty, Property otherProperty) {
        Assert.assertEquals((Object)originalProperty, (Object)otherProperty);
        Assert.assertEquals((Object)otherProperty, (Object)originalProperty);
        if (originalProperty.isPresent()) {
            Assert.assertEquals((Object)originalProperty.key(), (Object)otherProperty.key());
            Assert.assertEquals((Object)originalProperty.value(), (Object)otherProperty.value());
            Assert.assertEquals((Object)originalProperty.element(), (Object)otherProperty.element());
        }
    }

    public static void validateEdgeEquality(Edge originalEdge, Edge otherEdge) {
        Assert.assertEquals((Object)originalEdge, (Object)otherEdge);
        Assert.assertEquals((Object)otherEdge, (Object)originalEdge);
        Assert.assertEquals((Object)originalEdge.id(), (Object)otherEdge.id());
        Assert.assertEquals((Object)originalEdge.label(), (Object)otherEdge.label());
        Assert.assertEquals((Object)originalEdge.inVertex(), (Object)otherEdge.inVertex());
        Assert.assertEquals((Object)originalEdge.outVertex(), (Object)otherEdge.outVertex());
        Assert.assertEquals((long)originalEdge.keys().size(), (long)otherEdge.keys().size());
        for (String key : originalEdge.keys()) {
            TestHelper.validatePropertyEquality(originalEdge.property(key), otherEdge.property(key));
        }
    }

    public static void validateEquality(Object original, Object other) {
        if (original instanceof Vertex) {
            TestHelper.validateVertexEquality((Vertex)original, (Vertex)other, true);
        } else if (original instanceof VertexProperty) {
            TestHelper.validateVertexPropertyEquality((VertexProperty)original, (VertexProperty)other);
        } else if (original instanceof Edge) {
            TestHelper.validateEdgeEquality((Edge)original, (Edge)other);
        } else if (original instanceof Property) {
            TestHelper.validatePropertyEquality((Property)original, (Property)other);
        } else {
            throw new IllegalArgumentException("The provided object must be a graph object: " + original.getClass().getCanonicalName());
        }
    }

    public static void createRandomGraph(Graph graph, int numberOfVertices, int maxNumberOfEdgesPerVertex) {
        Random random = new Random();
        for (int i = 0; i < numberOfVertices; ++i) {
            graph.addVertex(new Object[]{T.id, i});
        }
        graph.vertices(new Object[0]).forEachRemaining(vertex -> {
            for (int i = 0; i < random.nextInt(maxNumberOfEdgesPerVertex); ++i) {
                Vertex other = (Vertex)graph.vertices(new Object[]{random.nextInt(numberOfVertices)}).next();
                vertex.addEdge("link", other, new Object[0]);
            }
        });
    }
}

