/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.ReferenceCountUtil;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticatedUser;
import org.apache.tinkerpop.gremlin.server.authz.AuthorizationException;
import org.apache.tinkerpop.gremlin.server.authz.Authorizer;
import org.apache.tinkerpop.gremlin.server.handler.HttpHandlerUtil;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpBasicAuthorizationHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(HttpBasicAuthorizationHandler.class);
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"audit.org.apache.tinkerpop.gremlin.server");
    private AuthenticatedUser user;
    private final Authorizer authorizer;

    public HttpBasicAuthorizationHandler(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpMessage) {
            FullHttpMessage request = (FullHttpMessage)msg;
            boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
            try {
                this.user = (AuthenticatedUser)ctx.channel().attr(StateKey.AUTHENTICATED_USER).get();
                if (null == this.user) {
                    this.user = AuthenticatedUser.ANONYMOUS_USER;
                }
                RequestMessage requestMessage = HttpHandlerUtil.getRequestMessageFromHttpRequest((FullHttpRequest)request);
                this.authorizer.authorize(this.user, requestMessage);
                ctx.fireChannelRead((Object)request);
            }
            catch (AuthorizationException ex) {
                String script;
                String address = ctx.channel().remoteAddress().toString();
                if (address.startsWith("/") && address.length() > 1) {
                    address = address.substring(1);
                }
                try {
                    script = (String)HttpHandlerUtil.getRequestMessageFromHttpRequest((FullHttpRequest)request).getArgOrDefault("gremlin", (Object)"");
                }
                catch (IllegalArgumentException iae) {
                    HttpHandlerUtil.sendError(ctx, HttpResponseStatus.BAD_REQUEST, iae.getMessage(), keepAlive);
                    return;
                }
                auditLogger.info("User {} with address {} attempted an unauthorized http request: {}", new Object[]{this.user.getName(), address, script});
                String message = String.format("No authorization for script [%s] - check permissions.", script);
                HttpHandlerUtil.sendError(ctx, HttpResponseStatus.UNAUTHORIZED, message, keepAlive);
                ReferenceCountUtil.release((Object)msg);
            }
            catch (Exception ex) {
                String message = String.format("%s is not ready to handle requests - unknown error", this.authorizer.getClass().getSimpleName());
                HttpHandlerUtil.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, message, keepAlive);
                ReferenceCountUtil.release((Object)msg);
            }
        } else {
            logger.warn("{} only processes FullHttpMessage instances - received {} - channel closing", (Object)((Object)((Object)this)).getClass().getSimpleName(), msg.getClass());
            ctx.close();
        }
    }
}

