/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server;

import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinScriptChecker;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.handler.Frame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context {
    private static final Logger logger = LoggerFactory.getLogger(Context.class);
    private final RequestMessage requestMessage;
    private final ChannelHandlerContext channelHandlerContext;
    private final Settings settings;
    private final GraphManager graphManager;
    private final GremlinExecutor gremlinExecutor;
    private final ScheduledExecutorService scheduledExecutorService;
    private final AtomicBoolean finalResponseWritten = new AtomicBoolean();
    private final long requestTimeout;
    private final RequestContentType requestContentType;
    private final Object gremlinArgument;

    public Context(RequestMessage requestMessage, ChannelHandlerContext ctx, Settings settings, GraphManager graphManager, GremlinExecutor gremlinExecutor, ScheduledExecutorService scheduledExecutorService) {
        this.requestMessage = requestMessage;
        this.channelHandlerContext = ctx;
        this.settings = settings;
        this.graphManager = graphManager;
        this.gremlinExecutor = gremlinExecutor;
        this.scheduledExecutorService = scheduledExecutorService;
        this.gremlinArgument = requestMessage.getArgs().get("gremlin");
        this.requestContentType = this.determineRequestContents();
        this.requestTimeout = this.determineTimeout();
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public boolean isFinalResponseWritten() {
        return this.finalResponseWritten.get();
    }

    public RequestContentType getRequestContentType() {
        return this.requestContentType;
    }

    public Object getGremlinArgument() {
        return this.gremlinArgument;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public RequestMessage getRequestMessage() {
        return this.requestMessage;
    }

    public ChannelHandlerContext getChannelHandlerContext() {
        return this.channelHandlerContext;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public GraphManager getGraphManager() {
        return this.graphManager;
    }

    public GremlinExecutor getGremlinExecutor() {
        return this.gremlinExecutor;
    }

    public void writeAndFlush(ResponseMessage message) {
        this.writeAndFlush(message.getStatus().getCode(), message);
    }

    public void writeAndFlush(ResponseStatusCode code, Object responseMessage) {
        boolean messageIsFinal = code.isFinalResponse();
        if (this.finalResponseWritten.compareAndSet(false, messageIsFinal)) {
            this.getChannelHandlerContext().writeAndFlush(responseMessage);
        } else {
            if (responseMessage instanceof Frame) {
                ((Frame)responseMessage).tryRelease();
            }
            String logMessage = String.format("Another final response message was already written for request %s, ignoring response code: %s", this.getRequestMessage().getRequestId(), code);
            logger.warn(logMessage);
        }
    }

    private RequestContentType determineRequestContents() {
        if (this.gremlinArgument instanceof Bytecode) {
            return RequestContentType.BYTECODE;
        }
        if (this.gremlinArgument instanceof String) {
            return RequestContentType.SCRIPT;
        }
        return RequestContentType.UNKNOWN;
    }

    private long determineTimeout() {
        Map args = this.requestMessage.getArgs();
        long seto = args.containsKey("evaluationTimeout") ? ((Number)args.get("evaluationTimeout")).longValue() : this.settings.getEvaluationTimeout();
        Optional timeoutDefinedInScript = this.requestContentType == RequestContentType.SCRIPT ? GremlinScriptChecker.parse((String)this.gremlinArgument.toString()).getTimeout() : Optional.empty();
        return timeoutDefinedInScript.orElse(seto);
    }

    public static enum RequestContentType {
        BYTECODE,
        SCRIPT,
        UNKNOWN;

    }
}

