/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.op;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.driver.ser.MessageTextSerializer;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.OpProcessor;
import org.apache.tinkerpop.gremlin.server.ResponseHandlerContext;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.handler.Frame;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;
import org.apache.tinkerpop.gremlin.server.op.AbstractEvalOpProcessor;
import org.apache.tinkerpop.gremlin.server.util.ExceptionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOpProcessor
implements OpProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEvalOpProcessor.class);
    protected final boolean manageTransactions;

    protected AbstractOpProcessor(boolean manageTransactions) {
        this.manageTransactions = manageTransactions;
    }

    protected void handleIterator(Context context, Iterator itty) throws InterruptedException {
        this.handleIterator(new ResponseHandlerContext(context), itty);
    }

    protected void handleIterator(ResponseHandlerContext rhc, Iterator itty) throws InterruptedException {
        boolean managedTransactionsForRequest;
        Context context = rhc.getContext();
        ChannelHandlerContext ctx = context.getChannelHandlerContext();
        RequestMessage msg = context.getRequestMessage();
        Settings settings = context.getSettings();
        MessageSerializer serializer = (MessageSerializer)ctx.channel().attr(StateKey.SERIALIZER).get();
        boolean useBinary = (Boolean)ctx.channel().attr(StateKey.USE_BINARY).get();
        boolean warnOnce = false;
        boolean bl = managedTransactionsForRequest = this.manageTransactions ? true : msg.getArgs().getOrDefault("manageTransaction", false);
        if (!itty.hasNext()) {
            if (managedTransactionsForRequest) {
                AbstractOpProcessor.attemptCommit(msg, context.getGraphManager(), settings.strictTransactionManagement);
            }
            rhc.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.NO_CONTENT).statusAttributes(this.generateStatusAttributes(ctx, msg, ResponseStatusCode.NO_CONTENT, itty, settings)).create());
            return;
        }
        int resultIterationBatchSize = msg.optionalArgs("batchSize").orElse(settings.resultIterationBatchSize);
        ArrayList<Object> aggregate = new ArrayList<Object>(resultIterationBatchSize);
        boolean hasMore = itty.hasNext();
        while (hasMore) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            boolean forceFlush = this.isForceFlushed(ctx, msg, itty);
            if (aggregate.size() < resultIterationBatchSize && itty.hasNext() && !forceFlush) {
                aggregate.add(itty.next());
            }
            if (ctx.channel().isWritable()) {
                if (!forceFlush && aggregate.size() != resultIterationBatchSize && itty.hasNext()) continue;
                ResponseStatusCode code = itty.hasNext() ? ResponseStatusCode.PARTIAL_CONTENT : ResponseStatusCode.SUCCESS;
                Frame frame = null;
                try {
                    frame = AbstractOpProcessor.makeFrame(rhc, msg, serializer, useBinary, aggregate, code, this.generateResultMetaData(ctx, msg, code, itty, settings), this.generateStatusAttributes(ctx, msg, code, itty, settings));
                }
                catch (Exception ex) {
                    if (frame != null) {
                        frame.tryRelease();
                    }
                    if (!managedTransactionsForRequest) break;
                    AbstractOpProcessor.attemptRollback(msg, context.getGraphManager(), settings.strictTransactionManagement);
                    break;
                }
                boolean moreInIterator = itty.hasNext();
                try {
                    if (moreInIterator) {
                        aggregate = new ArrayList(resultIterationBatchSize);
                    } else {
                        if (managedTransactionsForRequest) {
                            AbstractOpProcessor.attemptCommit(msg, context.getGraphManager(), settings.strictTransactionManagement);
                        }
                        hasMore = false;
                    }
                }
                catch (Exception ex) {
                    if (frame != null) {
                        frame.tryRelease();
                    }
                    throw ex;
                }
                if (!moreInIterator) {
                    this.iterateComplete(ctx, msg, itty);
                }
                rhc.writeAndFlush(code, frame);
                continue;
            }
            if (!warnOnce) {
                logger.warn("Pausing response writing as writeBufferHighWaterMark exceeded on {} - writing will continue once client has caught up", (Object)msg);
                warnOnce = true;
            }
            TimeUnit.MILLISECONDS.sleep(10L);
        }
    }

    protected void iterateComplete(ChannelHandlerContext ctx, RequestMessage msg, Iterator itty) {
    }

    protected boolean isForceFlushed(ChannelHandlerContext ctx, RequestMessage msg, Iterator itty) {
        return false;
    }

    @Deprecated
    protected Map<String, Object> generateMetaData(ChannelHandlerContext ctx, RequestMessage msg, ResponseStatusCode code, Iterator itty) {
        return Collections.emptyMap();
    }

    protected Map<String, Object> generateResultMetaData(ChannelHandlerContext ctx, RequestMessage msg, ResponseStatusCode code, Iterator itty, Settings settings) {
        return this.generateMetaData(ctx, msg, code, itty);
    }

    protected Map<String, Object> generateStatusAttributes(ChannelHandlerContext ctx, RequestMessage msg, ResponseStatusCode code, Iterator itty, Settings settings) {
        if (itty.hasNext()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.put("host", ctx.channel().remoteAddress().toString());
        return metaData;
    }

    protected static Frame makeFrame(ChannelHandlerContext ctx, RequestMessage msg, MessageSerializer serializer, boolean useBinary, List<Object> aggregate, ResponseStatusCode code, Map<String, Object> responseMetaData, Map<String, Object> statusAttributes) throws Exception {
        Context context = new Context(msg, ctx, null, null, null, null);
        ResponseHandlerContext rhc = new ResponseHandlerContext(context);
        return AbstractOpProcessor.makeFrame(rhc, msg, serializer, useBinary, aggregate, code, responseMetaData, statusAttributes);
    }

    protected static Frame makeFrame(ResponseHandlerContext rhc, RequestMessage msg, MessageSerializer serializer, boolean useBinary, List<Object> aggregate, ResponseStatusCode code, Map<String, Object> responseMetaData, Map<String, Object> statusAttributes) throws Exception {
        ChannelHandlerContext ctx = rhc.getContext().getChannelHandlerContext();
        try {
            if (useBinary) {
                return new Frame(serializer.serializeResponseAsBinary(ResponseMessage.build((RequestMessage)msg).code(code).statusAttributes(statusAttributes).responseMetaData(responseMetaData).result(aggregate).create(), ctx.alloc()));
            }
            MessageTextSerializer textSerializer = (MessageTextSerializer)serializer;
            return new Frame(textSerializer.serializeResponseAsString(ResponseMessage.build((RequestMessage)msg).code(code).statusAttributes(statusAttributes).responseMetaData(responseMetaData).result(aggregate).create()));
        }
        catch (Exception ex) {
            logger.warn("The result [{}] in the request {} could not be serialized and returned.", new Object[]{aggregate, msg.getRequestId(), ex});
            String errorMessage = String.format("Error during serialization: %s", ExceptionHelper.getMessageFromExceptionOrCause(ex));
            ResponseMessage error = ResponseMessage.build((UUID)msg.getRequestId()).statusMessage(errorMessage).statusAttributeException((Throwable)ex).code(ResponseStatusCode.SERVER_ERROR_SERIALIZATION).create();
            rhc.writeAndFlush(error);
            throw ex;
        }
    }

    protected static void attemptCommit(RequestMessage msg, GraphManager graphManager, boolean strict) {
        if (strict) {
            if (msg.getArgs().containsKey("aliases")) {
                Map aliases = (Map)msg.getArgs().get("aliases");
                graphManager.commit(new HashSet<String>(aliases.values()));
            } else {
                graphManager.commitAll();
            }
        } else {
            graphManager.commitAll();
        }
    }

    protected static void attemptRollback(RequestMessage msg, GraphManager graphManager, boolean strict) {
        if (strict) {
            if (msg.getArgs().containsKey("aliases")) {
                Map aliases = (Map)msg.getArgs().get("aliases");
                graphManager.rollback(new HashSet<String>(aliases.values()));
            } else {
                graphManager.rollbackAll();
            }
        } else {
            graphManager.rollbackAll();
        }
    }
}

