/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server;

import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.server.OpProcessor;
import org.apache.tinkerpop.gremlin.server.auth.AllowAllAuthenticator;
import org.apache.tinkerpop.gremlin.server.channel.WebSocketChannelizer;
import org.apache.tinkerpop.gremlin.server.util.DefaultGraphManager;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class Settings {
    public String host = "localhost";
    public int port = 8182;
    public int threadPoolWorker = 1;
    public boolean useEpollEventLoop = false;
    public int gremlinPool = 0;
    public int threadPoolBoss = 1;
    @Deprecated
    public long scriptEvaluationTimeout = -1L;
    public long evaluationTimeout = 30000L;
    @Deprecated
    public long serializedResponseTimeout = 0L;
    public int resultIterationBatchSize = 64;
    public int maxInitialLineLength = 4096;
    public int maxHeaderSize = 8192;
    public int maxChunkSize = 8192;
    public int maxContentLength = 65536;
    public int maxAccumulationBufferComponents = 1024;
    public int writeBufferHighWaterMark = 65536;
    public int writeBufferLowWaterMark = 32768;
    public long idleConnectionTimeout = 0L;
    public long keepAliveInterval = 0L;
    public boolean strictTransactionManagement = false;
    public String channelizer = WebSocketChannelizer.class.getName();
    public String graphManager = DefaultGraphManager.class.getName();
    public ServerMetrics metrics = null;
    public Map<String, String> graphs = new HashMap<String, String>();
    public Map<String, ScriptEngineSettings> scriptEngines;
    public List<SerializerSettings> serializers = Collections.emptyList();
    public SslSettings ssl = null;
    public AuthenticationSettings authentication = new AuthenticationSettings();
    public List<ProcessorSettings> processors = new ArrayList<ProcessorSettings>();

    public Settings() {
        this.scriptEngines = new HashMap<String, ScriptEngineSettings>();
        this.scriptEngines.put("gremlin-groovy", new ScriptEngineSettings());
    }

    public Optional<ProcessorSettings> optionalProcessor(Class<? extends OpProcessor> clazz) {
        return this.processors.stream().filter(p -> p.className.equals(clazz.getCanonicalName())).findFirst();
    }

    public Optional<ServerMetrics> optionalMetrics() {
        return Optional.ofNullable(this.metrics);
    }

    public Optional<SslSettings> optionalSsl() {
        return Optional.ofNullable(this.ssl);
    }

    public long getEvaluationTimeout() {
        return -1L == this.scriptEvaluationTimeout ? this.evaluationTimeout : this.scriptEvaluationTimeout;
    }

    public static Settings read(String file) throws Exception {
        FileInputStream input = new FileInputStream(new File(file));
        return Settings.read(input);
    }

    public static Settings read(InputStream stream) {
        Objects.requireNonNull(stream);
        Constructor constructor = new Constructor(Settings.class);
        TypeDescription settingsDescription = new TypeDescription(Settings.class);
        settingsDescription.putMapPropertyType("graphs", String.class, String.class);
        settingsDescription.putMapPropertyType("scriptEngines", String.class, ScriptEngineSettings.class);
        settingsDescription.putListPropertyType("serializers", SerializerSettings.class);
        settingsDescription.putListPropertyType("plugins", String.class);
        settingsDescription.putListPropertyType("processors", ProcessorSettings.class);
        constructor.addTypeDescription(settingsDescription);
        TypeDescription serializerSettingsDescription = new TypeDescription(SerializerSettings.class);
        serializerSettingsDescription.putMapPropertyType("config", String.class, Object.class);
        constructor.addTypeDescription(serializerSettingsDescription);
        TypeDescription scriptEngineSettingsDescription = new TypeDescription(ScriptEngineSettings.class);
        scriptEngineSettingsDescription.putListPropertyType("imports", String.class);
        scriptEngineSettingsDescription.putListPropertyType("staticImports", String.class);
        scriptEngineSettingsDescription.putListPropertyType("scripts", String.class);
        scriptEngineSettingsDescription.putMapPropertyType("config", String.class, Object.class);
        scriptEngineSettingsDescription.putMapPropertyType("plugins", String.class, Object.class);
        constructor.addTypeDescription(scriptEngineSettingsDescription);
        TypeDescription sslSettings = new TypeDescription(SslSettings.class);
        constructor.addTypeDescription(sslSettings);
        TypeDescription authenticationSettings = new TypeDescription(AuthenticationSettings.class);
        constructor.addTypeDescription(authenticationSettings);
        TypeDescription serverMetricsDescription = new TypeDescription(ServerMetrics.class);
        constructor.addTypeDescription(serverMetricsDescription);
        TypeDescription consoleReporterDescription = new TypeDescription(ConsoleReporterMetrics.class);
        constructor.addTypeDescription(consoleReporterDescription);
        TypeDescription csvReporterDescription = new TypeDescription(CsvReporterMetrics.class);
        constructor.addTypeDescription(csvReporterDescription);
        TypeDescription jmxReporterDescription = new TypeDescription(JmxReporterMetrics.class);
        constructor.addTypeDescription(jmxReporterDescription);
        TypeDescription slf4jReporterDescription = new TypeDescription(Slf4jReporterMetrics.class);
        constructor.addTypeDescription(slf4jReporterDescription);
        TypeDescription gangliaReporterDescription = new TypeDescription(GangliaReporterMetrics.class);
        constructor.addTypeDescription(gangliaReporterDescription);
        TypeDescription graphiteReporterDescription = new TypeDescription(GraphiteReporterMetrics.class);
        constructor.addTypeDescription(graphiteReporterDescription);
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        return (Settings)yaml.loadAs(stream, Settings.class);
    }

    public static abstract class BaseMetrics {
        public boolean enabled = false;
    }

    public static abstract class IntervalMetrics
    extends BaseMetrics {
        public long interval = 60000L;
    }

    public static abstract class HostPortIntervalMetrics
    extends IntervalMetrics {
        public String host = "localhost";
        public int port;
    }

    public static class GraphiteReporterMetrics
    extends HostPortIntervalMetrics {
        public String prefix = "";

        public GraphiteReporterMetrics() {
            this.port = 2003;
        }
    }

    public static class GangliaReporterMetrics
    extends HostPortIntervalMetrics {
        public String addressingMode = null;
        public int ttl = 1;
        public boolean protocol31 = true;
        public UUID hostUUID = null;
        public String spoof = null;

        public GangliaReporterMetrics() {
            this.port = 8649;
        }
    }

    public static class Slf4jReporterMetrics
    extends IntervalMetrics {
        public String loggerName = Slf4jReporterMetrics.class.getName();
    }

    public static class JmxReporterMetrics
    extends BaseMetrics {
        public String domain = null;
        public String agentId = null;
    }

    public static class CsvReporterMetrics
    extends IntervalMetrics {
        public String fileName = "metrics.csv";
    }

    public static class ConsoleReporterMetrics
    extends IntervalMetrics {
    }

    public static class ServerMetrics {
        public ConsoleReporterMetrics consoleReporter = null;
        public CsvReporterMetrics csvReporter = null;
        public JmxReporterMetrics jmxReporter = null;
        public Slf4jReporterMetrics slf4jReporter = null;
        public GangliaReporterMetrics gangliaReporter = null;
        public GraphiteReporterMetrics graphiteReporter = null;

        public Optional<ConsoleReporterMetrics> optionalConsoleReporter() {
            return Optional.ofNullable(this.consoleReporter);
        }

        public Optional<CsvReporterMetrics> optionalCsvReporter() {
            return Optional.ofNullable(this.csvReporter);
        }

        public Optional<JmxReporterMetrics> optionalJmxReporter() {
            return Optional.ofNullable(this.jmxReporter);
        }

        public Optional<Slf4jReporterMetrics> optionalSlf4jReporter() {
            return Optional.ofNullable(this.slf4jReporter);
        }

        public Optional<GangliaReporterMetrics> optionalGangliaReporter() {
            return Optional.ofNullable(this.gangliaReporter);
        }

        public Optional<GraphiteReporterMetrics> optionalGraphiteReporter() {
            return Optional.ofNullable(this.graphiteReporter);
        }
    }

    public static class SslSettings {
        public boolean enabled = false;
        @Deprecated
        public String keyCertChainFile = null;
        @Deprecated
        public String keyFile = null;
        @Deprecated
        public String keyPassword = null;
        @Deprecated
        public String trustCertChainFile = null;
        public String keyStore;
        public String keyStorePassword;
        public String trustStore;
        public String trustStorePassword;
        public String keyStoreType;
        public String trustStoreType;
        public List<String> sslEnabledProtocols = new ArrayList<String>();
        public List<String> sslCipherSuites = new ArrayList<String>();
        public ClientAuth needClientAuth = ClientAuth.NONE;
        private SslContext sslContext;

        public void overrideSslContext(SslContext sslContext) {
            this.sslContext = sslContext;
        }

        public Optional<SslContext> getSslContext() {
            return Optional.ofNullable(this.sslContext);
        }
    }

    public static class AuthenticationSettings {
        public String authenticator = null;
        @Deprecated
        public String className = AllowAllAuthenticator.class.getName();
        public String authenticationHandler = null;
        public boolean enableAuditLog = false;
        public Map<String, Object> config = null;
    }

    public static class SerializerSettings {
        public String className;
        public Map<String, Object> config = Collections.emptyMap();

        public SerializerSettings() {
        }

        SerializerSettings(String className, Map<String, Object> config) {
            this.className = className;
            this.config = config;
        }
    }

    public static class ScriptEngineSettings {
        public List<String> imports = new ArrayList<String>();
        public List<String> staticImports = new ArrayList<String>();
        public List<String> scripts = new ArrayList<String>();
        public Map<String, Object> config = null;
        public Map<String, Map<String, Object>> plugins = new LinkedHashMap<String, Map<String, Object>>();
    }

    public static class ProcessorSettings {
        public String className;
        public Map<String, Object> config;
    }
}

