/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.op;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.commons.lang.time.StopWatch;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.driver.ser.MessageTextSerializer;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.groovy.jsr223.customizer.TimedInterruptTimeoutException;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.OpProcessor;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.handler.Frame;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;
import org.apache.tinkerpop.gremlin.server.op.OpProcessorException;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.util.function.ThrowingConsumer;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEvalOpProcessor
implements OpProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEvalOpProcessor.class);
    public static final Timer evalOpTimer = MetricManager.INSTANCE.getTimer(MetricRegistry.name(GremlinServer.class, (String[])new String[]{"op", "eval"}));
    @Deprecated
    static final Meter errorMeter = MetricManager.INSTANCE.getMeter(MetricRegistry.name(GremlinServer.class, (String[])new String[]{"errors"}));
    @Deprecated
    protected static final Pattern validBindingName = Pattern.compile("[a-zA-Z$_][a-zA-Z0-9$_]*");
    protected static final Set<String> INVALID_BINDINGS_KEYS = new HashSet<String>();
    protected final boolean manageTransactions;

    protected AbstractEvalOpProcessor(boolean manageTransactions) {
        this.manageTransactions = manageTransactions;
    }

    public abstract ThrowingConsumer<Context> getEvalOp();

    public abstract Optional<ThrowingConsumer<Context>> selectOther(RequestMessage var1) throws OpProcessorException;

    @Override
    public ThrowingConsumer<Context> select(Context ctx) throws OpProcessorException {
        ThrowingConsumer<Context> op;
        RequestMessage message = ctx.getRequestMessage();
        logger.debug("Selecting processor for RequestMessage {}", (Object)message);
        switch (message.getOp()) {
            case "eval": {
                op = this.validateEvalMessage(message).orElse(this.getEvalOp());
                break;
            }
            case "invalid": {
                String msgInvalid = String.format("Message could not be parsed.  Check the format of the request. [%s]", message);
                throw new OpProcessorException(msgInvalid, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_MALFORMED_REQUEST).statusMessage(msgInvalid).create());
            }
            default: {
                op = this.selectOther(message).orElseThrow(() -> {
                    String msgDefault = String.format("Message with op code [%s] is not recognized.", message.getOp());
                    return new OpProcessorException(msgDefault, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_MALFORMED_REQUEST).statusMessage(msgDefault).create());
                });
            }
        }
        return op;
    }

    protected Optional<ThrowingConsumer<Context>> validateEvalMessage(RequestMessage message) throws OpProcessorException {
        if (!message.optionalArgs("gremlin").isPresent()) {
            String msg = String.format("A message with an [%s] op code requires a [%s] argument.", "eval", "gremlin");
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
        }
        if (message.optionalArgs("bindings").isPresent()) {
            Map bindings = (Map)message.getArgs().get("bindings");
            if (bindings.keySet().stream().anyMatch(k -> null == k || !(k instanceof String))) {
                String msg = String.format("The [%s] message is using one or more invalid binding keys - they must be of type String and cannot be null", "eval");
                throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
            }
            Set badBindings = IteratorUtils.set((Iterator)IteratorUtils.filter(bindings.keySet().iterator(), INVALID_BINDINGS_KEYS::contains));
            if (!badBindings.isEmpty()) {
                String msg = String.format("The [%s] message supplies one or more invalid parameters key of [%s] - these are reserved names.", "eval", badBindings);
                throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
            }
        }
        return Optional.empty();
    }

    protected void evalOpInternal(Context context, Supplier<GremlinExecutor> gremlinExecutorSupplier, BindingSupplier bindingsSupplier) throws OpProcessorException {
        Timer.Context timerContext = evalOpTimer.time();
        ChannelHandlerContext ctx = context.getChannelHandlerContext();
        RequestMessage msg = context.getRequestMessage();
        GremlinExecutor gremlinExecutor = gremlinExecutorSupplier.get();
        Settings settings = context.getSettings();
        Map args = msg.getArgs();
        String script = (String)args.get("gremlin");
        String language = args.containsKey("language") ? (String)args.get("language") : null;
        SimpleBindings bindings = new SimpleBindings();
        boolean managedTransactionsForRequest = this.manageTransactions ? true : args.getOrDefault("manageTransaction", false);
        long seto = args.containsKey("scriptEvaluationTimeout") ? Long.parseLong(args.get("scriptEvaluationTimeout").toString()) : settings.scriptEvaluationTimeout;
        GremlinExecutor.LifeCycle lifeCycle = GremlinExecutor.LifeCycle.build().scriptEvaluationTimeoutOverride(Long.valueOf(seto)).afterFailure((b, t) -> {
            if (managedTransactionsForRequest) {
                AbstractEvalOpProcessor.attemptRollback(msg, context.getGraphManager(), settings.strictTransactionManagement);
            }
        }).beforeEval(b -> {
            try {
                b.putAll(bindingsSupplier.get());
            }
            catch (OpProcessorException ope) {
                throw new RuntimeException(ope);
            }
        }).withResult(o -> {
            block6: {
                Iterator itty = IteratorUtils.asIterator((Object)o);
                logger.debug("Preparing to iterate results from - {} - in thread [{}]", (Object)msg, (Object)Thread.currentThread().getName());
                try {
                    this.handleIterator(context, itty);
                }
                catch (TimeoutException ex) {
                    String errorMessage = String.format("Response iteration exceeded the configured threshold for request [%s] - %s", msg, ex.getMessage());
                    logger.warn(errorMessage);
                    ctx.writeAndFlush((Object)ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_TIMEOUT).statusMessage(errorMessage).create());
                    if (managedTransactionsForRequest) {
                        AbstractEvalOpProcessor.attemptRollback(msg, context.getGraphManager(), settings.strictTransactionManagement);
                    }
                }
                catch (InterruptedException ex) {
                    logger.warn(String.format("Interruption during result iteration on request [%s].", msg), (Throwable)ex);
                    String exceptionMsg = ex.getMessage();
                    String err = "Interruption of result iteration" + (null == exceptionMsg || exceptionMsg.isEmpty() ? "" : " - " + exceptionMsg);
                    ctx.writeAndFlush((Object)ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(err).create());
                    if (managedTransactionsForRequest) {
                        AbstractEvalOpProcessor.attemptRollback(msg, context.getGraphManager(), settings.strictTransactionManagement);
                    }
                }
                catch (Exception ex) {
                    logger.warn(String.format("Exception processing a script on request [%s].", msg), (Throwable)ex);
                    String err = ex.getMessage();
                    ctx.writeAndFlush((Object)ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(null == err || err.isEmpty() ? ex.getClass().getSimpleName() : err).create());
                    if (!managedTransactionsForRequest) break block6;
                    AbstractEvalOpProcessor.attemptRollback(msg, context.getGraphManager(), settings.strictTransactionManagement);
                }
            }
        }).create();
        CompletableFuture evalFuture = gremlinExecutor.eval(script, language, (Bindings)bindings, lifeCycle);
        evalFuture.handle((v, t) -> {
            timerContext.stop();
            if (t != null) {
                if (t instanceof OpProcessorException) {
                    ctx.writeAndFlush((Object)((OpProcessorException)t).getResponseMessage());
                } else if (t instanceof TimedInterruptTimeoutException) {
                    String errorMessage = String.format("A timeout occurred within the script during evaluation of [%s] - consider increasing the limit given to TimedInterruptCustomizerProvider", msg);
                    logger.warn(errorMessage);
                    ctx.writeAndFlush((Object)ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_TIMEOUT).statusMessage("Timeout during script evaluation triggered by TimedInterruptCustomizerProvider").create());
                } else if (t instanceof TimeoutException) {
                    String errorMessage = String.format("Response evaluation exceeded the configured threshold for request [%s] - %s", msg, t.getMessage());
                    logger.warn(errorMessage, t);
                    ctx.writeAndFlush((Object)ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_TIMEOUT).statusMessage(t.getMessage()).create());
                } else {
                    logger.warn(String.format("Exception processing a script on request [%s].", msg), t);
                    ctx.writeAndFlush((Object)ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR_SCRIPT_EVALUATION).statusMessage(t.getMessage()).create());
                }
            }
            return null;
        });
    }

    protected void handleIterator(Context context, Iterator itty) throws TimeoutException, InterruptedException {
        boolean managedTransactionsForRequest;
        ChannelHandlerContext ctx = context.getChannelHandlerContext();
        RequestMessage msg = context.getRequestMessage();
        Settings settings = context.getSettings();
        MessageSerializer serializer = (MessageSerializer)ctx.channel().attr(StateKey.SERIALIZER).get();
        boolean useBinary = (Boolean)ctx.channel().attr(StateKey.USE_BINARY).get();
        boolean warnOnce = false;
        boolean bl = managedTransactionsForRequest = this.manageTransactions ? true : msg.getArgs().getOrDefault("manageTransaction", false);
        if (!itty.hasNext()) {
            if (managedTransactionsForRequest) {
                AbstractEvalOpProcessor.attemptCommit(msg, context.getGraphManager(), settings.strictTransactionManagement);
            }
            ctx.writeAndFlush((Object)ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.NO_CONTENT).create());
            return;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        int resultIterationBatchSize = msg.optionalArgs("batchSize").orElse(settings.resultIterationBatchSize);
        ArrayList<Object> aggregate = new ArrayList<Object>(resultIterationBatchSize);
        boolean hasMore = itty.hasNext();
        while (hasMore) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (aggregate.size() < resultIterationBatchSize && itty.hasNext()) {
                aggregate.add(itty.next());
            }
            if (ctx.channel().isWritable()) {
                if (aggregate.size() == resultIterationBatchSize || !itty.hasNext()) {
                    Frame frame;
                    ResponseStatusCode code = itty.hasNext() ? ResponseStatusCode.PARTIAL_CONTENT : ResponseStatusCode.SUCCESS;
                    try {
                        frame = AbstractEvalOpProcessor.makeFrame(ctx, msg, serializer, useBinary, aggregate, code);
                    }
                    catch (Exception ex) {
                        if (!this.manageTransactions) break;
                        AbstractEvalOpProcessor.attemptRollback(msg, context.getGraphManager(), settings.strictTransactionManagement);
                        break;
                    }
                    if (itty.hasNext()) {
                        aggregate = new ArrayList(resultIterationBatchSize);
                    } else {
                        if (managedTransactionsForRequest) {
                            AbstractEvalOpProcessor.attemptCommit(msg, context.getGraphManager(), settings.strictTransactionManagement);
                        }
                        hasMore = false;
                    }
                    ctx.writeAndFlush((Object)frame);
                }
            } else {
                if (!warnOnce) {
                    logger.warn("Pausing response writing as writeBufferHighWaterMark exceeded on {} - writing will continue once client has caught up", (Object)msg);
                    warnOnce = true;
                }
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            stopWatch.split();
            if (stopWatch.getSplitTime() > settings.serializedResponseTimeout) {
                String timeoutMsg = String.format("Serialization of the entire response exceeded the 'serializeResponseTimeout' setting %s", warnOnce ? "[Gremlin Server paused writes to client as messages were not being consumed quickly enough]" : "");
                throw new TimeoutException(timeoutMsg.trim());
            }
            stopWatch.unsplit();
        }
        stopWatch.stop();
    }

    private static Frame makeFrame(ChannelHandlerContext ctx, RequestMessage msg, MessageSerializer serializer, boolean useBinary, List<Object> aggregate, ResponseStatusCode code) throws Exception {
        try {
            if (useBinary) {
                return new Frame(serializer.serializeResponseAsBinary(ResponseMessage.build((RequestMessage)msg).code(code).result(aggregate).create(), ctx.alloc()));
            }
            MessageTextSerializer textSerializer = (MessageTextSerializer)serializer;
            return new Frame(textSerializer.serializeResponseAsString(ResponseMessage.build((RequestMessage)msg).code(code).result(aggregate).create()));
        }
        catch (Exception ex) {
            logger.warn("The result [{}] in the request {} could not be serialized and returned.", new Object[]{aggregate, msg.getRequestId(), ex});
            String errorMessage = String.format("Error during serialization: %s", ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage());
            ResponseMessage error = ResponseMessage.build((UUID)msg.getRequestId()).statusMessage(errorMessage).code(ResponseStatusCode.SERVER_ERROR_SERIALIZATION).create();
            ctx.writeAndFlush((Object)error);
            throw ex;
        }
    }

    private static void attemptCommit(RequestMessage msg, GraphManager graphManager, boolean strict) {
        if (strict) {
            String rebindingOrAliasParameter;
            boolean hasRebindings = msg.getArgs().containsKey("rebindings");
            String string = rebindingOrAliasParameter = hasRebindings ? "rebindings" : "aliases";
            if (msg.getArgs().containsKey(rebindingOrAliasParameter)) {
                Map aliases = (Map)msg.getArgs().get(rebindingOrAliasParameter);
                graphManager.commit(new HashSet<String>(aliases.values()));
            } else {
                graphManager.commitAll();
            }
        } else {
            graphManager.commitAll();
        }
    }

    private static void attemptRollback(RequestMessage msg, GraphManager graphManager, boolean strict) {
        if (strict) {
            String rebindingOrAliasParameter;
            boolean hasRebindings = msg.getArgs().containsKey("rebindings");
            String string = rebindingOrAliasParameter = hasRebindings ? "rebindings" : "aliases";
            if (msg.getArgs().containsKey(rebindingOrAliasParameter)) {
                Map aliases = (Map)msg.getArgs().get(rebindingOrAliasParameter);
                graphManager.rollback(new HashSet<String>(aliases.values()));
            } else {
                graphManager.rollbackAll();
            }
        } else {
            graphManager.rollbackAll();
        }
    }

    static {
        INVALID_BINDINGS_KEYS.addAll(Arrays.asList(T.id.name(), T.key.name(), T.label.name(), T.value.name(), T.id.getAccessor(), T.key.getAccessor(), T.label.getAccessor(), T.value.getAccessor(), T.id.getAccessor().toUpperCase(), T.key.getAccessor().toUpperCase(), T.label.getAccessor().toUpperCase(), T.value.getAccessor().toUpperCase()));
        for (Column column : Column.values()) {
            INVALID_BINDINGS_KEYS.add(column.name());
        }
        for (Column column : Order.values()) {
            INVALID_BINDINGS_KEYS.add(column.name());
        }
        for (Column column : Operator.values()) {
            INVALID_BINDINGS_KEYS.add(column.name());
        }
        for (Column column : Scope.values()) {
            INVALID_BINDINGS_KEYS.add(column.name());
        }
        for (Column column : Pop.values()) {
            INVALID_BINDINGS_KEYS.add(column.name());
        }
    }

    @FunctionalInterface
    public static interface BindingSupplier {
        public Bindings get() throws OpProcessorException;
    }
}

