/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.python.jsr223;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.SackFunctions;
import org.apache.tinkerpop.gremlin.process.traversal.Translator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.python.jsr223.SymbolHelper;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.function.Lambda;
import org.apache.tinkerpop.gremlin.util.iterator.ArrayIterator;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class PythonTranslator
implements Translator.ScriptTranslator {
    private static final boolean IS_TESTING = Boolean.valueOf(System.getProperty("is.testing", "false"));
    private static final Set<String> STEP_NAMES = Stream.of(GraphTraversal.class.getMethods()).filter(method -> Traversal.class.isAssignableFrom(method.getReturnType())).map(Method::getName).collect(Collectors.toSet());
    private static final Set<String> NO_STATIC = Stream.of(T.values(), Operator.values()).flatMap(arg -> IteratorUtils.stream((Iterator)new ArrayIterator((Object[])arg))).map(arg -> arg.name()).collect(Collectors.toCollection(() -> new HashSet<String>(Collections.singleton("not"))));
    private final String traversalSource;
    private final boolean importStatics;

    PythonTranslator(String traversalSource, boolean importStatics) {
        this.traversalSource = traversalSource;
        this.importStatics = importStatics;
    }

    public static PythonTranslator of(String traversalSource, boolean importStatics) {
        return new PythonTranslator(traversalSource, importStatics);
    }

    public static PythonTranslator of(String traversalSource) {
        return new PythonTranslator(traversalSource, false);
    }

    public String getTraversalSource() {
        return this.traversalSource;
    }

    public String translate(Bytecode bytecode) {
        return this.internalTranslate(this.traversalSource, bytecode);
    }

    public String getTargetLanguage() {
        return "gremlin-python";
    }

    public String toString() {
        return StringFactory.translatorString((Translator)this);
    }

    private String internalTranslate(String start, Bytecode bytecode) {
        StringBuilder traversalScript = new StringBuilder(start);
        for (Bytecode.Instruction instruction : bytecode.getInstructions()) {
            String methodName = instruction.getOperator();
            Object[] arguments = instruction.getArguments();
            if (IS_TESTING && instruction.getOperator().equals("withStrategies") && instruction.getArguments()[0].toString().contains("TranslationStrategy")) continue;
            if (0 == arguments.length) {
                traversalScript.append(".").append(SymbolHelper.toPython(methodName)).append("()");
            } else if (methodName.equals("range") && 2 == arguments.length) {
                traversalScript.append("[").append(arguments[0]).append(":").append(arguments[1]).append("]");
            } else if (methodName.equals("limit") && 1 == arguments.length) {
                traversalScript.append("[0:").append(arguments[0]).append("]");
            } else if (methodName.equals("values") && 1 == arguments.length && traversalScript.length() > 3 && !STEP_NAMES.contains(arguments[0].toString())) {
                traversalScript.append(".").append(arguments[0]);
            } else {
                traversalScript.append(".");
                String temp = SymbolHelper.toPython(methodName) + "(";
                for (Object object : arguments) {
                    temp = temp + this.convertToString(object) + ",";
                }
                traversalScript.append(temp.substring(0, temp.length() - 1)).append(")");
            }
            if (!this.importStatics || !traversalScript.substring(0, 3).startsWith("__.") || NO_STATIC.stream().filter(name -> traversalScript.substring(3).startsWith(SymbolHelper.toPython(name))).findAny().isPresent()) continue;
            traversalScript.delete(0, 3);
        }
        return traversalScript.toString();
    }

    private String convertToString(Object object) {
        if (object instanceof Bytecode.Binding) {
            return ((Bytecode.Binding)object).variable();
        }
        if (object instanceof Bytecode) {
            return this.internalTranslate("__", (Bytecode)object);
        }
        if (object instanceof Traversal) {
            return this.convertToString(((Traversal)object).asAdmin().getBytecode());
        }
        if (object instanceof String) {
            return ((String)object).contains("\"") ? "\"\"\"" + object + "\"\"\"" : "\"" + object + "\"";
        }
        if (object instanceof Set) {
            LinkedHashSet<String> set = new LinkedHashSet<String>(((Set)object).size());
            for (Object item : (Set)object) {
                set.add(this.convertToString(item));
            }
            return "set(" + ((Object)set).toString() + ")";
        }
        if (object instanceof List) {
            ArrayList<String> list = new ArrayList<String>(((List)object).size());
            for (Object item : (List)object) {
                list.add(this.convertToString(item));
            }
            return ((Object)list).toString();
        }
        if (object instanceof Map) {
            StringBuilder map = new StringBuilder("{");
            for (Map.Entry entry : ((Map)object).entrySet()) {
                map.append(this.convertToString(entry.getKey())).append(":").append(this.convertToString(entry.getValue())).append(",");
            }
            return map.length() > 1 ? map.substring(0, map.length() - 1) + "}" : map.append("}").toString();
        }
        if (object instanceof Long) {
            return object + "L";
        }
        if (object instanceof TraversalStrategyProxy) {
            TraversalStrategyProxy proxy = (TraversalStrategyProxy)object;
            if (proxy.getConfiguration().isEmpty()) {
                return "TraversalStrategy(\"" + proxy.getStrategyClass().getSimpleName() + "\")";
            }
            return "TraversalStrategy(\"" + proxy.getStrategyClass().getSimpleName() + "\"," + this.convertToString(ConfigurationConverter.getMap((Configuration)proxy.getConfiguration())) + ")";
        }
        if (object instanceof TraversalStrategy) {
            return this.convertToString(new TraversalStrategyProxy((TraversalStrategy)object));
        }
        if (object instanceof Boolean) {
            return object.equals(Boolean.TRUE) ? "True" : "False";
        }
        if (object instanceof Class) {
            return ((Class)object).getCanonicalName();
        }
        if (object instanceof VertexProperty.Cardinality) {
            return "Cardinality." + SymbolHelper.toPython(object.toString());
        }
        if (object instanceof SackFunctions.Barrier) {
            return "Barrier." + SymbolHelper.toPython(object.toString());
        }
        if (object instanceof Enum) {
            return this.convertStatic(((Enum)object).getDeclaringClass().getSimpleName() + ".") + SymbolHelper.toPython(object.toString());
        }
        if (object instanceof P) {
            return this.convertPToString((P)object, new StringBuilder()).toString();
        }
        if (object instanceof Element) {
            return this.convertToString(((Element)object).id());
        }
        if (object instanceof Lambda) {
            return this.convertLambdaToString((Lambda)object);
        }
        return null == object ? "None" : object.toString();
    }

    private String convertStatic(String name) {
        return this.importStatics ? "" : name;
    }

    private StringBuilder convertPToString(P p, StringBuilder current) {
        if (p instanceof ConnectiveP) {
            List list = ((ConnectiveP)p).getPredicates();
            for (int i = 0; i < list.size(); ++i) {
                this.convertPToString((P)list.get(i), current);
                if (i >= list.size() - 1) continue;
                current.append(p instanceof OrP ? ".or_(" : ".and_(");
            }
            current.append(")");
        } else {
            current.append(this.convertStatic("P.")).append(p.getBiPredicate().toString()).append("(").append(this.convertToString(p.getValue())).append(")");
        }
        return current;
    }

    protected String convertLambdaToString(Lambda lambda) {
        String lambdaString = lambda.getLambdaScript().trim();
        return lambdaString.startsWith("lambda") ? lambdaString : "lambda " + lambdaString;
    }
}

