/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.OptionsStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.BytecodeHelper;

public final class RequestOptions {
    public static final RequestOptions EMPTY = RequestOptions.build().create();
    private final Map<String, String> aliases;
    private final Map<String, Object> parameters;
    private final Integer batchSize;
    private final Long timeout;
    private final UUID overrideRequestId;
    private final String userAgent;
    private final String language;

    private RequestOptions(Builder builder) {
        this.aliases = builder.aliases;
        this.parameters = builder.parameters;
        this.batchSize = builder.batchSize;
        this.timeout = builder.timeout;
        this.overrideRequestId = builder.overrideRequestId;
        this.userAgent = builder.userAgent;
        this.language = builder.language;
    }

    public Optional<UUID> getOverrideRequestId() {
        return Optional.ofNullable(this.overrideRequestId);
    }

    public Optional<Map<String, String>> getAliases() {
        return Optional.ofNullable(this.aliases);
    }

    public Optional<Map<String, Object>> getParameters() {
        return Optional.ofNullable(this.parameters);
    }

    public Optional<Integer> getBatchSize() {
        return Optional.ofNullable(this.batchSize);
    }

    public Optional<Long> getTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    public Optional<String> getUserAgent() {
        return Optional.ofNullable(this.userAgent);
    }

    public Optional<String> getLanguage() {
        return Optional.ofNullable(this.language);
    }

    public static Builder build() {
        return new Builder();
    }

    public static RequestOptions getRequestOptions(Bytecode bytecode) {
        Iterator itty = BytecodeHelper.findStrategies((Bytecode)bytecode, OptionsStrategy.class);
        Builder builder = RequestOptions.build();
        while (itty.hasNext()) {
            OptionsStrategy optionsStrategy = (OptionsStrategy)itty.next();
            Map options = optionsStrategy.getOptions();
            if (options.containsKey("evaluationTimeout")) {
                builder.timeout(((Number)options.get("evaluationTimeout")).longValue());
            }
            if (options.containsKey("requestId")) {
                builder.overrideRequestId((UUID)options.get("requestId"));
            }
            if (options.containsKey("batchSize")) {
                builder.batchSize(((Number)options.get("batchSize")).intValue());
            }
            if (!options.containsKey("userAgent")) continue;
            builder.userAgent((String)options.get("userAgent"));
        }
        return builder.create();
    }

    public static final class Builder {
        private Map<String, String> aliases = null;
        private Map<String, Object> parameters = null;
        private Integer batchSize = null;
        private Long timeout = null;
        private UUID overrideRequestId = null;
        private String userAgent = null;
        private String language = null;
        private boolean maintainStateAfterException = false;

        public Builder addAlias(String aliasName, String actualName) {
            if (null == this.aliases) {
                this.aliases = new HashMap<String, String>();
            }
            this.aliases.put(aliasName, actualName);
            return this;
        }

        public Builder addParameter(String name, Object value) {
            if (null == this.parameters) {
                this.parameters = new HashMap<String, Object>();
            }
            this.parameters.put(name, value);
            return this;
        }

        public Builder overrideRequestId(UUID overrideRequestId) {
            this.overrideRequestId = overrideRequestId;
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public RequestOptions create() {
            return new RequestOptions(this);
        }
    }
}

