/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.Configuration;
import org.apache.tinkerpop.gremlin.driver.Channelizer;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.GraphBinaryMessageSerializerV1;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

final class Settings {
    public int port = 8182;
    public String path = "/gremlin";
    public List<String> hosts = new ArrayList<String>();
    public SerializerSettings serializer = new SerializerSettings();
    public ConnectionPoolSettings connectionPool = new ConnectionPoolSettings();
    public int nioPoolSize = Runtime.getRuntime().availableProcessors();
    public int workerPoolSize = Runtime.getRuntime().availableProcessors() * 2;
    public String username = null;
    public String password = null;
    public String jaasEntry = null;
    public String protocol = null;
    public boolean enableUserAgentOnConnect = true;

    Settings() {
    }

    public static Settings read(InputStream stream) {
        Objects.requireNonNull(stream);
        Constructor constructor = new Constructor(Settings.class);
        TypeDescription settingsDescription = new TypeDescription(Settings.class);
        settingsDescription.putListPropertyType("hosts", String.class);
        settingsDescription.putListPropertyType("serializers", SerializerSettings.class);
        constructor.addTypeDescription(settingsDescription);
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        return (Settings)yaml.loadAs(stream, Settings.class);
    }

    public static Settings from(Configuration conf) {
        Configuration connectionPoolConf;
        Settings settings = new Settings();
        if (conf.containsKey("port")) {
            settings.port = conf.getInt("port");
        }
        if (conf.containsKey("nioPoolSize")) {
            settings.nioPoolSize = conf.getInt("nioPoolSize");
        }
        if (conf.containsKey("workerPoolSize")) {
            settings.workerPoolSize = conf.getInt("workerPoolSize");
        }
        if (conf.containsKey("username")) {
            settings.username = conf.getString("username");
        }
        if (conf.containsKey("password")) {
            settings.password = conf.getString("password");
        }
        if (conf.containsKey("jaasEntry")) {
            settings.jaasEntry = conf.getString("jaasEntry");
        }
        if (conf.containsKey("protocol")) {
            settings.protocol = conf.getString("protocol");
        }
        if (conf.containsKey("enableUserAgentOnConnect")) {
            settings.enableUserAgentOnConnect = conf.getBoolean("enableUserAgentOnConnect");
        }
        if (conf.containsKey("hosts")) {
            settings.hosts = conf.getList("hosts").stream().map(Object::toString).collect(Collectors.toList());
        }
        if (conf.containsKey("serializer.className")) {
            Configuration serializerConfigConf;
            SerializerSettings serializerSettings = new SerializerSettings();
            Configuration serializerConf = conf.subset("serializer");
            if (serializerConf.containsKey("className")) {
                serializerSettings.className = serializerConf.getString("className");
            }
            if (IteratorUtils.count((Iterator)(serializerConfigConf = conf.subset("serializer.config")).getKeys()) > 0L) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                serializerConfigConf.getKeys().forEachRemaining(name -> m.put((String)name, serializerConfigConf.getProperty(name)));
                serializerSettings.config = m;
            }
            settings.serializer = serializerSettings;
        }
        if (IteratorUtils.count((Iterator)(connectionPoolConf = conf.subset("connectionPool")).getKeys()) > 0L) {
            ConnectionPoolSettings cpSettings = new ConnectionPoolSettings();
            if (connectionPoolConf.containsKey("channelizer")) {
                cpSettings.channelizer = connectionPoolConf.getString("channelizer");
            }
            if (connectionPoolConf.containsKey("enableSsl")) {
                cpSettings.enableSsl = connectionPoolConf.getBoolean("enableSsl");
            }
            if (connectionPoolConf.containsKey("keyStore")) {
                cpSettings.keyStore = connectionPoolConf.getString("keyStore");
            }
            if (connectionPoolConf.containsKey("keyStorePassword")) {
                cpSettings.keyStorePassword = connectionPoolConf.getString("keyStorePassword");
            }
            if (connectionPoolConf.containsKey("keyStoreType")) {
                cpSettings.keyStoreType = connectionPoolConf.getString("keyStoreType");
            }
            if (connectionPoolConf.containsKey("trustStore")) {
                cpSettings.trustStore = connectionPoolConf.getString("trustStore");
            }
            if (connectionPoolConf.containsKey("trustStorePassword")) {
                cpSettings.trustStorePassword = connectionPoolConf.getString("trustStorePassword");
            }
            if (connectionPoolConf.containsKey("trustStoreType")) {
                cpSettings.trustStoreType = connectionPoolConf.getString("trustStoreType");
            }
            if (connectionPoolConf.containsKey("sslEnabledProtocols")) {
                cpSettings.sslEnabledProtocols = connectionPoolConf.getList("sslEnabledProtocols").stream().map(Object::toString).collect(Collectors.toList());
            }
            if (connectionPoolConf.containsKey("sslCipherSuites")) {
                cpSettings.sslCipherSuites = connectionPoolConf.getList("sslCipherSuites").stream().map(Object::toString).collect(Collectors.toList());
            }
            if (connectionPoolConf.containsKey("sslSkipCertValidation")) {
                cpSettings.sslSkipCertValidation = connectionPoolConf.getBoolean("sslSkipCertValidation");
            }
            if (connectionPoolConf.containsKey("minSize")) {
                cpSettings.minSize = connectionPoolConf.getInt("minSize");
            }
            if (connectionPoolConf.containsKey("maxSize")) {
                cpSettings.maxSize = connectionPoolConf.getInt("maxSize");
            }
            if (connectionPoolConf.containsKey("minSimultaneousUsagePerConnection")) {
                cpSettings.minSimultaneousUsagePerConnection = connectionPoolConf.getInt("minSimultaneousUsagePerConnection");
            }
            if (connectionPoolConf.containsKey("maxSimultaneousUsagePerConnection")) {
                cpSettings.maxSimultaneousUsagePerConnection = connectionPoolConf.getInt("maxSimultaneousUsagePerConnection");
            }
            if (connectionPoolConf.containsKey("maxInProcessPerConnection")) {
                cpSettings.maxInProcessPerConnection = connectionPoolConf.getInt("maxInProcessPerConnection");
            }
            if (connectionPoolConf.containsKey("minInProcessPerConnection")) {
                cpSettings.minInProcessPerConnection = connectionPoolConf.getInt("minInProcessPerConnection");
            }
            if (connectionPoolConf.containsKey("maxWaitForConnection")) {
                cpSettings.maxWaitForConnection = connectionPoolConf.getInt("maxWaitForConnection");
            }
            if (connectionPoolConf.containsKey("maxWaitForClose")) {
                cpSettings.maxWaitForClose = connectionPoolConf.getInt("maxWaitForClose");
            }
            if (connectionPoolConf.containsKey("maxContentLength")) {
                cpSettings.maxContentLength = connectionPoolConf.getInt("maxContentLength");
            }
            if (connectionPoolConf.containsKey("reconnectInterval")) {
                cpSettings.reconnectInterval = connectionPoolConf.getInt("reconnectInterval");
            }
            if (connectionPoolConf.containsKey("resultIterationBatchSize")) {
                cpSettings.resultIterationBatchSize = connectionPoolConf.getInt("resultIterationBatchSize");
            }
            if (connectionPoolConf.containsKey("keepAliveInterval")) {
                cpSettings.keepAliveInterval = connectionPoolConf.getLong("keepAliveInterval");
            }
            if (connectionPoolConf.containsKey("validationRequest")) {
                cpSettings.validationRequest = connectionPoolConf.getString("validationRequest");
            }
            if (connectionPoolConf.containsKey("connectionSetupTimeoutMillis")) {
                cpSettings.connectionSetupTimeoutMillis = connectionPoolConf.getLong("connectionSetupTimeoutMillis");
            }
            settings.connectionPool = cpSettings;
        }
        return settings;
    }

    public static class SerializerSettings {
        public String className = GraphBinaryMessageSerializerV1.class.getCanonicalName();
        public Map<String, Object> config = null;

        public MessageSerializer<?> create() throws Exception {
            Class<?> clazz = Class.forName(this.className);
            MessageSerializer serializer = (MessageSerializer)clazz.newInstance();
            Optional.ofNullable(this.config).ifPresent(c -> serializer.configure((Map<String, Object>)c, null));
            return serializer;
        }
    }

    static class ConnectionPoolSettings {
        public boolean enableSsl = false;
        public String keyStore;
        public String keyStorePassword;
        public String trustStore;
        public String trustStorePassword;
        public String keyStoreType;
        public String trustStoreType;
        public List<String> sslEnabledProtocols = new ArrayList<String>();
        public List<String> sslCipherSuites = new ArrayList<String>();
        public boolean sslSkipCertValidation = false;
        public int minSize = 2;
        public int maxSize = 8;
        public long keepAliveInterval = 180000L;
        public int minSimultaneousUsagePerConnection = 8;
        public int maxSimultaneousUsagePerConnection = 16;
        public int maxInProcessPerConnection = 4;
        public int minInProcessPerConnection = 1;
        public int maxWaitForConnection = 16000;
        public int maxWaitForClose = 3000;
        public int maxContentLength = 0xA00000;
        public int reconnectInterval = 1000;
        public int resultIterationBatchSize = 64;
        public String channelizer = Channelizer.WebSocketChannelizer.class.getName();
        public String validationRequest = "''";
        public long connectionSetupTimeoutMillis = 15000L;

        ConnectionPoolSettings() {
        }
    }
}

