/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.time.Period;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class PeriodSerializer
extends SimpleTypeSerializer<Period> {
    public PeriodSerializer() {
        super(DataType.PERIOD);
    }

    @Override
    Period readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        return Period.of(buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    @Override
    public ByteBuf writeValue(Period value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        return allocator.buffer(12).writeInt(value.getYears()).writeInt(value.getMonths()).writeInt(value.getDays());
    }
}

