/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class MapSerializer
extends SimpleTypeSerializer<Map> {
    public MapSerializer() {
        super(DataType.MAP);
    }

    @Override
    public Map readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        int length = buffer.readInt();
        LinkedHashMap result = new LinkedHashMap(length);
        for (int i = 0; i < length; ++i) {
            result.put(context.read(buffer), context.read(buffer));
        }
        return result;
    }

    @Override
    public ByteBuf writeValue(Map value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        CompositeByteBuf result = allocator.compositeBuffer(1 + value.size() * 2);
        result.addComponent(true, allocator.buffer(4).writeInt(value.size()));
        for (Object key : value.keySet()) {
            result.addComponents(true, new ByteBuf[]{context.write(key, allocator), context.write(value.get(key), allocator)});
        }
        return result;
    }
}

