/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.TypeSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.TypeSerializerRegistry;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.CustomTypeSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.TransformSerializer;

public class GraphBinaryWriter {
    private final TypeSerializerRegistry registry;
    private static final byte[] valueFlagNullBytes = new byte[]{1};
    private static final byte[] valueFlagNoneBytes = new byte[]{0};
    private static final byte[] unspecifiedNullBytes = new byte[]{DataType.UNSPECIFIED_NULL.getCodeByte(), 1};
    private static final byte[] customTypeCodeBytes = new byte[]{DataType.CUSTOM.getCodeByte()};

    public GraphBinaryWriter() {
        this(TypeSerializerRegistry.INSTANCE);
    }

    public GraphBinaryWriter(TypeSerializerRegistry registry) {
        this.registry = registry;
    }

    public <T> ByteBuf writeValue(T value, ByteBufAllocator allocator, boolean nullable) throws SerializationException {
        if (value == null) {
            if (!nullable) {
                throw new SerializationException("Unexpected null value when nullable is false");
            }
            return this.getValueFlagNull();
        }
        Class<?> objectClass = value.getClass();
        TypeSerializer<?> serializer = this.registry.getSerializer(objectClass);
        return serializer.writeValue(value, allocator, this, nullable);
    }

    public <T> ByteBuf write(T value, ByteBufAllocator allocator) throws SerializationException {
        if (value == null) {
            return Unpooled.wrappedBuffer((byte[])unspecifiedNullBytes);
        }
        Class<?> objectClass = value.getClass();
        TypeSerializer<?> serializer = this.registry.getSerializer(objectClass);
        if (serializer instanceof CustomTypeSerializer) {
            CustomTypeSerializer customTypeSerializer = (CustomTypeSerializer)serializer;
            return allocator.compositeBuffer(3).addComponents(true, new ByteBuf[]{Unpooled.wrappedBuffer((byte[])customTypeCodeBytes), this.writeValue(customTypeSerializer.getTypeName(), allocator, false), customTypeSerializer.write(value, allocator, this)});
        }
        if (serializer instanceof TransformSerializer) {
            TransformSerializer transformSerializer = (TransformSerializer)serializer;
            return this.write(transformSerializer.transform(value), allocator);
        }
        return allocator.compositeBuffer(2).addComponents(true, new ByteBuf[]{Unpooled.wrappedBuffer((byte[])serializer.getDataType().getDataTypeBuffer()), serializer.write(value, allocator, this)});
    }

    public <T> ByteBuf writeFullyQualifiedNull(Class<T> objectClass, ByteBufAllocator allocator, Object information) throws SerializationException {
        TypeSerializer<Object> serializer = this.registry.getSerializer(objectClass);
        return serializer.write(null, allocator, this);
    }

    public ByteBuf getValueFlagNull() {
        return Unpooled.wrappedBuffer((byte[])valueFlagNullBytes);
    }

    public ByteBuf getValueFlagNone() {
        return Unpooled.wrappedBuffer((byte[])valueFlagNoneBytes);
    }
}

