/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;

public abstract class AbstractMessageSerializer
implements MessageSerializer {
    public static final String TOKEN_IO_REGISTRIES = "ioRegistries";

    protected void addIoRegistries(Map<String, Object> config, Mapper.Builder builder) {
        List<String> classNameList = this.getListStringFromConfig(TOKEN_IO_REGISTRIES, config);
        classNameList.stream().forEach(className -> {
            try {
                Class<?> clazz = Class.forName(className);
                try {
                    Method instanceMethod = this.tryInstanceMethod(clazz);
                    if (!IoRegistry.class.isAssignableFrom(instanceMethod.getReturnType())) {
                        throw new Exception();
                    }
                    builder.addRegistry((IoRegistry)instanceMethod.invoke(null, new Object[0]));
                }
                catch (Exception methodex) {
                    builder.addRegistry((IoRegistry)clazz.newInstance());
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        });
    }

    protected Method tryInstanceMethod(Class clazz) {
        Method instanceMethod;
        try {
            instanceMethod = clazz.getDeclaredMethod("instance", new Class[0]);
        }
        catch (Exception methodex) {
            instanceMethod = null;
        }
        if (null == instanceMethod) {
            try {
                instanceMethod = clazz.getDeclaredMethod("getInstance", new Class[0]);
            }
            catch (Exception methodex) {
                instanceMethod = null;
            }
        }
        return instanceMethod;
    }

    protected List<String> getListStringFromConfig(String token, Map<String, Object> config) {
        List<String> classNameList;
        try {
            classNameList = config.getOrDefault(token, Collections.emptyList());
        }
        catch (Exception ex) {
            throw new IllegalStateException(String.format("Invalid configuration value of [%s] for [%s] setting on %s serialization configuration", config.getOrDefault(token, ""), token, this.getClass().getName()), ex);
        }
        return classNameList;
    }
}

