/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.locale;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import org.apache.tiles.request.locale.PostfixedApplicationResource;

public class URLApplicationResource
extends PostfixedApplicationResource {
    private URL url;
    private File file;

    public URLApplicationResource(String localePath, URL url) {
        super(localePath);
        this.url = url;
        if ("file".equals(url.getProtocol())) {
            this.file = new File(url.getPath());
        }
    }

    public URLApplicationResource(String path, Locale locale, URL url) throws MalformedURLException {
        super(path, locale);
        this.url = new URL(url, this.getLocalePath());
        if ("file".equals(url.getProtocol())) {
            this.file = new File(this.url.getPath());
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        return this.url.openConnection().getInputStream();
    }

    @Override
    public long getLastModified() throws IOException {
        if (this.file != null) {
            return this.file.lastModified();
        }
        URLConnection connection = this.url.openConnection();
        if (connection instanceof JarURLConnection) {
            return ((JarURLConnection)connection).getJarEntry().getTime();
        }
        long result = connection.getLastModified();
        return result;
    }

    public String toString() {
        return "Resource " + this.getLocalePath() + " at " + this.url.toString();
    }
}

