/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.CompareUtil;
import org.apache.tiles.ListAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicAttributeContext
implements AttributeContext,
Serializable {
    protected Attribute templateAttribute;
    protected String preparer = null;
    protected Map<String, Attribute> attributes = null;
    protected Map<String, Attribute> cascadedAttributes = null;

    public BasicAttributeContext() {
    }

    public BasicAttributeContext(Map<String, Attribute> attributes) {
        if (attributes != null) {
            this.attributes = this.deepCopyAttributeMap(attributes);
        }
    }

    public BasicAttributeContext(AttributeContext context) {
        if (context instanceof BasicAttributeContext) {
            this.copyBasicAttributeContext((BasicAttributeContext)context);
        } else {
            Attribute parentTemplateAttribute = context.getTemplateAttribute();
            if (parentTemplateAttribute != null) {
                this.templateAttribute = new Attribute(parentTemplateAttribute);
            }
            this.preparer = context.getPreparer();
            this.attributes = new HashMap<String, Attribute>();
            for (String name : context.getLocalAttributeNames()) {
                this.attributes.put(name, new Attribute(context.getLocalAttribute(name)));
            }
            this.inheritCascadedAttributes(context);
        }
    }

    public BasicAttributeContext(BasicAttributeContext context) {
        this.copyBasicAttributeContext(context);
    }

    @Override
    public Attribute getTemplateAttribute() {
        return this.templateAttribute;
    }

    @Override
    public void setTemplateAttribute(Attribute templateAttribute) {
        this.templateAttribute = templateAttribute;
    }

    @Override
    public String getPreparer() {
        return this.preparer;
    }

    @Override
    public void setPreparer(String url) {
        this.preparer = url;
    }

    @Override
    public void inheritCascadedAttributes(AttributeContext context) {
        if (context instanceof BasicAttributeContext) {
            this.copyCascadedAttributes((BasicAttributeContext)context);
        } else {
            this.cascadedAttributes = new HashMap<String, Attribute>();
            for (String name : context.getCascadedAttributeNames()) {
                this.cascadedAttributes.put(name, new Attribute(context.getCascadedAttribute(name)));
            }
        }
    }

    @Override
    public void inherit(AttributeContext parent) {
        if (parent instanceof BasicAttributeContext) {
            this.inherit((BasicAttributeContext)parent);
        } else {
            Attribute destAttribute;
            Attribute attribute;
            Set<String> names;
            Attribute parentTemplateAttribute = parent.getTemplateAttribute();
            this.inheritParentTemplateAttribute(parentTemplateAttribute);
            if (this.preparer == null) {
                this.preparer = parent.getPreparer();
            }
            if ((names = parent.getCascadedAttributeNames()) != null && !names.isEmpty()) {
                for (String name : names) {
                    attribute = parent.getCascadedAttribute(name);
                    destAttribute = this.getCascadedAttribute(name);
                    if (destAttribute == null) {
                        this.putAttribute(name, attribute, true);
                        continue;
                    }
                    if (!(attribute instanceof ListAttribute) || !(destAttribute instanceof ListAttribute) || !((ListAttribute)destAttribute).isInherit()) continue;
                    ((ListAttribute)destAttribute).inherit((ListAttribute)attribute);
                }
            }
            if ((names = parent.getLocalAttributeNames()) != null && !names.isEmpty()) {
                for (String name : names) {
                    attribute = parent.getLocalAttribute(name);
                    destAttribute = this.getLocalAttribute(name);
                    if (destAttribute == null) {
                        this.putAttribute(name, attribute, false);
                        continue;
                    }
                    if (!(attribute instanceof ListAttribute) || !(destAttribute instanceof ListAttribute) || !((ListAttribute)destAttribute).isInherit()) continue;
                    ((ListAttribute)destAttribute).inherit((ListAttribute)attribute);
                }
            }
        }
    }

    public void inherit(BasicAttributeContext parent) {
        this.inheritParentTemplateAttribute(parent.getTemplateAttribute());
        if (this.preparer == null) {
            this.preparer = parent.preparer;
        }
        this.cascadedAttributes = this.addMissingAttributes(parent.cascadedAttributes, this.cascadedAttributes);
        this.attributes = this.addMissingAttributes(parent.attributes, this.attributes);
    }

    @Override
    public void addAll(Map<String, Attribute> newAttributes) {
        if (newAttributes == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Attribute>(newAttributes);
            return;
        }
        this.attributes.putAll(newAttributes);
    }

    @Override
    public void addMissing(Map<String, Attribute> defaultAttributes) {
        if (defaultAttributes == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Attribute>(defaultAttributes);
            if (this.cascadedAttributes == null || this.cascadedAttributes.isEmpty()) {
                return;
            }
        }
        Set<Map.Entry<String, Attribute>> entries = defaultAttributes.entrySet();
        for (Map.Entry<String, Attribute> entry : entries) {
            String key = entry.getKey();
            if (this.attributes.containsKey(key) || this.cascadedAttributes != null && !this.cascadedAttributes.containsKey(key)) continue;
            this.attributes.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Attribute getAttribute(String name) {
        Attribute retValue = null;
        if (this.attributes != null) {
            retValue = this.attributes.get(name);
        }
        if (retValue == null && this.cascadedAttributes != null) {
            retValue = this.cascadedAttributes.get(name);
        }
        return retValue;
    }

    @Override
    public Attribute getLocalAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    @Override
    public Attribute getCascadedAttribute(String name) {
        if (this.cascadedAttributes == null) {
            return null;
        }
        return this.cascadedAttributes.get(name);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        HashSet<String> attributeSet = null;
        if (this.attributes != null && !this.attributes.isEmpty()) {
            attributeSet = new HashSet<String>(this.attributes.keySet());
            if (this.cascadedAttributes != null && !this.cascadedAttributes.isEmpty()) {
                attributeSet.addAll(this.cascadedAttributes.keySet());
            }
        } else if (this.cascadedAttributes != null && !this.cascadedAttributes.isEmpty()) {
            attributeSet = new HashSet<String>(this.cascadedAttributes.keySet());
        }
        if (attributeSet != null) {
            return attributeSet.iterator();
        }
        return new ArrayList().iterator();
    }

    @Override
    public Set<String> getLocalAttributeNames() {
        if (this.attributes != null && !this.attributes.isEmpty()) {
            return this.attributes.keySet();
        }
        return null;
    }

    @Override
    public Set<String> getCascadedAttributeNames() {
        if (this.cascadedAttributes != null && !this.cascadedAttributes.isEmpty()) {
            return this.cascadedAttributes.keySet();
        }
        return null;
    }

    @Override
    public void putAttribute(String name, Attribute value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Attribute>();
        }
        this.attributes.put(name, value);
    }

    @Override
    public void putAttribute(String name, Attribute value, boolean cascade) {
        Map<String, Attribute> mapToUse;
        if (cascade) {
            if (this.cascadedAttributes == null) {
                this.cascadedAttributes = new HashMap<String, Attribute>();
            }
            mapToUse = this.cascadedAttributes;
        } else {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Attribute>();
            }
            mapToUse = this.attributes;
        }
        mapToUse.put(name, value);
    }

    @Override
    public void clear() {
        this.templateAttribute = null;
        this.preparer = null;
        this.attributes.clear();
        this.cascadedAttributes.clear();
    }

    public boolean equals(Object obj) {
        BasicAttributeContext bac = (BasicAttributeContext)obj;
        return CompareUtil.nullSafeEquals(this.templateAttribute, bac.templateAttribute) && CompareUtil.nullSafeEquals(this.preparer, bac.preparer) && CompareUtil.nullSafeEquals(this.attributes, bac.attributes) && CompareUtil.nullSafeEquals(this.cascadedAttributes, bac.cascadedAttributes);
    }

    public int hashCode() {
        return CompareUtil.nullSafeHashCode(this.templateAttribute) + CompareUtil.nullSafeHashCode(this.preparer) + CompareUtil.nullSafeHashCode(this.attributes) + CompareUtil.nullSafeHashCode(this.cascadedAttributes);
    }

    private void inheritParentTemplateAttribute(Attribute parentTemplateAttribute) {
        if (parentTemplateAttribute != null) {
            if (this.templateAttribute == null) {
                this.templateAttribute = new Attribute(parentTemplateAttribute);
            } else {
                this.templateAttribute.inherit(parentTemplateAttribute);
            }
        }
    }

    private void copyBasicAttributeContext(BasicAttributeContext context) {
        Attribute parentTemplateAttribute = context.getTemplateAttribute();
        if (parentTemplateAttribute != null) {
            this.templateAttribute = new Attribute(parentTemplateAttribute);
        }
        this.preparer = context.preparer;
        if (context.attributes != null && !context.attributes.isEmpty()) {
            this.attributes = this.deepCopyAttributeMap(context.attributes);
        }
        this.copyCascadedAttributes(context);
    }

    private void copyCascadedAttributes(BasicAttributeContext context) {
        if (context.cascadedAttributes != null && !context.cascadedAttributes.isEmpty()) {
            this.cascadedAttributes = this.deepCopyAttributeMap(context.cascadedAttributes);
        }
    }

    private Map<String, Attribute> addMissingAttributes(Map<String, Attribute> source, Map<String, Attribute> destination) {
        if (source != null && !source.isEmpty()) {
            if (destination == null) {
                destination = new HashMap<String, Attribute>();
            }
            for (Map.Entry<String, Attribute> entry : source.entrySet()) {
                String key = entry.getKey();
                Attribute destAttribute = destination.get(key);
                if (destAttribute == null) {
                    destination.put(key, entry.getValue());
                    continue;
                }
                if (!(destAttribute instanceof ListAttribute) || !(entry.getValue() instanceof ListAttribute) || !((ListAttribute)destAttribute).isInherit()) continue;
                ((ListAttribute)destAttribute).inherit((ListAttribute)entry.getValue());
            }
        }
        return destination;
    }

    private Map<String, Attribute> deepCopyAttributeMap(Map<String, Attribute> attributes) {
        HashMap<String, Attribute> retValue = new HashMap<String, Attribute>(attributes.size());
        for (Map.Entry<String, Attribute> entry : attributes.entrySet()) {
            Attribute toCopy = entry.getValue();
            if (toCopy == null) continue;
            retValue.put(entry.getKey(), toCopy.clone());
        }
        return retValue;
    }
}

