/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.access;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.TilesException;
import org.apache.tiles.reflect.ClassUtil;

public final class TilesAccess {
    private static final Log LOG = LogFactory.getLog(TilesAccess.class);
    public static final String CONTAINER_ATTRIBUTE = "org.apache.tiles.CONTAINER";
    private static final String CONTEXT_ATTRIBUTE = "org.apache.tiles.APPLICATION_CONTEXT";

    private TilesAccess() {
    }

    public static TilesContainer getContainer(Object context) {
        return (TilesContainer)TilesAccess.getAttribute(context, CONTAINER_ATTRIBUTE);
    }

    public static void setContainer(Object context, TilesContainer container) throws TilesException {
        if (container == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Removing TilesContext for context: " + context.getClass().getName()));
            }
            TilesAccess.removeAttribute(context, CONTAINER_ATTRIBUTE);
        }
        if (container != null && LOG.isInfoEnabled()) {
            LOG.info((Object)("Publishing TilesContext for context: " + context.getClass().getName()));
        }
        TilesAccess.setAttribute(context, CONTAINER_ATTRIBUTE, container);
    }

    public static TilesApplicationContext getApplicationContext(Object context) {
        TilesContainer container = TilesAccess.getContainer(context);
        if (container != null) {
            return container.getApplicationContext();
        }
        return (TilesApplicationContext)TilesAccess.getAttribute(context, CONTEXT_ATTRIBUTE);
    }

    private static Object getAttribute(Object context, String attributeName) {
        try {
            Class<?> contextClass = context.getClass();
            Method attrMethod = ClassUtil.getForcedAccessibleMethod(contextClass, "getAttribute", String.class);
            return ClassUtil.invokeMethod(context, attrMethod, attributeName);
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to retrieve container from specified context: '" + context + "'"), (Throwable)e);
            return null;
        }
    }

    private static void setAttribute(Object context, String name, Object value) throws TilesException {
        Class<?> contextClass = context.getClass();
        Method attrMethod = ClassUtil.getForcedAccessibleMethod(contextClass, "setAttribute", String.class, Object.class);
        ClassUtil.invokeMethod(context, attrMethod, name, value);
    }

    private static void removeAttribute(Object context, String name) throws TilesException {
        Class<?> contextClass = context.getClass();
        Method attrMethod = ClassUtil.getForcedAccessibleMethod(contextClass, "removeAttribute", String.class);
        ClassUtil.invokeMethod(context, attrMethod, name);
    }
}

