/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.chunker;

import java.io.IOException;
import java.util.LinkedList;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkerCrossValidator;
import opennlp.tools.chunker.ChunkerEvaluationMonitor;
import opennlp.tools.chunker.ChunkerFactory;
import opennlp.tools.cmdline.AbstractCrossValidatorTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.chunker.ChunkEvaluationErrorListener;
import opennlp.tools.cmdline.chunker.ChunkerDetailedFMeasureListener;
import opennlp.tools.cmdline.chunker.TrainingParams;
import opennlp.tools.cmdline.params.CVParams;
import opennlp.tools.cmdline.params.DetailedFMeasureEvaluatorParams;
import opennlp.tools.util.eval.FMeasure;
import opennlp.tools.util.model.ModelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChunkerCrossValidatorTool
extends AbstractCrossValidatorTool<ChunkSample, CVToolParams> {
    private static final Logger logger = LoggerFactory.getLogger(ChunkerCrossValidatorTool.class);

    public ChunkerCrossValidatorTool() {
        super(ChunkSample.class, CVToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "K-fold cross validator for the chunker";
    }

    @Override
    public void run(String format, String[] args) {
        ChunkerCrossValidator validator;
        super.run(format, args);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((CVToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createDefaultTrainingParameters();
        }
        LinkedList<ChunkerEvaluationMonitor> listeners = new LinkedList<ChunkerEvaluationMonitor>();
        ChunkerDetailedFMeasureListener detailedFMeasureListener = null;
        if (((CVToolParams)this.params).getMisclassified().booleanValue()) {
            listeners.add(new ChunkEvaluationErrorListener());
        }
        if (((CVToolParams)this.params).getDetailedF().booleanValue()) {
            detailedFMeasureListener = new ChunkerDetailedFMeasureListener();
            listeners.add(detailedFMeasureListener);
        }
        try {
            ChunkerFactory chunkerFactory = ChunkerFactory.create(((CVToolParams)this.params).getFactory());
            validator = new ChunkerCrossValidator(((CVToolParams)this.params).getLang(), this.mlParams, chunkerFactory, listeners.toArray(new ChunkerEvaluationMonitor[0]));
            validator.evaluate(this.sampleStream, ((CVToolParams)this.params).getFolds());
        }
        catch (IOException e) {
            throw this.createTerminationIOException(e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        if (detailedFMeasureListener == null) {
            FMeasure result = validator.getFMeasure();
            logger.info(result.toString());
        } else {
            logger.info(detailedFMeasureListener.toString());
        }
    }

    static interface CVToolParams
    extends TrainingParams,
    CVParams,
    DetailedFMeasureEvaluatorParams {
    }
}

