/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.core.textstats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.util.BytesRef;
import org.apache.tika.eval.core.langid.LanguageIDWrapper;
import org.apache.tika.eval.core.textstats.BytesRefCalculator;
import org.apache.tika.eval.core.textstats.LanguageAwareTokenCountStats;
import org.apache.tika.eval.core.textstats.StringStatsCalculator;
import org.apache.tika.eval.core.textstats.TextStatsCalculator;
import org.apache.tika.eval.core.textstats.TokenCountStatsCalculator;
import org.apache.tika.eval.core.tokens.AnalyzerManager;
import org.apache.tika.eval.core.tokens.TokenCounts;
import org.apache.tika.language.detect.LanguageResult;

public class CompositeTextStatsCalculator {
    private static final String FIELD = "f";
    private static final int DEFAULT_MAX_TOKENS = 10000000;
    private final byte[] whitespace = new byte[]{32};
    private final Analyzer analyzer;
    private final LanguageIDWrapper languageIDWrapper;
    private final List<LanguageAwareTokenCountStats> languageAwareTokenCountStats = new ArrayList<LanguageAwareTokenCountStats>();
    private final List<TokenCountStatsCalculator> tokenCountStatCalculators = new ArrayList<TokenCountStatsCalculator>();
    private final List<StringStatsCalculator> stringStatCalculators = new ArrayList<StringStatsCalculator>();
    private final List<BytesRefCalculator> bytesRefCalculators = new ArrayList<BytesRefCalculator>();

    public CompositeTextStatsCalculator(List<TextStatsCalculator> calculators) {
        this(calculators, AnalyzerManager.newInstance(10000000).getGeneralAnalyzer(), new LanguageIDWrapper());
    }

    public CompositeTextStatsCalculator(List<TextStatsCalculator> calculators, Analyzer analyzer, LanguageIDWrapper languageIDWrapper) {
        this.analyzer = analyzer;
        this.languageIDWrapper = languageIDWrapper;
        for (TextStatsCalculator t : calculators) {
            if (t instanceof StringStatsCalculator) {
                this.stringStatCalculators.add((StringStatsCalculator)t);
                continue;
            }
            if (t instanceof LanguageAwareTokenCountStats) {
                this.languageAwareTokenCountStats.add((LanguageAwareTokenCountStats)t);
                if (languageIDWrapper != null) continue;
                throw new IllegalArgumentException("Must specify a LanguageIdWrapper if you want to calculate languageAware stats: " + t.getClass());
            }
            if (t instanceof TokenCountStatsCalculator) {
                this.tokenCountStatCalculators.add((TokenCountStatsCalculator)t);
                if (analyzer != null) continue;
                throw new IllegalArgumentException("Analyzer must not be null if you are using a TokenCountStats: " + t.getClass());
            }
            if (t instanceof BytesRefCalculator) {
                this.bytesRefCalculators.add((BytesRefCalculator)t);
                if (analyzer != null) continue;
                throw new IllegalArgumentException("Analyzer must not be null if you are using a BytesRefCalculator: " + t.getClass());
            }
            throw new IllegalArgumentException("I regret I don't yet handle: " + t.getClass());
        }
    }

    public Map<Class, Object> calculate(String txt) {
        HashMap<Class, Object> results = new HashMap<Class, Object>();
        for (StringStatsCalculator calc : this.stringStatCalculators) {
            results.put(calc.getClass(), calc.calculate(txt));
        }
        TokenCounts tokenCounts = null;
        if (this.tokenCountStatCalculators.size() > 0 || this.languageAwareTokenCountStats.size() > 0 || this.bytesRefCalculators.size() > 0) {
            try {
                tokenCounts = this.tokenize(txt, results);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.languageAwareTokenCountStats.size() > 0) {
            Object langs = results.containsKey(LanguageIDWrapper.class) ? (List)results.get(LanguageIDWrapper.class) : this.languageIDWrapper.calculate(txt);
            results.put(LanguageIDWrapper.class, langs);
            for (LanguageAwareTokenCountStats calc : this.languageAwareTokenCountStats) {
                results.put(calc.getClass(), calc.calculate((List<LanguageResult>)langs, tokenCounts));
            }
        }
        for (TokenCountStatsCalculator calc : this.tokenCountStatCalculators) {
            results.put(calc.getClass(), calc.calculate(tokenCounts));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TokenCounts tokenize(String txt, Map<Class, Object> results) throws IOException {
        TokenCounts counts = new TokenCounts();
        TokenStream ts = this.analyzer.tokenStream(FIELD, txt);
        if (this.bytesRefCalculators.size() == 0) {
            try {
                CharTermAttribute termAtt = ts.getAttribute(CharTermAttribute.class);
                ts.reset();
                while (ts.incrementToken()) {
                    String token = termAtt.toString();
                    counts.increment(token);
                }
            }
            finally {
                ts.close();
                ts.end();
            }
        }
        ArrayList brcis = new ArrayList();
        for (BytesRefCalculator brf : this.bytesRefCalculators) {
            brcis.add(brf.getInstance());
        }
        try {
            TermToBytesRefAttribute termAtt = ts.getAttribute(TermToBytesRefAttribute.class);
            ts.reset();
            int i = 0;
            while (ts.incrementToken()) {
                BytesRef bytesRef = termAtt.getBytesRef();
                String string = termAtt.toString();
                counts.increment(string);
                for (BytesRefCalculator.BytesRefCalcInstance bytesRefCalcInstance : brcis) {
                    if (i > 0) {
                        bytesRefCalcInstance.update(this.whitespace, 0, 1);
                    }
                    bytesRefCalcInstance.update(bytesRef.bytes, bytesRef.offset, bytesRef.length);
                }
                ++i;
            }
            for (BytesRefCalculator.BytesRefCalcInstance bytesRefCalcInstance : brcis) {
                results.put(bytesRefCalcInstance.getOuterClass(), bytesRefCalcInstance.finish());
            }
        }
        finally {
            ts.close();
            ts.end();
        }
        return counts;
    }
}

