/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.eval;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.tika.eval.core.langid.LanguageIDWrapper;
import org.apache.tika.eval.core.metadata.TikaEvalMetadataFilter;
import org.apache.tika.eval.core.textstats.BasicTokenCountStatsCalculator;
import org.apache.tika.eval.core.textstats.CommonTokens;
import org.apache.tika.eval.core.textstats.CompositeTextStatsCalculator;
import org.apache.tika.eval.core.textstats.TextStatsCalculator;
import org.apache.tika.eval.core.tokens.CommonTokenResult;
import org.apache.tika.eval.core.tokens.ContrastStatistics;
import org.apache.tika.eval.core.tokens.TokenContraster;
import org.apache.tika.eval.core.tokens.TokenCounts;
import org.apache.tika.language.detect.LanguageResult;
import org.apache.tika.metadata.Property;
import org.apache.tika.server.core.ServerStatus;
import org.apache.tika.server.core.ServerStatusResource;
import org.apache.tika.server.core.resource.TikaServerResource;

@Path(value="/eval")
public class TikaEvalResource
implements TikaServerResource,
ServerStatusResource {
    public static final String TEXT = "text";
    public static final String TEXT_A = "textA";
    public static final String TEXT_B = "textB";
    public static final String ID = "id";
    public static final Property DICE = Property.externalReal(TikaEvalMetadataFilter.TIKA_EVAL_NS + "dice");
    public static final Property OVERLAP = Property.externalReal(TikaEvalMetadataFilter.TIKA_EVAL_NS + "overlap");
    private ServerStatus serverStatus;
    public static final long DEFAULT_TIMEOUT_MILLIS = 60000L;
    static CompositeTextStatsCalculator TEXT_STATS_CALCULATOR;

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="compare")
    public Map<String, Object> compare(InputStream is) throws Exception {
        JsonNode node = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            node = new ObjectMapper().readTree(reader);
        }
        String id = node.get(ID).asText();
        String textA = node.get(TEXT_A).asText();
        String textB = node.get(TEXT_B).asText();
        long timeoutMillis = node.has("timeoutMillis") ? node.get("timeoutMillis").asLong() : 60000L;
        return this.compareText(id, textA, textB, timeoutMillis);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="profile")
    public Map<String, Object> profile(InputStream is) throws Exception {
        JsonNode node = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            node = new ObjectMapper().readTree(reader);
        }
        String id = node.get(ID).asText();
        String text = node.get(TEXT).asText();
        long timeoutMillis = node.has("timeoutMillis") ? node.get("timeoutMillis").asLong() : 60000L;
        return this.profile(id, text, timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> profile(String id, String text, long timeoutMillis) {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        long taskId = this.serverStatus.start(ServerStatus.TASK.PARSE, id, timeoutMillis);
        try {
            this.profile("", text, stats);
        }
        finally {
            this.serverStatus.complete(taskId);
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> compareText(String id, String textA, String textB, long timeoutMillis) {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        long taskId = this.serverStatus.start(ServerStatus.TASK.PARSE, id, timeoutMillis);
        try {
            TokenCounts tokensA = this.profile("A", textA, stats);
            TokenCounts tokensB = this.profile("B", textB, stats);
            TokenContraster tokenContraster = new TokenContraster();
            ContrastStatistics contrastStatistics = tokenContraster.calculateContrastStatistics(tokensA, tokensB);
            this.reportContrastStats(contrastStatistics, stats);
        }
        finally {
            this.serverStatus.complete(taskId);
        }
        return stats;
    }

    private void reportContrastStats(ContrastStatistics contrastStatistics, Map<String, Object> stats) {
        stats.put(DICE.getName(), contrastStatistics.getDiceCoefficient());
        stats.put(OVERLAP.getName(), contrastStatistics.getOverlap());
    }

    private TokenCounts profile(String suffix, String content, Map<String, Object> stats) {
        Map<Class, Object> results = TEXT_STATS_CALCULATOR.calculate(content);
        TokenCounts tokenCounts = (TokenCounts)results.get(BasicTokenCountStatsCalculator.class);
        stats.put(TikaEvalMetadataFilter.NUM_TOKENS.getName() + suffix, tokenCounts.getTotalTokens());
        stats.put(TikaEvalMetadataFilter.NUM_UNIQUE_TOKENS.getName() + suffix, tokenCounts.getTotalUniqueTokens());
        CommonTokenResult commonTokenResult = (CommonTokenResult)results.get(CommonTokens.class);
        stats.put(TikaEvalMetadataFilter.NUM_ALPHA_TOKENS.getName() + suffix, commonTokenResult.getAlphabeticTokens());
        stats.put(TikaEvalMetadataFilter.NUM_UNIQUE_ALPHA_TOKENS.getName() + suffix, commonTokenResult.getUniqueAlphabeticTokens());
        if (commonTokenResult.getAlphabeticTokens() > 0) {
            stats.put(TikaEvalMetadataFilter.OUT_OF_VOCABULARY.getName() + suffix, commonTokenResult.getOOV());
        } else {
            stats.put(TikaEvalMetadataFilter.OUT_OF_VOCABULARY.getName() + suffix, Float.valueOf(-1.0f));
        }
        List probabilities = (List)results.get(LanguageIDWrapper.class);
        if (probabilities.size() > 0) {
            stats.put(TikaEvalMetadataFilter.LANGUAGE.getName() + suffix, ((LanguageResult)probabilities.get(0)).getLanguage());
            stats.put(TikaEvalMetadataFilter.LANGUAGE_CONFIDENCE.getName() + suffix, Float.valueOf(((LanguageResult)probabilities.get(0)).getRawScore()));
        }
        return tokenCounts;
    }

    public void setServerStatus(ServerStatus serverStatus) {
        this.serverStatus = serverStatus;
    }

    static {
        ArrayList<TextStatsCalculator> calcs = new ArrayList<TextStatsCalculator>();
        calcs.add(new BasicTokenCountStatsCalculator());
        calcs.add(new CommonTokens());
        TEXT_STATS_CALCULATOR = new CompositeTextStatsCalculator(calcs);
    }
}

