/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.grib;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;

public class GribParser
implements Parser {
    public static final String GRIB_MIME_TYPE = "application/x-grib2";
    private static final long serialVersionUID = 7855458954474247655L;
    private final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"x-grib2"));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return this.SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        metadata.set("Content-Type", GRIB_MIME_TYPE);
        Path tmpDir = Files.createTempDirectory("tika-grib-", new FileAttribute[0]);
        try {
            XHTMLContentHandler xhtml;
            Path gribFile = Files.createTempFile(tmpDir, "tika-file", ".grib2", new FileAttribute[0]);
            Files.copy(stream, gribFile, StandardCopyOption.REPLACE_EXISTING);
            try (NetcdfFile ncFile = NetcdfDataset.openFile((String)gribFile.toString(), null);){
                for (Attribute attr : ncFile.getGlobalAttributes()) {
                    Property property = this.resolveMetadataKey(attr.getFullName());
                    if (attr.getDataType().isString()) {
                        metadata.add(property, attr.getStringValue());
                        continue;
                    }
                    if (!attr.getDataType().isNumeric()) continue;
                    int value = attr.getNumericValue().intValue();
                    metadata.add(property, String.valueOf(value));
                }
                xhtml = new XHTMLContentHandler(handler, metadata);
                xhtml.startDocument();
                xhtml.newline();
                xhtml.startElement("ul");
                xhtml.characters("dimensions:");
                xhtml.newline();
                for (Dimension dim : ncFile.getDimensions()) {
                    xhtml.element("li", dim.getFullName() + "=" + String.valueOf(dim.getLength()) + ";");
                    xhtml.newline();
                }
                xhtml.startElement("ul");
                xhtml.characters("variables:");
                xhtml.newline();
                for (Variable var : ncFile.getVariables()) {
                    xhtml.element("p", String.valueOf(var.getDataType()) + var.getNameAndDimensions() + ";");
                    for (Attribute element : var.getAttributes()) {
                        xhtml.element("li", " :" + element + ";");
                        xhtml.newline();
                    }
                }
            }
            xhtml.endElement("ul");
            xhtml.endElement("ul");
            xhtml.endDocument();
        }
        catch (IOException e) {
            throw new TikaException("NetCDF parse error", (Throwable)e);
        }
        finally {
            FileUtils.deleteDirectory((File)tmpDir.toFile());
        }
    }

    private Property resolveMetadataKey(String localName) {
        if ("title".equals(localName)) {
            return TikaCoreProperties.TITLE;
        }
        return Property.internalText((String)localName);
    }
}

