/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.ner.regex;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.tika.parser.ner.NERecogniser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexNERecogniser
implements NERecogniser {
    public static final String NER_REGEX_FILE = "ner-regex.txt";
    private static Logger LOG = LoggerFactory.getLogger(RegexNERecogniser.class);
    private static RegexNERecogniser INSTANCE;
    public Set<String> entityTypes = new HashSet<String>();
    public Map<String, Pattern> patterns;
    private boolean available = false;

    public RegexNERecogniser() {
        this(RegexNERecogniser.class.getResourceAsStream(NER_REGEX_FILE));
    }

    public RegexNERecogniser(InputStream stream) {
        try {
            this.patterns = new HashMap<String, Pattern>();
            List lines = IOUtils.readLines((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            IOUtils.closeQuietly((InputStream)stream);
            for (String line : lines) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                int delim = line.indexOf(61);
                if (delim < 0) {
                    LOG.error("Skipped : Invalid config : {} ", (Object)line);
                    continue;
                }
                String type = line.substring(0, delim).trim();
                String patternStr = line.substring(delim + 1).trim();
                this.patterns.put(type, Pattern.compile(patternStr));
                this.entityTypes.add(type);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        this.available = !this.entityTypes.isEmpty();
    }

    public static synchronized RegexNERecogniser getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RegexNERecogniser();
        }
        return INSTANCE;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public Set<String> getEntityTypes() {
        return this.entityTypes;
    }

    public Set<String> findMatches(String text, Pattern pattern) {
        HashSet<String> results = null;
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            results = new HashSet<String>();
            results.add(matcher.group(0));
            while (matcher.find()) {
                results.add(matcher.group(0));
            }
        }
        return results;
    }

    @Override
    public Map<String, Set<String>> recognise(String text) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Pattern> entry : this.patterns.entrySet()) {
            Set<String> names = this.findMatches(text, entry.getValue());
            if (names == null) continue;
            result.put(entry.getKey(), names);
        }
        return result;
    }
}

