/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.libpst;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.PST;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class EmailVisitor
implements FileVisitor<Path> {
    private final Path root;
    private final boolean processEmailAsMsg;
    private final XHTMLContentHandler xhtml;
    private final Metadata parentMetadata;
    private final EmbeddedDocumentExtractor embeddedDocumentExtractor;

    public EmailVisitor(Path root, boolean processEmailAsMsg, XHTMLContentHandler xhtml, Metadata parentMetadata, ParseContext parseContext) {
        this.root = root;
        this.processEmailAsMsg = processEmailAsMsg;
        this.xhtml = xhtml;
        this.parentMetadata = parentMetadata;
        this.embeddedDocumentExtractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor((ParseContext)parseContext);
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.processEmailAsMsg) {
            if (file.getFileName().toString().endsWith(".msg")) {
                this.process(file);
            }
        } else if (file.getFileName().toString().endsWith(".eml")) {
            this.process(file);
        }
        return FileVisitResult.CONTINUE;
    }

    private void process(Path file) throws IOException {
        Metadata emailMetadata = new Metadata();
        String pstPath = this.root.relativize(file.getParent()).toString();
        emailMetadata.set(PST.PST_FOLDER_PATH, pstPath);
        try (TikaInputStream is = TikaInputStream.get((Path)file);){
            try {
                this.embeddedDocumentExtractor.parseEmbedded((InputStream)is, (ContentHandler)this.xhtml, emailMetadata, true);
            }
            catch (SAXException e) {
                throw new IOExceptionWithCause((Throwable)e);
            }
        }
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }
}

