/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.apache.tika.sax.ToXMLContentHandler;
import org.apache.tika.sax.xpath.Matcher;
import org.apache.tika.sax.xpath.MatchingContentHandler;
import org.apache.tika.sax.xpath.XPathParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ContentHandlerExample {
    protected final int MAXIMUM_TEXT_CHUNK_SIZE = 40;

    public String parseToPlainText() throws IOException, SAXException, TikaException {
        BodyContentHandler handler = new BodyContentHandler();
        AutoDetectParser parser = new AutoDetectParser();
        Metadata metadata = new Metadata();
        try (InputStream stream = ContentHandlerExample.class.getResourceAsStream("test.doc");){
            parser.parse(stream, (ContentHandler)handler, metadata);
            String string = handler.toString();
            return string;
        }
    }

    public String parseToHTML() throws IOException, SAXException, TikaException {
        ToXMLContentHandler handler = new ToXMLContentHandler();
        AutoDetectParser parser = new AutoDetectParser();
        Metadata metadata = new Metadata();
        try (InputStream stream = ContentHandlerExample.class.getResourceAsStream("test.doc");){
            parser.parse(stream, (ContentHandler)handler, metadata);
            String string = handler.toString();
            return string;
        }
    }

    public String parseBodyToHTML() throws IOException, SAXException, TikaException {
        BodyContentHandler handler = new BodyContentHandler((ContentHandler)new ToXMLContentHandler());
        AutoDetectParser parser = new AutoDetectParser();
        Metadata metadata = new Metadata();
        try (InputStream stream = ContentHandlerExample.class.getResourceAsStream("test.doc");){
            parser.parse(stream, (ContentHandler)handler, metadata);
            String string = handler.toString();
            return string;
        }
    }

    public String parseOnePartToHTML() throws IOException, SAXException, TikaException {
        XPathParser xhtmlParser = new XPathParser("xhtml", "http://www.w3.org/1999/xhtml");
        Matcher divContentMatcher = xhtmlParser.parse("/xhtml:html/xhtml:body/xhtml:div/descendant::node()");
        MatchingContentHandler handler = new MatchingContentHandler((ContentHandler)new ToXMLContentHandler(), divContentMatcher);
        AutoDetectParser parser = new AutoDetectParser();
        Metadata metadata = new Metadata();
        try (InputStream stream = ContentHandlerExample.class.getResourceAsStream("test2.doc");){
            parser.parse(stream, (ContentHandler)handler, metadata);
            String string = handler.toString();
            return string;
        }
    }

    public List<String> parseToPlainTextChunks() throws IOException, SAXException, TikaException {
        final ArrayList<String> chunks = new ArrayList<String>();
        chunks.add("");
        ContentHandlerDecorator handler = new ContentHandlerDecorator(){

            public void characters(char[] ch, int start, int length) {
                String lastChunk = (String)chunks.get(chunks.size() - 1);
                String thisStr = new String(ch, start, length);
                if (lastChunk.length() + length > 40) {
                    chunks.add(thisStr);
                } else {
                    chunks.set(chunks.size() - 1, lastChunk + thisStr);
                }
            }
        };
        AutoDetectParser parser = new AutoDetectParser();
        Metadata metadata = new Metadata();
        try (InputStream stream = ContentHandlerExample.class.getResourceAsStream("test2.doc");){
            parser.parse(stream, (ContentHandler)handler, metadata);
            ArrayList<String> arrayList = chunks;
            return arrayList;
        }
    }
}

