/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.sort.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumFileSystem;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.util.PriorityQueue;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.util.Progressable;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.common.sort.impl.TezRawKeyValueIterator;
import org.apache.tez.runtime.library.utils.BufferUtils;
import org.apache.tez.runtime.library.utils.LocalProgress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TezMerger {
    private static final Logger LOG = LoggerFactory.getLogger(TezMerger.class);
    private static LocalDirAllocator lDirAlloc = new LocalDirAllocator("tez.runtime.framework.local.dirs");

    public static TezRawKeyValueIterator merge(Configuration conf, FileSystem fs, Class keyClass, Class valueClass, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLength, int ifileBufferSize, Path[] inputs, boolean deleteInputs, int mergeFactor, Path tmpDir, RawComparator comparator, Progressable reporter, TezCounter readsCounter, TezCounter writesCounter, TezCounter bytesReadCounter, Progress mergePhase) throws IOException, InterruptedException {
        return new MergeQueue(conf, fs, inputs, deleteInputs, codec, ifileReadAhead, ifileReadAheadLength, ifileBufferSize, false, comparator, reporter, null).merge(keyClass, valueClass, mergeFactor, tmpDir, readsCounter, writesCounter, bytesReadCounter, mergePhase);
    }

    public static TezRawKeyValueIterator merge(Configuration conf, FileSystem fs, Class keyClass, Class valueClass, List<Segment> segments, int mergeFactor, Path tmpDir, RawComparator comparator, Progressable reporter, TezCounter readsCounter, TezCounter writesCounter, TezCounter bytesReadCounter, Progress mergePhase) throws IOException, InterruptedException {
        return TezMerger.merge(conf, fs, keyClass, valueClass, segments, mergeFactor, tmpDir, comparator, reporter, false, readsCounter, writesCounter, bytesReadCounter, mergePhase);
    }

    public static <K, V> TezRawKeyValueIterator merge(Configuration conf, FileSystem fs, Class keyClass, Class valueClass, List<Segment> segments, int mergeFactor, Path tmpDir, RawComparator comparator, Progressable reporter, boolean sortSegments, TezCounter readsCounter, TezCounter writesCounter, TezCounter bytesReadCounter, Progress mergePhase) throws IOException, InterruptedException {
        return new MergeQueue(conf, fs, segments, comparator, reporter, sortSegments, false).merge(keyClass, valueClass, mergeFactor, tmpDir, readsCounter, writesCounter, bytesReadCounter, mergePhase);
    }

    public static <K, V> TezRawKeyValueIterator merge(Configuration conf, FileSystem fs, Class keyClass, Class valueClass, CompressionCodec codec, List<Segment> segments, int mergeFactor, Path tmpDir, RawComparator comparator, Progressable reporter, boolean sortSegments, boolean considerFinalMergeForProgress, TezCounter readsCounter, TezCounter writesCounter, TezCounter bytesReadCounter, Progress mergePhase, boolean checkForSameKeys) throws IOException, InterruptedException {
        return new MergeQueue(conf, fs, segments, comparator, reporter, sortSegments, codec, considerFinalMergeForProgress, checkForSameKeys).merge(keyClass, valueClass, mergeFactor, tmpDir, readsCounter, writesCounter, bytesReadCounter, mergePhase);
    }

    public static <K, V> TezRawKeyValueIterator merge(Configuration conf, FileSystem fs, Class keyClass, Class valueClass, CompressionCodec codec, List<Segment> segments, int mergeFactor, Path tmpDir, RawComparator comparator, Progressable reporter, boolean sortSegments, boolean considerFinalMergeForProgress, TezCounter readsCounter, TezCounter writesCounter, TezCounter bytesReadCounter, Progress mergePhase) throws IOException, InterruptedException {
        return new MergeQueue(conf, fs, segments, comparator, reporter, sortSegments, codec, considerFinalMergeForProgress).merge(keyClass, valueClass, mergeFactor, tmpDir, readsCounter, writesCounter, bytesReadCounter, mergePhase);
    }

    public static <K, V> TezRawKeyValueIterator merge(Configuration conf, FileSystem fs, Class keyClass, Class valueClass, CompressionCodec codec, List<Segment> segments, int mergeFactor, int inMemSegments, Path tmpDir, RawComparator comparator, Progressable reporter, boolean sortSegments, TezCounter readsCounter, TezCounter writesCounter, TezCounter bytesReadCounter, Progress mergePhase) throws IOException, InterruptedException {
        return new MergeQueue(conf, fs, segments, comparator, reporter, sortSegments, codec, false).merge(keyClass, valueClass, mergeFactor, inMemSegments, tmpDir, readsCounter, writesCounter, bytesReadCounter, mergePhase);
    }

    public static <K, V> void writeFile(TezRawKeyValueIterator records, IFile.Writer writer, Progressable progressable, long recordsBeforeProgress) throws IOException, InterruptedException {
        long recordCtr = 0L;
        long count = 0L;
        while (records.next()) {
            if (records.isSameKey()) {
                writer.append(IFile.REPEAT_KEY, records.getValue());
                ++count;
            } else {
                writer.append(records.getKey(), records.getValue());
            }
            if (recordCtr++ % recordsBeforeProgress != 0L) continue;
            progressable.progress();
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new InterruptedException("Current thread=" + Thread.currentThread().getName() + " got " + "interrupted");
        }
        if (count > 0L && LOG.isTraceEnabled()) {
            LOG.trace("writeFile SAME_KEY count=" + count);
        }
    }

    private static class EmptyIterator
    implements TezRawKeyValueIterator {
        final Progress progress = new Progress();

        EmptyIterator() {
            this.progress.set(1.0f);
        }

        @Override
        public DataInputBuffer getKey() throws IOException {
            throw new RuntimeException("No keys on an empty iterator");
        }

        @Override
        public DataInputBuffer getValue() throws IOException {
            throw new RuntimeException("No values on an empty iterator");
        }

        @Override
        public boolean next() throws IOException {
            return false;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public Progress getProgress() {
            return this.progress;
        }

        @Override
        public boolean isSameKey() throws IOException {
            throw new UnsupportedOperationException("isSameKey is not supported");
        }
    }

    @VisibleForTesting
    static class MergeQueue<K, V>
    extends PriorityQueue<Segment>
    implements TezRawKeyValueIterator {
        final Configuration conf;
        final FileSystem fs;
        final CompressionCodec codec;
        final boolean checkForSameKeys;
        static final boolean ifileReadAhead = true;
        static final int ifileReadAheadLength = 0x400000;
        static final int ifileBufferSize = -1;
        static final long recordsBeforeProgress = 10000L;
        List<Segment> segments = new ArrayList<Segment>();
        final RawComparator comparator;
        private long totalBytesProcessed;
        private float progPerByte;
        private Progress mergeProgress = new LocalProgress();
        private final boolean considerFinalMergeForProgress;
        final Progressable reporter;
        final DataInputBuffer key = new DataInputBuffer();
        final DataInputBuffer value = new DataInputBuffer();
        final DataInputBuffer nextKey = new DataInputBuffer();
        final DataInputBuffer diskIFileValue = new DataInputBuffer();
        Segment minSegment;
        Comparator<Segment> segmentComparator = new Comparator<Segment>(this){
            final /* synthetic */ MergeQueue this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int compare(Segment o1, Segment o2) {
                if (o1.getLength() == o2.getLength()) {
                    return 0;
                }
                return o1.getLength() < o2.getLength() ? -1 : 1;
            }
        };
        IFile.Reader.KeyState hasNext;
        DataOutputBuffer prevKey = new DataOutputBuffer();

        public MergeQueue(Configuration conf, FileSystem fs, Path[] inputs, boolean deleteInputs, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLength, int ifileBufferSize, boolean considerFinalMergeForProgress, RawComparator comparator, Progressable reporter, TezCounter mergedMapOutputsCounter) throws IOException {
            this.conf = conf;
            this.checkForSameKeys = true;
            this.fs = fs;
            this.codec = codec;
            this.comparator = comparator;
            this.reporter = reporter;
            this.considerFinalMergeForProgress = considerFinalMergeForProgress;
            for (Path file : inputs) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("MergeQ: adding: " + file);
                }
                this.segments.add(new DiskSegment(fs, file, codec, ifileReadAhead, ifileReadAheadLength, ifileBufferSize, !deleteInputs, file.toString().endsWith(".merged") ? null : mergedMapOutputsCounter));
            }
            Collections.sort(this.segments, this.segmentComparator);
        }

        public MergeQueue(Configuration conf, FileSystem fs, List<Segment> segments, RawComparator comparator, Progressable reporter, boolean sortSegments, boolean considerFinalMergeForProgress) {
            this(conf, fs, segments, comparator, reporter, sortSegments, null, considerFinalMergeForProgress);
        }

        public MergeQueue(Configuration conf, FileSystem fs, List<Segment> segments, RawComparator comparator, Progressable reporter, boolean sortSegments, CompressionCodec codec, boolean considerFinalMergeForProgress) {
            this(conf, fs, segments, comparator, reporter, sortSegments, null, considerFinalMergeForProgress, true);
        }

        public MergeQueue(Configuration conf, FileSystem fs, List<Segment> segments, RawComparator comparator, Progressable reporter, boolean sortSegments, CompressionCodec codec, boolean considerFinalMergeForProgress, boolean checkForSameKeys) {
            this.conf = conf;
            this.fs = fs;
            this.comparator = comparator;
            this.segments = segments;
            this.reporter = reporter;
            this.considerFinalMergeForProgress = considerFinalMergeForProgress;
            if (sortSegments) {
                Collections.sort(segments, this.segmentComparator);
            }
            this.checkForSameKeys = checkForSameKeys;
            this.codec = codec;
        }

        @Override
        public void close() throws IOException {
            Segment segment;
            while ((segment = (Segment)this.pop()) != null) {
                segment.close();
            }
        }

        @Override
        public DataInputBuffer getKey() throws IOException {
            return this.key;
        }

        @Override
        public DataInputBuffer getValue() throws IOException {
            return this.value;
        }

        private void populatePreviousKey() throws IOException {
            this.key.reset();
            BufferUtils.copy(this.key, this.prevKey);
        }

        private void adjustPriorityQueue(Segment reader) throws IOException {
            long startPos = reader.getPosition();
            if (this.checkForSameKeys) {
                if (this.hasNext == null) {
                    this.populatePreviousKey();
                } else if (this.hasNext != IFile.Reader.KeyState.SAME_KEY) {
                    this.populatePreviousKey();
                }
            }
            this.hasNext = reader.readRawKey(this.nextKey);
            long endPos = reader.getPosition();
            this.totalBytesProcessed += endPos - startPos;
            this.mergeProgress.set((float)this.totalBytesProcessed * this.progPerByte);
            if (this.hasNext == IFile.Reader.KeyState.NEW_KEY) {
                this.adjustTop();
                this.compareKeyWithNextTopKey(reader);
            } else if (this.hasNext == IFile.Reader.KeyState.NO_KEY) {
                this.pop();
                reader.close();
                this.compareKeyWithNextTopKey(null);
            } else if (this.hasNext == IFile.Reader.KeyState.SAME_KEY) {
                // empty if block
            }
        }

        void compareKeyWithNextTopKey(Segment current) throws IOException {
            KeyValueBuffer nextKey;
            int compare;
            Segment nextTop = (Segment)this.top();
            if (this.checkForSameKeys && nextTop != current && (compare = this.compare(nextKey = nextTop.getKey(), this.prevKey)) == 0) {
                this.hasNext = IFile.Reader.KeyState.SAME_KEY;
            }
        }

        @Override
        public boolean next() throws IOException {
            if (this.size() == 0) {
                return false;
            }
            if (this.minSegment != null) {
                this.adjustPriorityQueue(this.minSegment);
                if (this.size() == 0) {
                    this.minSegment = null;
                    return false;
                }
            }
            this.minSegment = (Segment)this.top();
            long startPos = this.minSegment.getPosition();
            KeyValueBuffer nextKey = this.minSegment.getKey();
            this.key.reset(nextKey.getData(), nextKey.getPosition(), nextKey.getLength());
            if (!this.minSegment.inMemory()) {
                this.minSegment.getValue(this.diskIFileValue);
                this.value.reset(this.diskIFileValue.getData(), this.diskIFileValue.getLength());
            } else {
                this.minSegment.getValue(this.value);
            }
            long endPos = this.minSegment.getPosition();
            this.totalBytesProcessed += endPos - startPos;
            this.mergeProgress.set((float)this.totalBytesProcessed * this.progPerByte);
            return true;
        }

        int compare(KeyValueBuffer nextKey, DataOutputBuffer buf2) {
            byte[] b1 = nextKey.getData();
            byte[] b2 = buf2.getData();
            int s1 = nextKey.getPosition();
            int s2 = 0;
            int l1 = nextKey.getLength();
            int l2 = buf2.getLength();
            return this.comparator.compare(b1, s1, l1, b2, s2, l2);
        }

        protected boolean lessThan(Object a, Object b) {
            KeyValueBuffer key1 = ((Segment)a).getKey();
            KeyValueBuffer key2 = ((Segment)b).getKey();
            int s1 = key1.getPosition();
            int l1 = key1.getLength();
            int s2 = key2.getPosition();
            int l2 = key2.getLength();
            return this.comparator.compare(key1.getData(), s1, l1, key2.getData(), s2, l2) < 0;
        }

        public TezRawKeyValueIterator merge(Class keyClass, Class valueClass, int factor, Path tmpDir, TezCounter readsCounter, TezCounter writesCounter, TezCounter bytesReadCounter, Progress mergePhase) throws IOException, InterruptedException {
            return this.merge(keyClass, valueClass, factor, 0, tmpDir, readsCounter, writesCounter, bytesReadCounter, mergePhase);
        }

        TezRawKeyValueIterator merge(Class keyClass, Class valueClass, int factor, int inMem, Path tmpDir, TezCounter readsCounter, TezCounter writesCounter, TezCounter bytesReadCounter, Progress mergePhase) throws IOException, InterruptedException {
            long totalBytes;
            if (this.segments.size() == 0) {
                LOG.info("Nothing to merge. Returning an empty iterator");
                return new EmptyIterator();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Merging " + this.segments.size() + " sorted segments");
            }
            int numSegments = this.segments.size();
            int origFactor = factor;
            int passNo = 1;
            if (mergePhase != null) {
                this.mergeProgress = mergePhase;
            }
            if ((totalBytes = MergeQueue.computeBytesInMerges(this.segments, factor, inMem, this.considerFinalMergeForProgress)) != 0L) {
                this.progPerByte = 1.0f / (float)totalBytes;
            }
            while (true) {
                factor = MergeQueue.getPassFactor(factor, passNo, numSegments - inMem);
                if (1 == passNo) {
                    factor += inMem;
                }
                ArrayList<Segment> segmentsToMerge = new ArrayList<Segment>();
                int segmentsConsidered = 0;
                int numSegmentsToConsider = factor;
                long startBytes = 0L;
                while (true) {
                    List<Segment> mStream = this.getSegmentDescriptors(numSegmentsToConsider);
                    Iterator<Segment> iterator = mStream.iterator();
                    while (iterator.hasNext()) {
                        Segment segment = iterator.next();
                        segment.init(readsCounter, bytesReadCounter);
                        long startPos = segment.getPosition();
                        boolean hasNext = segment.nextRawKey(this.nextKey);
                        long endPos = segment.getPosition();
                        if (hasNext) {
                            startBytes += endPos - startPos;
                            segmentsToMerge.add(segment);
                            ++segmentsConsidered;
                            continue;
                        }
                        segment.close();
                        --numSegments;
                    }
                    if (segmentsConsidered == factor || this.segments.size() == 0) break;
                    numSegmentsToConsider = factor - segmentsConsidered;
                }
                this.initialize(segmentsToMerge.size());
                this.clear();
                for (Segment segment : segmentsToMerge) {
                    this.put(segment);
                }
                if (numSegments <= factor) {
                    if (!this.considerFinalMergeForProgress) {
                        this.totalBytesProcessed = 0L;
                        totalBytes = 0L;
                        for (int i = 0; i < segmentsToMerge.size(); ++i) {
                            totalBytes += ((Segment)segmentsToMerge.get(i)).getLength();
                        }
                    }
                    if (totalBytes != 0L) {
                        this.progPerByte = 1.0f / (float)totalBytes;
                    }
                    this.totalBytesProcessed += startBytes;
                    if (totalBytes != 0L) {
                        this.mergeProgress.set((float)this.totalBytesProcessed * this.progPerByte);
                    } else {
                        this.mergeProgress.set(1.0f);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Down to the last merge-pass, with " + numSegments + " segments left of total size: " + (totalBytes - this.totalBytesProcessed) + " bytes");
                    }
                    return this;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Merging " + segmentsToMerge.size() + " intermediate segments out of a total of " + (this.segments.size() + segmentsToMerge.size()));
                }
                long bytesProcessedInPrevMerges = this.totalBytesProcessed;
                this.totalBytesProcessed += startBytes;
                long approxOutputSize = 0L;
                for (Segment s : segmentsToMerge) {
                    approxOutputSize = (long)((double)approxOutputSize + ((double)s.getLength() + ChecksumFileSystem.getApproxChkSumLength((long)s.getLength())));
                }
                Path tmpFilename = new Path(tmpDir, "intermediate").suffix("." + passNo);
                Path outputFile = lDirAlloc.getLocalPathForWrite(tmpFilename.toString(), approxOutputSize, this.conf);
                IFile.Writer writer = new IFile.Writer(this.conf, this.fs, outputFile, keyClass, valueClass, this.codec, writesCounter, null);
                TezMerger.writeFile(this, writer, this.reporter, 10000L);
                writer.close();
                this.close();
                DiskSegment tempSegment = new DiskSegment(this.fs, outputFile, this.codec, true, 0x400000, -1, false);
                int pos = Collections.binarySearch(this.segments, tempSegment, this.segmentComparator);
                if (pos < 0) {
                    pos = -pos - 1;
                }
                this.segments.add(pos, tempSegment);
                numSegments = this.segments.size();
                long inputBytesOfThisMerge = this.totalBytesProcessed - bytesProcessedInPrevMerges;
                if ((totalBytes -= inputBytesOfThisMerge - ((Segment)tempSegment).getLength()) != 0L) {
                    this.progPerByte = 1.0f / (float)totalBytes;
                }
                ++passNo;
                factor = origFactor;
            }
        }

        private static int getPassFactor(int factor, int passNo, int numSegments) {
            if (passNo > 1 || numSegments <= factor || factor == 1) {
                return factor;
            }
            int mod = (numSegments - 1) % (factor - 1);
            if (mod == 0) {
                return factor;
            }
            return mod + 1;
        }

        private List<Segment> getSegmentDescriptors(int numDescriptors) {
            if (numDescriptors > this.segments.size()) {
                ArrayList<Segment> subList = new ArrayList<Segment>(this.segments);
                this.segments.clear();
                return subList;
            }
            List<Segment> subList = this.segments.subList(0, numDescriptors);
            ArrayList<Segment> subListCopy = new ArrayList<Segment>(subList);
            subList.clear();
            return subListCopy;
        }

        static long computeBytesInMerges(List<Segment> segments, int factor, int inMem, boolean considerFinalMergeForProgress) {
            int numSegments = segments.size();
            long[] segmentSizes = new long[numSegments];
            long totalBytes = 0L;
            int n = numSegments - inMem;
            int f = MergeQueue.getPassFactor(factor, 1, n) + inMem;
            n = numSegments;
            for (int i = 0; i < numSegments; ++i) {
                segmentSizes[i] = segments.get(i).getLength();
            }
            boolean considerFinalMerge = considerFinalMergeForProgress;
            int offset = 0;
            while (n > f || considerFinalMerge) {
                if (n <= f) {
                    considerFinalMerge = false;
                }
                long mergedSize = 0L;
                f = Math.min(f, n);
                for (int j = 0; j < f; ++j) {
                    mergedSize += segmentSizes[offset + j];
                }
                totalBytes += mergedSize;
                int pos = Arrays.binarySearch(segmentSizes, offset, offset + n, mergedSize);
                if (pos < 0) {
                    pos = -pos - 1;
                }
                if (pos < offset + f) {
                    segmentSizes[offset += f - 1] = mergedSize;
                } else if (pos < offset + n) {
                    if (offset + n < segmentSizes.length) {
                        System.arraycopy(segmentSizes, pos, segmentSizes, pos + 1, offset + n - pos);
                        segmentSizes[pos] = mergedSize;
                        offset += f;
                    } else {
                        System.arraycopy(segmentSizes, offset + f, segmentSizes, 0, pos - (offset + f));
                        segmentSizes[pos - (offset + f)] = mergedSize;
                        System.arraycopy(segmentSizes, pos, segmentSizes, pos - (offset + f) + 1, offset + n - pos);
                        offset = 0;
                    }
                } else if (pos < segmentSizes.length) {
                    segmentSizes[pos] = mergedSize;
                    offset += f;
                } else {
                    System.arraycopy(segmentSizes, offset + f, segmentSizes, 0, n - f);
                    segmentSizes[n - f] = mergedSize;
                    offset = 0;
                }
                n -= f - 1;
                f = factor;
            }
            return totalBytes;
        }

        @Override
        public Progress getProgress() {
            return this.mergeProgress;
        }

        @Override
        public boolean isSameKey() throws IOException {
            return this.hasNext != null && this.hasNext == IFile.Reader.KeyState.SAME_KEY;
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class DiskSegment
    extends Segment {
        FileSystem fs = null;
        Path file = null;
        boolean preserve = false;
        CompressionCodec codec = null;
        long segmentOffset = 0L;
        long segmentLength = -1L;
        boolean ifileReadAhead;
        int ifileReadAheadLength;
        int bufferSize = -1;

        public DiskSegment(FileSystem fs, Path file, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLength, int bufferSize, boolean preserve) throws IOException {
            this(fs, file, codec, ifileReadAhead, ifileReadAheadLength, bufferSize, preserve, null);
        }

        public DiskSegment(FileSystem fs, Path file, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLenth, int bufferSize, boolean preserve, TezCounter mergedMapOutputsCounter) throws IOException {
            this(fs, file, 0L, fs.getFileStatus(file).getLen(), codec, ifileReadAhead, ifileReadAheadLenth, bufferSize, preserve, mergedMapOutputsCounter);
        }

        public DiskSegment(FileSystem fs, Path file, long segmentOffset, long segmentLength, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLength, int bufferSize, boolean preserve) throws IOException {
            this(fs, file, segmentOffset, segmentLength, codec, ifileReadAhead, ifileReadAheadLength, bufferSize, preserve, null);
        }

        public DiskSegment(FileSystem fs, Path file, long segmentOffset, long segmentLength, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLength, int bufferSize, boolean preserve, TezCounter mergedMapOutputsCounter) throws IOException {
            super(null, mergedMapOutputsCounter);
            this.fs = fs;
            this.file = file;
            this.codec = codec;
            this.preserve = preserve;
            this.ifileReadAhead = ifileReadAhead;
            this.ifileReadAheadLength = ifileReadAheadLength;
            this.bufferSize = bufferSize;
            this.segmentOffset = segmentOffset;
            this.segmentLength = segmentLength;
        }

        @Override
        void init(TezCounter readsCounter, TezCounter bytesReadCounter) throws IOException {
            super.init(readsCounter, bytesReadCounter);
            FSDataInputStream in = this.fs.open(this.file);
            in.seek(this.segmentOffset);
            this.reader = new IFile.Reader((InputStream)in, this.segmentLength, this.codec, readsCounter, bytesReadCounter, this.ifileReadAhead, this.ifileReadAheadLength, this.bufferSize);
        }

        @Override
        boolean inMemory() {
            return false;
        }

        @Override
        public long getLength() {
            return this.reader == null ? this.segmentLength : this.reader.getLength();
        }

        @Override
        void close() throws IOException {
            super.close();
            if (!this.preserve && this.fs != null) {
                this.fs.delete(this.file, false);
            }
        }

        @Override
        long getActualPosition() throws IOException {
            return this.segmentOffset + this.reader.getPosition();
        }

        @Override
        void reinitReader(int offset) throws IOException {
            if (!this.inMemory()) {
                this.closeReader();
                this.segmentOffset = offset;
                this.segmentLength = this.fs.getFileStatus(this.file).getLen() - this.segmentOffset;
                this.init(null, null);
            }
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class Segment {
        static final byte[] EMPTY_BYTES = new byte[0];
        IFile.Reader reader = null;
        final KeyValueBuffer key = new KeyValueBuffer(EMPTY_BYTES, 0, 0);
        TezCounter mapOutputsCounter = null;

        public Segment(IFile.Reader reader, TezCounter mapOutputsCounter) {
            this.reader = reader;
            this.mapOutputsCounter = mapOutputsCounter;
        }

        void init(TezCounter readsCounter, TezCounter bytesReadCounter) throws IOException {
            if (this.mapOutputsCounter != null) {
                this.mapOutputsCounter.increment(1L);
            }
        }

        boolean inMemory() {
            return true;
        }

        KeyValueBuffer getKey() {
            return this.key;
        }

        DataInputBuffer getValue(DataInputBuffer value) throws IOException {
            this.nextRawValue(value);
            return value;
        }

        public long getLength() {
            return this.reader.getLength();
        }

        IFile.Reader.KeyState readRawKey(DataInputBuffer nextKey) throws IOException {
            IFile.Reader.KeyState keyState = this.reader.readRawKey(nextKey);
            this.key.reset(nextKey.getData(), nextKey.getPosition(), nextKey.getLength() - nextKey.getPosition());
            return keyState;
        }

        boolean nextRawKey(DataInputBuffer nextKey) throws IOException {
            boolean hasNext = this.reader.nextRawKey(nextKey);
            this.key.reset(nextKey.getData(), nextKey.getPosition(), nextKey.getLength() - nextKey.getPosition());
            return hasNext;
        }

        void nextRawValue(DataInputBuffer value) throws IOException {
            this.reader.nextRawValue(value);
        }

        void closeReader() throws IOException {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }

        void close() throws IOException {
            this.closeReader();
        }

        public long getPosition() throws IOException {
            return this.reader.getPosition();
        }

        long getActualPosition() throws IOException {
            return this.reader.getPosition();
        }

        IFile.Reader getReader() {
            return this.reader;
        }

        void reinitReader(int offset) throws IOException {
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    static class KeyValueBuffer {
        private byte[] buf;
        private int position;
        private int length;

        public KeyValueBuffer(byte[] buf, int position, int length) {
            this.reset(buf, position, length);
        }

        public void reset(byte[] input, int position, int length) {
            this.buf = input;
            this.position = position;
            this.length = length;
        }

        public byte[] getData() {
            return this.buf;
        }

        public int getPosition() {
            return this.position;
        }

        public int getLength() {
            return this.length;
        }
    }
}

