/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.cartesianproduct;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.tez.dag.api.EdgeManagerPluginContext;
import org.apache.tez.dag.api.EdgeManagerPluginOnDemand;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductEdgeManagerPartitioned;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductEdgeManagerReal;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductUserPayload;
import org.apache.tez.runtime.library.cartesianproduct.FairCartesianProductEdgeManager;

public class CartesianProductEdgeManager
extends EdgeManagerPluginOnDemand {
    private CartesianProductEdgeManagerReal edgeManagerReal;

    public CartesianProductEdgeManager(EdgeManagerPluginContext context) {
        super(context);
    }

    public void initialize() throws Exception {
        Preconditions.checkArgument((this.getContext().getUserPayload() != null ? 1 : 0) != 0);
        CartesianProductUserPayload.CartesianProductConfigProto config = CartesianProductUserPayload.CartesianProductConfigProto.parseFrom(ByteString.copyFrom((ByteBuffer)this.getContext().getUserPayload().getPayload()));
        this.edgeManagerReal = config.getIsPartitioned() ? new CartesianProductEdgeManagerPartitioned(this.getContext()) : new FairCartesianProductEdgeManager(this.getContext());
        this.edgeManagerReal.initialize(config);
    }

    @VisibleForTesting
    protected CartesianProductEdgeManagerReal getEdgeManagerReal() {
        return this.edgeManagerReal;
    }

    public void prepareForRouting() throws Exception {
        this.edgeManagerReal.prepareForRouting();
    }

    public int routeInputErrorEventToSource(int destTaskId, int failedInputId) throws Exception {
        return this.edgeManagerReal.routeInputErrorEventToSource(destTaskId, failedInputId);
    }

    @Nullable
    public EdgeManagerPluginOnDemand.EventRouteMetadata routeDataMovementEventToDestination(int srcTaskId, int srcOutputId, int destTaskId) throws Exception {
        return this.edgeManagerReal.routeDataMovementEventToDestination(srcTaskId, srcOutputId, destTaskId);
    }

    @Nullable
    public EdgeManagerPluginOnDemand.CompositeEventRouteMetadata routeCompositeDataMovementEventToDestination(int srcTaskId, int destTaskId) throws Exception {
        return this.edgeManagerReal.routeCompositeDataMovementEventToDestination(srcTaskId, destTaskId);
    }

    @Nullable
    public EdgeManagerPluginOnDemand.EventRouteMetadata routeInputSourceTaskFailedEventToDestination(int srcTaskId, int destTaskId) throws Exception {
        return this.edgeManagerReal.routeInputSourceTaskFailedEventToDestination(srcTaskId, destTaskId);
    }

    public int getNumDestinationTaskPhysicalInputs(int destTaskId) {
        return this.edgeManagerReal.getNumDestinationTaskPhysicalInputs(destTaskId);
    }

    public int getNumSourceTaskPhysicalOutputs(int srcTaskId) {
        return this.edgeManagerReal.getNumSourceTaskPhysicalOutputs(srcTaskId);
    }

    public int getNumDestinationConsumerTasks(int sourceTaskIndex) {
        return this.edgeManagerReal.getNumDestinationConsumerTasks(sourceTaskIndex);
    }
}

