/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.cartesianproduct;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductFilterDescriptor;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductUserPayload;

@InterfaceStability.Evolving
public class CartesianProductConfig {
    private final boolean isPartitioned;
    private final String[] sources;
    private final int[] numPartitions;
    private final CartesianProductFilterDescriptor filterDescriptor;

    public CartesianProductConfig(List<String> sources) {
        Preconditions.checkArgument((sources != null ? 1 : 0) != 0, (Object)"source list cannot be null");
        Preconditions.checkArgument((sources.size() > 1 ? 1 : 0) != 0, (Object)("there must be more than 1 source 67, currently only " + sources.size()));
        this.isPartitioned = false;
        this.sources = sources.toArray(new String[sources.size()]);
        this.numPartitions = null;
        this.filterDescriptor = null;
    }

    public CartesianProductConfig(Map<String, Integer> vertexPartitionMap) {
        this(vertexPartitionMap, null);
    }

    public CartesianProductConfig(Map<String, Integer> vertexPartitionMap, CartesianProductFilterDescriptor filterDescriptor) {
        Preconditions.checkArgument((vertexPartitionMap != null ? 1 : 0) != 0, (Object)"vertex-partition map cannot be null");
        Preconditions.checkArgument((vertexPartitionMap.size() > 1 ? 1 : 0) != 0, (Object)("there must be more than 1 source vertices, currently only " + vertexPartitionMap.size()));
        this.isPartitioned = true;
        this.numPartitions = new int[vertexPartitionMap.size()];
        this.sources = new String[vertexPartitionMap.size()];
        this.filterDescriptor = filterDescriptor;
        int i = 0;
        for (Map.Entry<String, Integer> entry : vertexPartitionMap.entrySet()) {
            this.sources[i] = entry.getKey();
            this.numPartitions[i] = entry.getValue();
            ++i;
        }
        this.checkNumPartitions();
    }

    @VisibleForTesting
    protected CartesianProductConfig(int[] numPartitions, String[] sources, CartesianProductFilterDescriptor filterDescriptor) {
        Preconditions.checkArgument((numPartitions != null ? 1 : 0) != 0, (Object)"partitions count array can't be null");
        Preconditions.checkArgument((sources != null ? 1 : 0) != 0, (Object)"source array can't be null");
        Preconditions.checkArgument((numPartitions.length == sources.length ? 1 : 0) != 0, (Object)("partitions count array(length: " + numPartitions.length + ") and source array " + "(length: " + sources.length + ") cannot have different length"));
        Preconditions.checkArgument((sources.length > 1 ? 1 : 0) != 0, (Object)("there must be more than 1 source , currently only " + sources.length));
        this.isPartitioned = true;
        this.numPartitions = numPartitions;
        this.sources = sources;
        this.filterDescriptor = filterDescriptor;
        this.checkNumPartitions();
    }

    protected CartesianProductConfig(boolean isPartitioned, int[] numPartitions, String[] sources, CartesianProductFilterDescriptor filterDescriptor) {
        this.isPartitioned = isPartitioned;
        this.numPartitions = numPartitions;
        this.sources = sources;
        this.filterDescriptor = filterDescriptor;
    }

    @VisibleForTesting
    protected void checkNumPartitions() {
        if (this.isPartitioned) {
            boolean isUnpartitioned = true;
            for (int i = 0; i < this.numPartitions.length; ++i) {
                Preconditions.checkArgument((this.numPartitions[i] > 0 ? 1 : 0) != 0, (Object)("Vertex " + this.sources[i] + "has negative (" + this.numPartitions[i] + ") partitions"));
                isUnpartitioned = isUnpartitioned && this.numPartitions[i] == 1;
            }
            Preconditions.checkArgument((!isUnpartitioned ? 1 : 0) != 0, (Object)"every source has 1 partition in a partitioned case");
        } else {
            Preconditions.checkArgument((this.numPartitions == null ? 1 : 0) != 0, (Object)"partition counts should be null in fair cartesian product");
        }
    }

    public List<String> getSourceVertices() {
        return Collections.unmodifiableList(Arrays.asList(this.sources));
    }

    public List<Integer> getNumPartitions() {
        if (this.numPartitions == null) {
            return null;
        }
        return Collections.unmodifiableList(Ints.asList((int[])this.numPartitions));
    }

    public boolean getIsPartitioned() {
        return this.isPartitioned;
    }

    public CartesianProductFilterDescriptor getFilterDescriptor() {
        return this.filterDescriptor;
    }

    public UserPayload toUserPayload(TezConfiguration conf) throws IOException {
        return UserPayload.create((ByteBuffer)ByteBuffer.wrap(this.toProto(conf).toByteArray()));
    }

    protected CartesianProductUserPayload.CartesianProductConfigProto toProto(TezConfiguration conf) {
        CartesianProductUserPayload.CartesianProductConfigProto.Builder builder = CartesianProductUserPayload.CartesianProductConfigProto.newBuilder();
        builder.setIsPartitioned(this.isPartitioned).addAllSources(Arrays.asList(this.sources));
        if (this.isPartitioned) {
            builder.addAllNumPartitions(Ints.asList((int[])this.numPartitions));
            if (this.filterDescriptor != null) {
                builder.setFilterClassName(this.filterDescriptor.getClassName());
                UserPayload filterUesrPayload = this.filterDescriptor.getUserPayload();
                if (filterUesrPayload != null) {
                    builder.setFilterUserPayload(ByteString.copyFrom((ByteBuffer)filterUesrPayload.getPayload()));
                }
            }
        }
        if (conf != null) {
            builder.setMinFraction(conf.getFloat("tez.cartesian-product.min-src-fraction", 0.25f));
            builder.setMaxFraction(conf.getFloat("tez.cartesian-product.max-src-fraction", 0.75f));
            builder.setMaxParallelism(conf.getInt("tez.cartesian-product.max-parallelism", 1000));
            builder.setMinOpsPerWorker(conf.getLong("tez.cartesian-product.min-ops-per-worker", 1000000L));
            builder.setEnableGrouping(conf.getBoolean("tez.cartesian-product.disable-grouping", true));
            if (conf.get("tez.cartesian-product.grouping-fraction") != null) {
                builder.setGroupingFraction(Float.parseFloat(conf.get("tez.cartesian-product.grouping-fraction")));
                Preconditions.checkArgument((0.0f < builder.getGroupingFraction() && builder.getGroupingFraction() <= 1.0f ? 1 : 0) != 0, (Object)("grouping fraction should be larger than 0 and less or equal to 1, current value: " + builder.getGroupingFraction()));
            }
            if (conf.get("tez.cartesian-product.num-partitions") != null) {
                builder.setNumPartitionsForFairCase(Integer.parseInt(conf.get("tez.cartesian-product.num-partitions")));
                Preconditions.checkArgument((builder.getNumPartitionsForFairCase() > 0 ? 1 : 0) != 0, (Object)"Number of partitions for fair cartesian product should be positive integer");
            }
        }
        Preconditions.checkArgument((builder.getMinFraction() <= builder.getMaxFraction() ? 1 : 0) != 0, (Object)("min fraction(" + builder.getMinFraction() + ") should be less than max fraction(" + builder.getMaxFraction() + ") in cartesian product slow start"));
        Preconditions.checkArgument((builder.getMaxParallelism() > 0 ? 1 : 0) != 0, (Object)("max parallelism must be positive, currently is " + builder.getMaxParallelism()));
        Preconditions.checkArgument((builder.getMinOpsPerWorker() > 0L ? 1 : 0) != 0, (Object)("Min ops per worker must be positive, currently is " + builder.getMinOpsPerWorker()));
        return builder.build();
    }

    protected static CartesianProductUserPayload.CartesianProductConfigProto userPayloadToProto(UserPayload payload) throws InvalidProtocolBufferException {
        Preconditions.checkArgument((payload != null ? 1 : 0) != 0, (Object)"UserPayload is null");
        Preconditions.checkArgument((payload.getPayload() != null ? 1 : 0) != 0, (Object)"UserPayload carreis null payload");
        return CartesianProductUserPayload.CartesianProductConfigProto.parseFrom(ByteString.copyFrom((ByteBuffer)payload.getPayload()));
    }

    protected static CartesianProductConfig fromUserPayload(UserPayload payload) throws InvalidProtocolBufferException {
        return CartesianProductConfig.fromProto(CartesianProductConfig.userPayloadToProto(payload));
    }

    protected static CartesianProductConfig fromProto(CartesianProductUserPayload.CartesianProductConfigProto proto) {
        if (!proto.getIsPartitioned()) {
            return new CartesianProductConfig(proto.getSourcesList());
        }
        String[] sourceVertices = new String[proto.getSourcesList().size()];
        proto.getSourcesList().toArray(sourceVertices);
        CartesianProductFilterDescriptor filterDescriptor = null;
        if (proto.hasFilterClassName()) {
            filterDescriptor = new CartesianProductFilterDescriptor(proto.getFilterClassName());
            if (proto.hasFilterUserPayload()) {
                filterDescriptor.setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap(proto.getFilterUserPayload().toByteArray())));
            }
        }
        return new CartesianProductConfig(Ints.toArray(proto.getNumPartitionsList()), sourceVertices, filterDescriptor);
    }
}

