/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.orderedgrouped;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MergeManager;
import org.apache.tez.runtime.library.common.sort.impl.IFile;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class InMemoryReader
extends IFile.Reader {
    private final InputAttemptIdentifier taskAttemptId;
    private final MergeManager merger;
    ByteArrayDataInput memDataIn;
    private int start;
    private int length;
    private int originalKeyPos;

    public InMemoryReader(MergeManager merger, InputAttemptIdentifier taskAttemptId, byte[] data, int start, int length) throws IOException {
        super(null, length - start, null, null, null, false, 0, -1);
        this.taskAttemptId = taskAttemptId;
        this.merger = merger;
        this.buffer = data;
        this.bufferSize = length;
        this.memDataIn = new ByteArrayDataInput(this.buffer, start, length);
        this.start = start;
        this.length = length;
    }

    @Override
    public void reset(int offset) {
        this.memDataIn.reset(this.buffer, this.start + offset, this.length);
        this.bytesRead = offset;
        this.eof = false;
    }

    @Override
    public long getPosition() throws IOException {
        return this.bytesRead;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpOnError() {
        File dumpFile = new File("../output/" + this.taskAttemptId + ".dump");
        System.err.println("Dumping corrupt map-output of " + this.taskAttemptId + " to " + dumpFile.getAbsolutePath());
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(dumpFile);
            fos.write(this.buffer, 0, this.bufferSize);
        }
        catch (IOException ioe) {
            System.err.println("Failed to dump map-output of " + this.taskAttemptId);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    System.err.println("Failed to dump map-output of " + this.taskAttemptId);
                }
            }
        }
    }

    @Override
    protected void readKeyValueLength(DataInput dIn) throws IOException {
        super.readKeyValueLength(dIn);
        if (this.currentKeyLength != -2) {
            this.originalKeyPos = this.memDataIn.getPosition();
        }
    }

    @Override
    public IFile.Reader.KeyState readRawKey(DataInputBuffer key) throws IOException {
        try {
            if (!this.positionToNextRecord(this.memDataIn)) {
                return IFile.Reader.KeyState.NO_KEY;
            }
            int pos = this.memDataIn.getPosition();
            byte[] data = this.memDataIn.getData();
            if (this.currentKeyLength == -2) {
                key.reset(data, this.originalKeyPos, this.originalKeyLength);
                return IFile.Reader.KeyState.SAME_KEY;
            }
            key.reset(data, pos, this.currentKeyLength);
            long skipped = this.memDataIn.skip(this.currentKeyLength);
            if (skipped != (long)this.currentKeyLength) {
                throw new IOException("Rec# " + this.recNo + ": Failed to skip past key of length: " + this.currentKeyLength);
            }
            this.bytesRead += (long)this.currentKeyLength;
            return IFile.Reader.KeyState.NEW_KEY;
        }
        catch (IOException ioe) {
            this.dumpOnError();
            throw ioe;
        }
    }

    @Override
    public void nextRawValue(DataInputBuffer value) throws IOException {
        try {
            int pos = this.memDataIn.getPosition();
            byte[] data = this.memDataIn.getData();
            value.reset(data, pos, this.currentValueLength);
            long skipped = this.memDataIn.skip(this.currentValueLength);
            if (skipped != (long)this.currentValueLength) {
                throw new IOException("Rec# " + this.recNo + ": Failed to skip past value of length: " + this.currentValueLength);
            }
            this.bytesRead += (long)this.currentValueLength;
            ++this.recNo;
        }
        catch (IOException ioe) {
            this.dumpOnError();
            throw ioe;
        }
    }

    @Override
    public void close() {
        this.buffer = null;
        if (this.merger != null) {
            this.merger.unreserve(this.bufferSize);
        }
    }

    private static class ByteArrayDataInput
    extends ByteArrayInputStream
    implements DataInput {
        public ByteArrayDataInput(byte[] buf, int offset, int length) {
            super(buf, offset, length);
        }

        public void reset(byte[] input, int start, int length) {
            this.buf = input;
            this.count = start + length;
            this.mark = start;
            this.pos = start;
        }

        public byte[] getData() {
            return this.buf;
        }

        public int getPosition() {
            return this.pos;
        }

        public int getLength() {
            return this.count;
        }

        public int getMark() {
            return this.mark;
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int skipBytes(int n) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean readBoolean() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte readByte() throws IOException {
            return (byte)this.read();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public short readShort() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public char readChar() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int readInt() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long readLong() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public float readFloat() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public double readDouble() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readLine() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readUTF() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

