/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.FetchedInput;
import org.apache.tez.runtime.library.common.shuffle.FetchedInputCallback;
import org.apache.tez.runtime.library.common.task.local.output.TezTaskOutputFiles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskFetchedInput
extends FetchedInput {
    private static final Logger LOG = LoggerFactory.getLogger(DiskFetchedInput.class);
    private final FileSystem localFS;
    private final Path tmpOutputPath;
    private final Path outputPath;

    public DiskFetchedInput(long actualSize, long compressedSize, InputAttemptIdentifier inputAttemptIdentifier, FetchedInputCallback callbackHandler, Configuration conf, LocalDirAllocator localDirAllocator, TezTaskOutputFiles filenameAllocator) throws IOException {
        super(FetchedInput.Type.DISK, actualSize, compressedSize, inputAttemptIdentifier, callbackHandler);
        this.localFS = FileSystem.getLocal((Configuration)conf);
        this.outputPath = filenameAllocator.getInputFileForWrite(this.inputAttemptIdentifier.getInputIdentifier(), this.inputAttemptIdentifier.getSpillEventId(), actualSize);
        this.tmpOutputPath = this.outputPath.suffix(String.valueOf(this.id));
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.localFS.create(this.tmpOutputPath);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.localFS.open(this.outputPath);
    }

    public final Path getInputPath() {
        if (this.state == FetchedInput.State.COMMITTED) {
            return this.outputPath;
        }
        return this.tmpOutputPath;
    }

    @Override
    public void commit() throws IOException {
        if (this.state == FetchedInput.State.PENDING) {
            this.state = FetchedInput.State.COMMITTED;
            this.localFS.rename(this.tmpOutputPath, this.outputPath);
            this.notifyFetchComplete();
        }
    }

    @Override
    public void abort() throws IOException {
        if (this.state == FetchedInput.State.PENDING) {
            this.state = FetchedInput.State.ABORTED;
            this.localFS.delete(this.tmpOutputPath, false);
            this.notifyFetchFailure();
        }
    }

    @Override
    public void free() {
        Preconditions.checkState((this.state == FetchedInput.State.COMMITTED || this.state == FetchedInput.State.ABORTED ? 1 : 0) != 0, (Object)"FetchedInput can only be freed after it is committed or aborted");
        if (this.state == FetchedInput.State.COMMITTED) {
            this.state = FetchedInput.State.FREED;
            try {
                this.localFS.delete(this.outputPath, false);
            }
            catch (IOException e) {
                LOG.warn("Failed to remvoe file : " + this.outputPath.toString());
            }
            this.notifyFreedResource();
        }
    }

    public String toString() {
        return "DiskFetchedInput [outputPath=" + this.outputPath + ", inputAttemptIdentifier=" + this.inputAttemptIdentifier + ", actualSize=" + this.actualSize + ",compressedSize=" + this.compressedSize + ", type=" + (Object)((Object)this.type) + ", id=" + this.id + ", state=" + (Object)((Object)this.state) + "]";
    }
}

