/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.sort.impl;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.util.IndexedSorter;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.QuickSort;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.TaskContext;
import org.apache.tez.runtime.library.api.Partitioner;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.apache.tez.runtime.library.common.TezRuntimeUtils;
import org.apache.tez.runtime.library.common.combine.Combiner;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ShuffleHeader;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.common.sort.impl.TezRawKeyValueIterator;
import org.apache.tez.runtime.library.common.task.local.output.TezTaskOutput;
import org.apache.tez.runtime.library.hadoop.compat.NullProgressable;

public abstract class ExternalSorter {
    private static final Log LOG = LogFactory.getLog(ExternalSorter.class);
    protected final Progressable nullProgressable = new NullProgressable();
    protected final OutputContext outputContext;
    protected final Combiner combiner;
    protected final Partitioner partitioner;
    protected final Configuration conf;
    protected final FileSystem rfs;
    protected final TezTaskOutput mapOutputFile;
    protected final int partitions;
    protected final Class keyClass;
    protected final Class valClass;
    protected final RawComparator comparator;
    protected final SerializationFactory serializationFactory;
    protected final Serializer keySerializer;
    protected final Serializer valSerializer;
    protected final boolean ifileReadAhead;
    protected final int ifileReadAheadLength;
    protected final int ifileBufferSize;
    protected final int availableMemoryMb;
    protected final IndexedSorter sorter;
    protected final CompressionCodec codec;
    protected final TezCounter mapOutputByteCounter;
    protected final TezCounter mapOutputRecordCounter;
    protected final TezCounter outputBytesWithOverheadCounter;
    protected final TezCounter fileOutputByteCounter;
    protected final TezCounter spilledRecordsCounter;
    protected final TezCounter additionalSpillBytesWritten;
    protected final TezCounter additionalSpillBytesRead;
    protected final TezCounter numAdditionalSpills;

    public abstract void close() throws IOException;

    public abstract void flush() throws IOException;

    public abstract void write(Object var1, Object var2) throws IOException;

    public void write(Object key, Iterable<Object> values) throws IOException {
        Iterator<Object> it = values.iterator();
        while (it.hasNext()) {
            this.write(key, it.next());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExternalSorter(OutputContext outputContext, Configuration conf, int numOutputs, long initialMemoryAvailable) throws IOException {
        this.outputContext = outputContext;
        this.conf = conf;
        this.partitions = numOutputs;
        this.rfs = FileSystem.getLocal((Configuration)this.conf).getRaw();
        int assignedMb = (int)(initialMemoryAvailable >> 20);
        if (assignedMb <= 0) {
            if (initialMemoryAvailable <= 0L) throw new RuntimeException("InitialMemoryAssigned is <= 0: " + initialMemoryAvailable);
            this.availableMemoryMb = 1;
            LOG.warn((Object)("initialAvailableMemory: " + initialMemoryAvailable + " is too low. Rounding to 1 MB"));
        } else {
            this.availableMemoryMb = assignedMb;
        }
        this.sorter = (IndexedSorter)ReflectionUtils.newInstance((Class)this.conf.getClass("tez.runtime.internal.sorter.class", QuickSort.class, IndexedSorter.class), (Configuration)this.conf);
        this.comparator = ConfigUtils.getIntermediateOutputKeyComparator(this.conf);
        this.keyClass = ConfigUtils.getIntermediateOutputKeyClass(this.conf);
        this.valClass = ConfigUtils.getIntermediateOutputValueClass(this.conf);
        this.serializationFactory = new SerializationFactory(this.conf);
        this.keySerializer = this.serializationFactory.getSerializer(this.keyClass);
        this.valSerializer = this.serializationFactory.getSerializer(this.valClass);
        LOG.info((Object)("keySerializer=" + this.keySerializer + "; valueSerializer=" + this.valSerializer + "; comparator=" + ConfigUtils.getIntermediateOutputKeyComparator(conf) + "; conf=" + conf.get("io.serializations")));
        this.mapOutputByteCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.OUTPUT_BYTES);
        this.mapOutputRecordCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.OUTPUT_RECORDS);
        this.outputBytesWithOverheadCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.OUTPUT_BYTES_WITH_OVERHEAD);
        this.fileOutputByteCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.OUTPUT_BYTES_PHYSICAL);
        this.spilledRecordsCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.SPILLED_RECORDS);
        this.additionalSpillBytesWritten = outputContext.getCounters().findCounter((Enum)TaskCounter.ADDITIONAL_SPILLS_BYTES_WRITTEN);
        this.additionalSpillBytesRead = outputContext.getCounters().findCounter((Enum)TaskCounter.ADDITIONAL_SPILLS_BYTES_READ);
        this.numAdditionalSpills = outputContext.getCounters().findCounter((Enum)TaskCounter.ADDITIONAL_SPILL_COUNT);
        if (ConfigUtils.shouldCompressIntermediateOutput(this.conf)) {
            Class<? extends CompressionCodec> codecClass = ConfigUtils.getIntermediateOutputCompressorClass(this.conf, DefaultCodec.class);
            this.codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, (Configuration)this.conf);
            if (this.codec != null) {
                Class compressorType = null;
                RuntimeException cause = null;
                try {
                    compressorType = this.codec.getCompressorType();
                }
                catch (RuntimeException e) {
                    cause = e;
                }
                if (compressorType == null) {
                    String errMsg = String.format("Unable to get CompressorType for codec (%s). This is most likely due to missing native libraries for the codec.", conf.get("tez.runtime.compress.codec"));
                    throw new IOException(errMsg, cause);
                }
            }
        } else {
            this.codec = null;
        }
        this.ifileReadAhead = this.conf.getBoolean("tez.runtime.ifile.readahead", true);
        this.ifileReadAheadLength = this.ifileReadAhead ? conf.getInt("tez.runtime.ifile.readahead.bytes", 0x400000) : 0;
        this.ifileBufferSize = conf.getInt("io.file.buffer.size", -1);
        this.mapOutputFile = TezRuntimeUtils.instantiateTaskOutputManager(conf, outputContext);
        LOG.info((Object)("Instantiating Partitioner: [" + conf.get("tez.runtime.partitioner.class") + "]"));
        this.conf.setInt("tez.runtime.framework.num.expected.partitions", this.partitions);
        this.partitioner = TezRuntimeUtils.instantiatePartitioner(this.conf);
        this.combiner = TezRuntimeUtils.instantiateCombiner(this.conf, (TaskContext)outputContext);
    }

    @InterfaceAudience.Private
    public TezTaskOutput getMapOutput() {
        return this.mapOutputFile;
    }

    protected void runCombineProcessor(TezRawKeyValueIterator kvIter, IFile.Writer writer) throws IOException {
        try {
            this.combiner.combine(kvIter, writer);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    protected void sameVolRename(Path srcPath, Path dstPath) throws IOException {
        RawLocalFileSystem rfs = (RawLocalFileSystem)this.rfs;
        File src = rfs.pathToFile(srcPath);
        File dst = rfs.pathToFile(dstPath);
        if (!dst.getParentFile().exists() && !dst.getParentFile().mkdirs()) {
            throw new IOException("Unable to rename " + src + " to " + dst + ": couldn't create parent directory");
        }
        if (!src.renameTo(dst)) {
            throw new IOException("Unable to rename " + src + " to " + dst);
        }
    }

    public InputStream getSortedStream(int partition) {
        throw new UnsupportedOperationException("getSortedStream isn't supported!");
    }

    public ShuffleHeader getShuffleHeader(int reduce) {
        throw new UnsupportedOperationException("getShuffleHeader isn't supported!");
    }

    public static long getInitialMemoryRequirement(Configuration conf, long maxAvailableTaskMemory) {
        int initialMemRequestMb = conf.getInt("tez.runtime.io.sort.mb", 100);
        Preconditions.checkArgument((initialMemRequestMb != 0 ? 1 : 0) != 0, (Object)"io.sort.mb should be larger than 0");
        long reqBytes = initialMemRequestMb << 20;
        LOG.info((Object)("Requested SortBufferSize (io.sort.mb): " + initialMemRequestMb));
        return reqBytes;
    }

    public static class MapBufferTooSmallException
    extends IOException {
        public MapBufferTooSmallException(String s) {
            super(s);
        }
    }
}

