/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.shuffle.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.shuffle.common.FetchedInputCallback;

@InterfaceAudience.Private
public abstract class FetchedInput {
    private static AtomicInteger ID_GEN = new AtomicInteger(0);
    protected InputAttemptIdentifier inputAttemptIdentifier;
    protected final long actualSize;
    protected final long compressedSize;
    protected final Type type;
    protected final FetchedInputCallback callback;
    protected final int id;
    protected State state;

    public FetchedInput(Type type, long actualSize, long compressedSize, InputAttemptIdentifier inputAttemptIdentifier, FetchedInputCallback callbackHandler) {
        this.type = type;
        this.actualSize = actualSize;
        this.compressedSize = compressedSize;
        this.inputAttemptIdentifier = inputAttemptIdentifier;
        this.callback = callbackHandler;
        this.id = ID_GEN.getAndIncrement();
        this.state = State.PENDING;
    }

    public Type getType() {
        return this.type;
    }

    public long getActualSize() {
        return this.actualSize;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public InputAttemptIdentifier getInputAttemptIdentifier() {
        return this.inputAttemptIdentifier;
    }

    public void notifyFetchComplete() {
        this.callback.fetchComplete(this);
    }

    public void notifyFetchFailure() {
        this.callback.fetchFailed(this);
    }

    public void notifyFreedResource() {
        this.callback.freeResources(this);
    }

    public abstract OutputStream getOutputStream() throws IOException;

    public abstract InputStream getInputStream() throws IOException;

    public abstract void commit() throws IOException;

    public abstract void abort() throws IOException;

    public abstract void free();

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FetchedInput other = (FetchedInput)obj;
        return this.id == other.id;
    }

    protected static enum State {
        PENDING,
        COMMITTED,
        ABORTED,
        FREED;

    }

    public static enum Type {
        WAIT,
        MEMORY,
        DISK,
        DISK_DIRECT;

    }
}

