/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.processor;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.api.AbstractLogicalIOProcessor;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;

@InterfaceAudience.Private
public class SleepProcessor
extends AbstractLogicalIOProcessor {
    private static final Log LOG = LogFactory.getLog(SleepProcessor.class);
    private int timeToSleepMS;

    public SleepProcessor(ProcessorContext context) {
        super(context);
    }

    public void initialize() throws Exception {
        if (this.getContext().getUserPayload() == null) {
            LOG.info((Object)"No processor user payload specified, using default timeToSleep of 1 ms");
            this.timeToSleepMS = 1;
        } else {
            SleepProcessorConfig cfg = new SleepProcessorConfig();
            cfg.fromUserPayload(this.getContext().getUserPayload());
            this.timeToSleepMS = cfg.getTimeToSleepMS();
        }
        LOG.info((Object)("Initialized SleepProcessor, timeToSleepMS=" + this.timeToSleepMS));
    }

    public void run(Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        LOG.info((Object)("Running the Sleep Processor, sleeping for " + this.timeToSleepMS + " ms"));
        for (LogicalInput input : inputs.values()) {
            input.start();
        }
        for (LogicalOutput output : outputs.values()) {
            output.start();
        }
        try {
            Thread.sleep(this.timeToSleepMS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void handleEvents(List<Event> processorEvents) {
    }

    public void close() throws Exception {
    }

    public static class SleepProcessorConfig {
        private int timeToSleepMS;
        private final Charset charSet = Charset.forName("UTF-8");

        public SleepProcessorConfig() {
        }

        public SleepProcessorConfig(int timeToSleepMS) {
            this.timeToSleepMS = timeToSleepMS;
        }

        public UserPayload toUserPayload() {
            return UserPayload.create((ByteBuffer)ByteBuffer.wrap(Integer.toString(this.timeToSleepMS).getBytes()));
        }

        public void fromUserPayload(UserPayload userPayload) throws CharacterCodingException {
            this.timeToSleepMS = Integer.valueOf(this.charSet.newDecoder().decode(userPayload.getPayload()).toString());
        }

        public int getTimeToSleepMS() {
            return this.timeToSleepMS;
        }
    }
}

