/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;

@InterfaceAudience.Private
class MapHost {
    private State state = State.IDLE;
    private final String hostIdentifier;
    private final int partitionId;
    private final String baseUrl;
    private final String identifier;
    private List<InputAttemptIdentifier> maps = new ArrayList<InputAttemptIdentifier>();

    public MapHost(int partitionId, String hostPort, String baseUrl) {
        this.partitionId = partitionId;
        this.hostIdentifier = hostPort;
        this.baseUrl = baseUrl;
        this.identifier = MapHost.createIdentifier(hostPort, partitionId);
    }

    public static String createIdentifier(String hostName, int partitionId) {
        return hostName + ":" + Integer.toString(partitionId);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public State getState() {
        return this.state;
    }

    public String getHostIdentifier() {
        return this.hostIdentifier;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public synchronized void addKnownMap(InputAttemptIdentifier srcAttempt) {
        this.maps.add(srcAttempt);
        if (this.state == State.IDLE) {
            this.state = State.PENDING;
        }
    }

    public synchronized List<InputAttemptIdentifier> getAndClearKnownMaps() {
        List<InputAttemptIdentifier> currentKnownMaps = this.maps;
        this.maps = new ArrayList<InputAttemptIdentifier>();
        return currentKnownMaps;
    }

    public synchronized void markBusy() {
        this.state = State.BUSY;
    }

    public synchronized void markPenalized() {
        this.state = State.PENALIZED;
    }

    public synchronized int getNumKnownMapOutputs() {
        return this.maps.size();
    }

    public synchronized State markAvailable() {
        this.state = this.maps.isEmpty() ? State.IDLE : State.PENDING;
        return this.state;
    }

    public String toString() {
        return this.hostIdentifier;
    }

    public synchronized void penalize() {
        this.state = State.PENALIZED;
    }

    public static enum State {
        IDLE,
        BUSY,
        PENDING,
        PENALIZED;

    }
}

