/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.runtime.library.common.sort.impl.TezRawKeyValueIterator;

@InterfaceAudience.Private
public class ValuesIterator<KEY, VALUE> {
    private static final Log LOG = LogFactory.getLog((String)ValuesIterator.class.getName());
    protected TezRawKeyValueIterator in;
    private KEY key;
    private KEY nextKey;
    private VALUE value;
    private boolean more;
    private RawComparator<KEY> comparator;
    private Deserializer<KEY> keyDeserializer;
    private Deserializer<VALUE> valDeserializer;
    private DataInputBuffer keyIn = new DataInputBuffer();
    private DataInputBuffer valueIn = new DataInputBuffer();
    private TezCounter inputKeyCounter;
    private TezCounter inputValueCounter;
    private int keyCtr = 0;
    private boolean hasMoreValues;
    private boolean isFirstRecord = true;

    public ValuesIterator(TezRawKeyValueIterator in, RawComparator<KEY> comparator, Class<KEY> keyClass, Class<VALUE> valClass, Configuration conf, TezCounter inputKeyCounter, TezCounter inputValueCounter) throws IOException {
        this.in = in;
        this.comparator = comparator;
        this.inputKeyCounter = inputKeyCounter;
        this.inputValueCounter = inputValueCounter;
        SerializationFactory serializationFactory = new SerializationFactory(conf);
        this.keyDeserializer = serializationFactory.getDeserializer(keyClass);
        this.keyDeserializer.open((InputStream)this.keyIn);
        this.valDeserializer = serializationFactory.getDeserializer(valClass);
        this.valDeserializer.open((InputStream)this.valueIn);
        LOG.info((Object)("keyDeserializer=" + this.keyDeserializer + "; valueDeserializer=" + this.valDeserializer));
    }

    TezRawKeyValueIterator getRawIterator() {
        return this.in;
    }

    public boolean moveToNext() throws IOException {
        if (this.isFirstRecord) {
            this.readNextKey();
            this.key = this.nextKey;
            this.nextKey = null;
            this.hasMoreValues = this.more;
            this.isFirstRecord = false;
        } else {
            this.nextKey();
        }
        return this.more;
    }

    public KEY getKey() {
        return this.key;
    }

    public Iterable<VALUE> getValues() {
        return new Iterable<VALUE>(){

            @Override
            public Iterator<VALUE> iterator() {
                return new Iterator<VALUE>(){
                    private final int keyNumber;
                    {
                        this.keyNumber = ValuesIterator.this.keyCtr;
                    }

                    @Override
                    public boolean hasNext() {
                        return ValuesIterator.this.hasMoreValues;
                    }

                    @Override
                    public VALUE next() {
                        if (!ValuesIterator.this.hasMoreValues) {
                            throw new NoSuchElementException("iterate past last value");
                        }
                        Preconditions.checkState((this.keyNumber == ValuesIterator.this.keyCtr ? 1 : 0) != 0, (Object)"Cannot use values iterator on the previous K-V pair after moveToNext has been invoked to move to the next K-V pair");
                        try {
                            ValuesIterator.this.readNextValue();
                            ValuesIterator.this.readNextKey();
                        }
                        catch (IOException ie) {
                            throw new RuntimeException("problem advancing post rec#" + ValuesIterator.this.keyCtr, ie);
                        }
                        ValuesIterator.this.inputValueCounter.increment(1L);
                        return ValuesIterator.this.value;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Cannot remove elements");
                    }
                };
            }
        };
    }

    private void nextKey() throws IOException {
        while (this.hasMoreValues) {
            this.readNextKey();
        }
        if (this.more) {
            this.inputKeyCounter.increment(1L);
            ++this.keyCtr;
        }
        KEY tmpKey = this.key;
        this.key = this.nextKey;
        this.nextKey = tmpKey;
        this.hasMoreValues = this.more;
    }

    private void readNextKey() throws IOException {
        this.more = this.in.next();
        if (this.more) {
            DataInputBuffer nextKeyBytes = this.in.getKey();
            this.keyIn.reset(nextKeyBytes.getData(), nextKeyBytes.getPosition(), nextKeyBytes.getLength() - nextKeyBytes.getPosition());
            this.nextKey = this.keyDeserializer.deserialize(this.nextKey);
            this.hasMoreValues = this.key != null && this.comparator.compare(this.key, this.nextKey) == 0;
        } else {
            this.hasMoreValues = false;
        }
    }

    private void readNextValue() throws IOException {
        DataInputBuffer nextValueBytes = this.in.getValue();
        this.valueIn.reset(nextValueBytes.getData(), nextValueBytes.getPosition(), nextValueBytes.getLength() - nextValueBytes.getPosition());
        this.value = this.valDeserializer.deserialize(this.value);
    }
}

