/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.sort.impl.dflt;

import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.util.DataChecksum;
import org.apache.tez.runtime.api.TezOutputContext;
import org.apache.tez.runtime.library.common.shuffle.impl.ShuffleHeader;
import org.apache.tez.runtime.library.common.shuffle.server.ShuffleHandler;
import org.apache.tez.runtime.library.common.sort.impl.dflt.DefaultSorter;
import org.apache.tez.runtime.library.common.sort.impl.dflt.SortBufferInputStream;

public class InMemoryShuffleSorter
extends DefaultSorter {
    private static final Log LOG = LogFactory.getLog(InMemoryShuffleSorter.class);
    static final int IFILE_EOF_LENGTH = 2 * WritableUtils.getVIntSize((long)-1L);
    static final int IFILE_CHECKSUM_LENGTH = DataChecksum.Type.CRC32.size;
    private List<Integer> spillIndices = new ArrayList<Integer>();
    private List<ShuffleHeader> shuffleHeaders = new ArrayList<ShuffleHeader>();
    ShuffleHandler shuffleHandler = new ShuffleHandler(this);
    byte[] kvbuffer;
    IntBuffer kvmeta;

    public void initialize(TezOutputContext outputContext, Configuration conf, int numOutputs) throws IOException {
        super.initialize(outputContext, conf, numOutputs);
        this.shuffleHandler.initialize(outputContext, conf);
    }

    protected void spill(int mstart, int mend) throws IOException, InterruptedException {
        this.shuffleHandler.start();
        this.kvbuffer = ((DefaultSorter)this).kvbuffer;
        this.kvmeta = ((DefaultSorter)this).kvmeta;
        int spindex = mstart;
        for (int i = 0; i < this.partitions; ++i) {
            this.spillIndices.add(spindex);
            int length = 0;
            while (spindex < mend && this.kvmeta.get(this.offsetFor(spindex) + 3) == i) {
                int kvoff = this.offsetFor(spindex);
                int keyLen = this.kvmeta.get(kvoff + 1) - this.kvmeta.get(kvoff + 2);
                int valLen = this.getInMemVBytesLength(kvoff);
                length += keyLen + WritableUtils.getVIntSize((long)keyLen) + (valLen + WritableUtils.getVIntSize((long)valLen));
                ++spindex;
            }
            this.shuffleHeaders.add(new ShuffleHeader(this.outputContext.getUniqueIdentifier(), (length += IFILE_EOF_LENGTH) + IFILE_CHECKSUM_LENGTH, length, i));
            LOG.info((Object)("shuffleHeader[" + i + "]:" + " rawLen=" + length + " partLen=" + (length + IFILE_CHECKSUM_LENGTH) + " spillIndex=" + this.spillIndices.get(i)));
        }
        LOG.info((Object)("Saved " + this.spillIndices.size() + " spill-indices and " + this.shuffleHeaders.size() + " shuffle headers"));
    }

    public InputStream getSortedStream(int partition) {
        return new SortBufferInputStream(this, partition);
    }

    public void close() throws IOException {
    }

    public ShuffleHeader getShuffleHeader(int reduce) {
        return this.shuffleHeaders.get(reduce);
    }

    public int getSpillIndex(int partition) {
        return this.spillIndices.get(partition);
    }
}

