/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle;

import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.http.HttpConnectionParams;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.FetchedInputAllocator;
import org.apache.tez.runtime.library.common.shuffle.Fetcher;
import org.apache.tez.runtime.library.common.shuffle.FetcherCallback;
import org.apache.tez.runtime.library.common.shuffle.FetcherErrorTestingConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetcherWithInjectableErrors
extends Fetcher {
    private static final Logger LOG = LoggerFactory.getLogger(FetcherWithInjectableErrors.class);
    private FetcherErrorTestingConfig fetcherErrorTestingConfig;
    private String srcNameTrimmed;

    protected FetcherWithInjectableErrors(FetcherCallback fetcherCallback, HttpConnectionParams params, FetchedInputAllocator inputManager, InputContext inputContext, JobTokenSecretManager jobTokenSecretManager, Configuration conf, RawLocalFileSystem localFs, LocalDirAllocator localDirAllocator, Path lockPath, boolean localDiskFetchEnabled, boolean sharedFetchEnabled, String localHostname, int shufflePort, boolean asyncHttp, boolean verifyDiskChecksum, boolean compositeFetch) {
        super(fetcherCallback, params, inputManager, inputContext, jobTokenSecretManager, conf, localFs, localDirAllocator, lockPath, localDiskFetchEnabled, sharedFetchEnabled, localHostname, shufflePort, asyncHttp, verifyDiskChecksum, compositeFetch);
        this.fetcherErrorTestingConfig = new FetcherErrorTestingConfig(conf, inputContext.getObjectRegistry());
        this.srcNameTrimmed = TezUtilsInternal.cleanVertexName((String)inputContext.getSourceVertexName());
        LOG.info("Initialized FetcherWithInjectableErrors with config: {}", (Object)this.fetcherErrorTestingConfig);
    }

    @Override
    protected void setupConnectionInternal(String host, Collection<InputAttemptIdentifier> attempts) throws IOException, InterruptedException {
        LOG.info("Checking if fetcher should fail for host: {} ...", (Object)host);
        for (InputAttemptIdentifier inputAttemptIdentifier : attempts) {
            if (!this.fetcherErrorTestingConfig.shouldFail(host, this.srcNameTrimmed, inputAttemptIdentifier)) continue;
            throw new IOException(String.format("FetcherWithInjectableErrors tester made failure for host: %s, input attempt: %s", host, inputAttemptIdentifier.getAttemptNumber()));
        }
        super.setupConnectionInternal(host, attempts);
    }

    @Override
    public int hashCode() {
        return this.fetcherIdentifier;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FetcherWithInjectableErrors other = (FetcherWithInjectableErrors)((Object)obj);
        return this.fetcherIdentifier == other.fetcherIdentifier;
    }
}

