/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.api.EntityDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.InputReadyTracker;
import org.apache.tez.runtime.LogicalIOProcessorRuntimeTask;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.ExecutionContext;
import org.apache.tez.runtime.api.Input;
import org.apache.tez.runtime.api.ObjectRegistry;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezTaskContextImpl;
import org.apache.tez.runtime.api.impl.TezUmbilical;
import org.apache.tez.runtime.common.resources.MemoryDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezProcessorContextImpl
extends TezTaskContextImpl
implements ProcessorContext {
    private static final Logger LOG = LoggerFactory.getLogger(TezProcessorContextImpl.class);
    private volatile UserPayload userPayload;
    private volatile InputReadyTracker inputReadyTracker;
    private final EventMetaData sourceInfo;

    public TezProcessorContextImpl(Configuration conf, String[] workDirs, int appAttemptNumber, TezUmbilical tezUmbilical, String dagName, String vertexName, int vertexParallelism, TezTaskAttemptID taskAttemptID, @Nullable UserPayload userPayload, LogicalIOProcessorRuntimeTask runtimeTask, Map<String, ByteBuffer> serviceConsumerMetadata, Map<String, String> auxServiceEnv, MemoryDistributor memDist, ProcessorDescriptor processorDescriptor, InputReadyTracker inputReadyTracker, ObjectRegistry objectRegistry, ExecutionContext ExecutionContext2, long memAvailable) {
        super(conf, workDirs, appAttemptNumber, dagName, vertexName, vertexParallelism, taskAttemptID, runtimeTask.addAndGetTezCounter(vertexName), runtimeTask, tezUmbilical, serviceConsumerMetadata, auxServiceEnv, memDist, (EntityDescriptor<?>)processorDescriptor, objectRegistry, ExecutionContext2, memAvailable);
        Preconditions.checkNotNull((Object)inputReadyTracker, (Object)"inputReadyTracker is null");
        this.userPayload = userPayload;
        this.sourceInfo = new EventMetaData(EventMetaData.EventProducerConsumerType.PROCESSOR, this.taskVertexName, "", taskAttemptID);
        this.inputReadyTracker = inputReadyTracker;
    }

    public void sendEvents(List<Event> events) {
        Preconditions.checkNotNull(events, (Object)"events are null");
        ArrayList<TezEvent> tezEvents = new ArrayList<TezEvent>(events.size());
        for (Event e : events) {
            TezEvent tEvt = new TezEvent(e, this.sourceInfo);
            tezEvents.add(tEvt);
        }
        this.tezUmbilical.addEvents(tezEvents);
    }

    public UserPayload getUserPayload() {
        return this.userPayload;
    }

    public void setProgress(float progress) {
        this.runtimeTask.setProgress(progress);
        this.notifyProgress();
    }

    public void fatalError(Throwable exception, String message) {
        super.signalFatalError(exception, message, this.sourceInfo);
    }

    public boolean canCommit() throws IOException {
        return this.tezUmbilical.canCommit(this.taskAttemptID);
    }

    public Input waitForAnyInputReady(Collection<Input> inputs) throws InterruptedException {
        return this.inputReadyTracker.waitForAnyInputReady(inputs);
    }

    public void waitForAllInputsReady(Collection<Input> inputs) throws InterruptedException {
        this.inputReadyTracker.waitForAllInputsReady(inputs);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.userPayload = null;
        this.inputReadyTracker = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cleared TezProcessorContextImpl related information");
        }
    }
}

