/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.RuntimeTask;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.TezProcessorContext;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezTaskContextImpl;
import org.apache.tez.runtime.api.impl.TezUmbilical;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TezProcessorContextImpl
extends TezTaskContextImpl
implements TezProcessorContext {
    private final byte[] userPayload;
    private final EventMetaData sourceInfo;

    public TezProcessorContextImpl(Configuration conf, int appAttemptNumber, TezUmbilical tezUmbilical, String vertexName, TezTaskAttemptID taskAttemptID, TezCounters counters, byte[] userPayload, RuntimeTask runtimeTask, Map<String, ByteBuffer> serviceConsumerMetadata, Map<String, String> auxServiceEnv) {
        super(conf, appAttemptNumber, vertexName, taskAttemptID, counters, runtimeTask, tezUmbilical, serviceConsumerMetadata, auxServiceEnv);
        this.userPayload = userPayload;
        this.sourceInfo = new EventMetaData(EventMetaData.EventProducerConsumerType.PROCESSOR, this.taskVertexName, "", taskAttemptID);
    }

    public void sendEvents(List<Event> events) {
        ArrayList<TezEvent> tezEvents = new ArrayList<TezEvent>(events.size());
        for (Event e : events) {
            TezEvent tEvt = new TezEvent(e, this.sourceInfo);
            tezEvents.add(tEvt);
        }
        this.tezUmbilical.addEvents(tezEvents);
    }

    public byte[] getUserPayload() {
        return this.userPayload;
    }

    public void setProgress(float progress) {
        this.runtimeTask.setProgress(progress);
    }

    public void fatalError(Throwable exception, String message) {
        super.signalFatalError(exception, message, this.sourceInfo);
    }

    public boolean canCommit() throws IOException {
        return this.tezUmbilical.canCommit(this.taskAttemptID);
    }
}

