/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.RuntimeTask;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.TezOutputContext;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezTaskContextImpl;
import org.apache.tez.runtime.api.impl.TezUmbilical;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TezOutputContextImpl
extends TezTaskContextImpl
implements TezOutputContext {
    private final byte[] userPayload;
    private final String destinationVertexName;
    private final EventMetaData sourceInfo;

    @InterfaceAudience.Private
    public TezOutputContextImpl(Configuration conf, int appAttemptNumber, TezUmbilical tezUmbilical, String taskVertexName, String destinationVertexName, TezTaskAttemptID taskAttemptID, TezCounters counters, byte[] userPayload, RuntimeTask runtimeTask, Map<String, ByteBuffer> serviceConsumerMetadata, Map<String, String> auxServiceEnv) {
        super(conf, appAttemptNumber, taskVertexName, taskAttemptID, counters, runtimeTask, tezUmbilical, serviceConsumerMetadata, auxServiceEnv);
        this.userPayload = userPayload;
        this.destinationVertexName = destinationVertexName;
        this.sourceInfo = new EventMetaData(EventMetaData.EventProducerConsumerType.OUTPUT, taskVertexName, destinationVertexName, taskAttemptID);
    }

    public void sendEvents(List<Event> events) {
        ArrayList<TezEvent> tezEvents = new ArrayList<TezEvent>(events.size());
        for (Event e : events) {
            TezEvent tEvt = new TezEvent(e, this.sourceInfo);
            tezEvents.add(tEvt);
        }
        this.tezUmbilical.addEvents(tezEvents);
    }

    public byte[] getUserPayload() {
        return this.userPayload;
    }

    public String getDestinationVertexName() {
        return this.destinationVertexName;
    }

    public void fatalError(Throwable exception, String message) {
        super.signalFatalError(exception, message, this.sourceInfo);
    }
}

