/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezUmbilical;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RuntimeTask {
    protected AtomicBoolean hasFatalError = new AtomicBoolean(false);
    protected Throwable fatalError = null;
    protected String fatalErrorMessage = null;
    protected float progress;
    protected final TezCounters tezCounters;
    protected final TaskSpec taskSpec;
    protected final Configuration tezConf;
    protected final TezUmbilical tezUmbilical;
    protected final AtomicInteger eventCounter;
    private final AtomicBoolean taskDone;
    protected State state;

    protected RuntimeTask(TaskSpec taskSpec, Configuration tezConf, TezUmbilical tezUmbilical) {
        this.taskSpec = taskSpec;
        this.tezConf = tezConf;
        this.tezUmbilical = tezUmbilical;
        this.tezCounters = new TezCounters();
        this.eventCounter = new AtomicInteger(0);
        this.progress = 0.0f;
        this.taskDone = new AtomicBoolean(false);
    }

    public String getVertexName() {
        return this.taskSpec.getVertexName();
    }

    public void setFatalError(Throwable t, String message) {
        this.hasFatalError.set(true);
        this.fatalError = t;
        this.fatalErrorMessage = message;
    }

    public boolean hadFatalError() {
        return this.hasFatalError.get();
    }

    public synchronized void setProgress(float progress) {
        this.progress = progress;
    }

    public synchronized float getProgress() {
        return this.progress;
    }

    public TezCounters getCounters() {
        return this.tezCounters;
    }

    public TezTaskAttemptID getTaskAttemptID() {
        return this.taskSpec.getTaskAttemptID();
    }

    public abstract void handleEvents(Collection<TezEvent> var1);

    public int getEventCounter() {
        return this.eventCounter.get();
    }

    public boolean isTaskDone() {
        return this.taskDone.get();
    }

    protected void setTaskDone() {
        this.taskDone.set(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        NEW,
        INITED,
        RUNNING,
        CLOSED;

    }
}

