/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.tez.runtime.api.impl.TaskSpec;

public class ContainerTask
implements Writable {
    TaskSpec taskSpec;
    boolean shouldDie;

    public ContainerTask() {
    }

    public ContainerTask(TaskSpec taskSpec, boolean shouldDie) {
        this.taskSpec = taskSpec;
        this.shouldDie = shouldDie;
    }

    public TaskSpec getTaskSpec() {
        return this.taskSpec;
    }

    public boolean shouldDie() {
        return this.shouldDie;
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.shouldDie);
        if (this.taskSpec != null) {
            out.writeBoolean(true);
            this.taskSpec.write(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.shouldDie = in.readBoolean();
        boolean taskComing = in.readBoolean();
        if (taskComing) {
            this.taskSpec = new TaskSpec();
            this.taskSpec.readFields(in);
        }
    }

    public String toString() {
        return "shouldDie: " + this.shouldDie + ", TaskSpec: " + this.taskSpec;
    }
}

