/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.metrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.yarn.util.ResourceCalculatorProcessTree;
import org.apache.tez.common.GcTimeUpdater;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.runtime.metrics.FileSystemStatisticUpdater;
import org.apache.tez.util.TezMxBeanResourceCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCounterUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(TaskCounterUpdater.class);
    private final TezCounters tezCounters;
    private final Configuration conf;
    private Map<String, FileSystemStatisticUpdater> statisticUpdaters = new HashMap<String, FileSystemStatisticUpdater>();
    protected final GcTimeUpdater gcUpdater;
    private ResourceCalculatorProcessTree pTree;
    private long initCpuCumulativeTime = 0L;
    private final String pid;

    public TaskCounterUpdater(TezCounters counters, Configuration conf, String pid) {
        this.tezCounters = counters;
        this.conf = conf;
        this.gcUpdater = new GcTimeUpdater(this.tezCounters);
        this.pid = pid;
        this.initResourceCalculatorPlugin();
        this.recordInitialCpuStats();
    }

    public void updateCounters() {
        HashMap map = new HashMap();
        for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
            List<FileSystem.Statistics> list;
            String uriScheme = statistics.getScheme();
            if (map.containsKey(uriScheme)) {
                list = (List)map.get(uriScheme);
                list.add(statistics);
                continue;
            }
            list = new ArrayList();
            list.add(statistics);
            map.put(uriScheme, list);
        }
        for (Map.Entry entry : map.entrySet()) {
            FileSystemStatisticUpdater updater = this.statisticUpdaters.get(entry.getKey());
            if (updater == null) {
                updater = new FileSystemStatisticUpdater(this.tezCounters, (List)entry.getValue(), (String)entry.getKey());
                this.statisticUpdaters.put((String)entry.getKey(), updater);
            }
            updater.updateCounters();
        }
        this.gcUpdater.incrementGcCounter();
        this.updateResourceCounters();
    }

    private void recordInitialCpuStats() {
        if (this.pTree != null) {
            this.pTree.updateProcessTree();
            this.initCpuCumulativeTime = this.pTree.getCumulativeCpuTime();
        }
    }

    void updateResourceCounters() {
        this.updateHeapUsageCounter();
        if (this.pTree == null) {
            return;
        }
        this.pTree.updateProcessTree();
        long cpuTime = this.pTree.getCumulativeCpuTime();
        long pMem = this.pTree.getRssMemorySize();
        long vMem = this.pTree.getVirtualMemorySize();
        this.tezCounters.findCounter((Enum)TaskCounter.CPU_MILLISECONDS).setValue(cpuTime -= this.initCpuCumulativeTime);
        this.tezCounters.findCounter((Enum)TaskCounter.PHYSICAL_MEMORY_BYTES).setValue(pMem);
        this.tezCounters.findCounter((Enum)TaskCounter.VIRTUAL_MEMORY_BYTES).setValue(vMem);
    }

    private void updateHeapUsageCounter() {
        long currentHeapUsage = Runtime.getRuntime().totalMemory();
        this.tezCounters.findCounter((Enum)TaskCounter.COMMITTED_HEAP_BYTES).setValue(currentHeapUsage);
    }

    private void initResourceCalculatorPlugin() {
        Class clazz = this.conf.getClass("tez.task.resource.calculator.process-tree.class", TezMxBeanResourceCalculator.class, ResourceCalculatorProcessTree.class);
        this.pTree = ResourceCalculatorProcessTree.getResourceCalculatorProcessTree((String)this.pid, (Class)clazz, (Configuration)this.conf);
        LOG.info("Using ResourceCalculatorProcessTree : " + clazz.getName());
    }
}

